/**
 * SEO Metadata Configuration for BusyNepal
 * This file contains Next.js metadata exports for all pages
 * Last Updated: January 28, 2026
 */

import type { Metadata } from "next";

// HOME PAGE METADATA
export const homeMetadata: Metadata = {
  title: "Busy Accounting Software in Nepal | Authorized Distributor | Neha Infotech",
  description: "Authorized Busy Accounting Software distributor in Nepal. Busy 21, Busy on Cloud, IRD-approved billing software. GST, VAT, tax compliance. Free demo & 24/7 support.",
  keywords: [
    "Busy Software Nepal",
    "Busy Accounting",
    "Busy 21",
    "Busy on Cloud",
    "E-billing Software Nepal",
    "Accounting Software in Nepal",
    "IRD Software Nepal",
    "VAT Billing Software Nepal",
    "GST Accounting Software",
  ],
  openGraph: {
    title: "Busy Accounting Software - Nepal's #1 Distributor | Neha Infotech",
    description: "Get Busy accounting software for your Nepali business. IRD-approved, GST-compliant, 24/7 support.",
    url: "https://busynepal.com",
    type: "website",
  },
  alternates: {
    canonical: "https://busynepal.com",
  },
};

// PRODUCTS PAGE METADATA
export const productsMetadata: Metadata = {
  title: "Busy Accounting Software Products | Busy 21, Busy on Cloud | Nepal",
  description: "Explore Busy software solutions: Busy 21 Basic, Standard, Enterprise, and Busy on Cloud. Find the perfect accounting software for your business needs.",
  keywords: [
    "Busy 21",
    "Busy on Cloud",
    "Accounting Software",
    "Business Software Nepal",
    "Inventory Management",
    "Busy 21 Basic",
    "Busy 21 Standard",
    "Busy 21 Enterprise",
  ],
  openGraph: {
    title: "Busy Accounting Software Products - Nepal",
    description: "Busy 21 Basic, Standard, Enterprise & Cloud. Choose the perfect accounting solution for your business.",
    url: "https://busynepal.com/products",
    type: "website",
  },
  alternates: {
    canonical: "https://busynepal.com/products",
  },
};

// SERVICES PAGE METADATA
export const servicesMetadata: Metadata = {
  title: "Accounting Software Services | Training, Support, Setup | Neha Infotech",
  description: "Professional Busy software services: installation, training, data migration, VAT compliance, IRD setup, 24/7 support. Expert guidance for your business.",
  keywords: [
    "Software Training",
    "VAT Billing Software",
    "IRD Software",
    "Accounting Services",
    "Data Migration",
    "GST Compliance",
    "Technical Support",
    "Software Installation",
  ],
  openGraph: {
    title: "Busy Accounting Software Services - Training & Support",
    description: "Professional installation, training, VAT compliance, and 24/7 support services for Busy accounting software.",
    url: "https://busynepal.com/services",
    type: "website",
  },
  alternates: {
    canonical: "https://busynepal.com/services",
  },
};

// ABOUT PAGE METADATA
export const aboutMetadata: Metadata = {
  title: "About Us | Authorized Busy Software Distributor Nepal | Neha Infotech",
  description: "Neha Infotech: Your trusted Busy Software distributor in Nepal since 2015. Authorized dealer, expert team, 1000+ satisfied customers.",
  keywords: [
    "Busy Distributor Nepal",
    "Authorized Dealer",
    "Company Information",
    "About Busy Software",
    "Neha Infotech",
    "Business Software Provider",
  ],
  openGraph: {
    title: "About Neha Infotech - Busy Software Distributor",
    description: "Learn about Neha Infotech, Nepal's leading Busy accounting software distributor.",
    url: "https://busynepal.com/about",
    type: "website",
  },
  alternates: {
    canonical: "https://busynepal.com/about",
  },
};

// BLOG PAGE METADATA
export const blogMetadata: Metadata = {
  title: "Accounting & Business Blog | Busy Software Tips, Guides & Updates | Nepal",
  description: "Expert articles on accounting, tax compliance, GST, VAT billing in Nepal. Busy software tips, business guides, and industry updates.",
  keywords: [
    "Accounting Tips",
    "Business Blog",
    "Tax Compliance",
    "GST Guide",
    "Busy Software Tips",
    "Business News Nepal",
  ],
  openGraph: {
    title: "Blog - Accounting Tips & Business Guides",
    description: "Read expert articles on accounting software, tax compliance, and business management in Nepal.",
    url: "https://busynepal.com/blog",
    type: "website",
  },
  alternates: {
    canonical: "https://busynepal.com/blog",
  },
};

// DOWNLOADS PAGE METADATA
export const downloadsMetadata: Metadata = {
  title: "Download Busy Software | Free Trial, Setup Files, Documentation | Nepal",
  description: "Download Busy accounting software, trial versions, documentation, setup guides. Free downloads for Busy 21 and Busy on Cloud.",
  keywords: [
    "Download Software",
    "Free Trial",
    "Busy Software Download",
    "Setup Files",
    "Documentation",
  ],
  openGraph: {
    title: "Download Busy Accounting Software",
    description: "Download Busy software, trial versions, and documentation for free.",
    url: "https://busynepal.com/downloads",
    type: "website",
  },
  alternates: {
    canonical: "https://busynepal.com/downloads",
  },
};

// TESTIMONIALS PAGE METADATA
export const testimonialsMetadata: Metadata = {
  title: "Customer Reviews & Testimonials | Busy Software Reviews | Nepal",
  description: "Read 1000+ customer testimonials and reviews for Busy accounting software. Real feedback from businesses across Nepal.",
  keywords: [
    "Customer Reviews",
    "Testimonials",
    "Software Reviews",
    "User Feedback",
    "Business Reviews",
  ],
  openGraph: {
    title: "Customer Testimonials - Busy Software Reviews",
    description: "See what 1000+ businesses say about Busy accounting software.",
    url: "https://busynepal.com/testimonials",
    type: "website",
  },
  alternates: {
    canonical: "https://busynepal.com/testimonials",
  },
};

// FAQ PAGE METADATA
export const faqMetadata: Metadata = {
  title: "FAQ - Frequently Asked Questions | Busy Software | Nepal",
  description: "Answers to common questions about Busy accounting software, pricing, installation, features, support, and more.",
  keywords: [
    "FAQ",
    "Questions",
    "Help",
    "Busy Software FAQ",
    "Support Questions",
  ],
  openGraph: {
    title: "FAQ - Busy Software Questions Answered",
    description: "Find answers to frequently asked questions about Busy accounting software.",
    url: "https://busynepal.com/faq",
    type: "website",
  },
  alternates: {
    canonical: "https://busynepal.com/faq",
  },
};

// CONTACT PAGE METADATA
export const contactMetadata: Metadata = {
  title: "Contact Us | Busy Software Support | Neha Infotech | Nepal",
  description: "Contact Neha Infotech for Busy software support, sales inquiries, training, or customization. 24/7 customer support available.",
  keywords: [
    "Contact Us",
    "Support",
    "Customer Service",
    "Sales",
    "Help",
  ],
  openGraph: {
    title: "Contact Neha Infotech - Busy Software Support",
    description: "Get in touch with our support team for Busy software assistance.",
    url: "https://busynepal.com/contact",
    type: "website",
  },
  alternates: {
    canonical: "https://busynepal.com/contact",
  },
};

// PRODUCT DETAIL PAGES METADATA
export const product21BasicMetadata: Metadata = {
  title: "Busy 21 Basic - Accounting Software for Small Business | Nepal",
  description: "Busy 21 Basic: Perfect for small businesses. Basic accounting, inventory, GST reports, multi-user support. Affordable accounting solution.",
  keywords: [
    "Busy 21 Basic",
    "Small Business Accounting",
    "Budget Accounting Software",
    "Accounting Software",
  ],
  openGraph: {
    title: "Busy 21 Basic - Small Business Accounting Software",
    description: "Affordable accounting software for small businesses in Nepal.",
    url: "https://busynepal.com/products/busy-21-basic",
    type: "website",
  },
  alternates: {
    canonical: "https://busynepal.com/products/busy-21-basic",
  },
};

export const product21StandardMetadata: Metadata = {
  title: "Busy 21 Standard - Growing Business Accounting Software | Nepal",
  description: "Busy 21 Standard: For growing businesses. Advanced accounting, mobile app, IRD billing, production module. Comprehensive accounting solution.",
  keywords: [
    "Busy 21 Standard",
    "Business Accounting",
    "Growing Business Software",
    "IRD Billing Software",
  ],
  openGraph: {
    title: "Busy 21 Standard - Business Accounting Software",
    description: "Advanced accounting software for growing businesses in Nepal.",
    url: "https://busynepal.com/products/busy-21-standard",
    type: "website",
  },
  alternates: {
    canonical: "https://busynepal.com/products/busy-21-standard",
  },
};

export const product21EnterpriseMetadata: Metadata = {
  title: "Busy 21 Enterprise - Large Business Accounting Software | Nepal",
  description: "Busy 21 Enterprise: For large enterprises. All features + multi-location, IRD billing, payroll, advanced reporting. Complete accounting platform.",
  keywords: [
    "Busy 21 Enterprise",
    "Enterprise Accounting",
    "Large Business Software",
    "Payroll Software",
  ],
  openGraph: {
    title: "Busy 21 Enterprise - Enterprise Accounting Software",
    description: "Complete accounting software for large enterprises in Nepal.",
    url: "https://busynepal.com/products/busy-21-enterprise",
    type: "website",
  },
  alternates: {
    canonical: "https://busynepal.com/products/busy-21-enterprise",
  },
};

export const busyOnCloudMetadata: Metadata = {
  title: "Busy on Cloud - Cloud-Based Accounting Software | Nepal",
  description: "Busy on Cloud: Access accounting from anywhere. Cloud-based, real-time sync, IRD-approved, auto-backup. Modern accounting solution.",
  keywords: [
    "Busy on Cloud",
    "Cloud Accounting",
    "Cloud-Based Software",
    "Online Accounting",
    "Remote Access",
  ],
  openGraph: {
    title: "Busy on Cloud - Cloud Accounting Software",
    description: "Access your accounting from anywhere with Busy on Cloud.",
    url: "https://busynepal.com/products/busy-on-cloud",
    type: "website",
  },
  alternates: {
    canonical: "https://busynepal.com/products/busy-on-cloud",
  },
};
