/**
 * Page Registry - Maps all application pages with their metadata
 * This is used by the dashboard to display and manage existing pages
 */

export interface PageMetadata {
  id: string;
  title: string;
  slug: string;
  path: string;
  description: string;
  content: string;
  type: 'system' | 'custom';
  editorType: 'visual' | 'code' | 'builder';  // Add 'builder' here
  createdAt: string;
}

export const pageRegistry: PageMetadata[] = [
  {
    id: 'home',
    title: 'Home',
    slug: 'home',
    path: '/',
    description: 'Main landing page showcasing Busy software products and features',
    type: 'system',
    editorType: 'code',
    createdAt: new Date().toISOString(),
    content: '',
  },
  {
    id: 'about',
    title: 'About Us',
    slug: 'about',
    path: '/about',
    description: 'Company information, team, mission, vision, and company history',
    type: 'system',
    editorType: 'code',
    createdAt: new Date().toISOString(),
    content: '',
  },
  {
    id: 'services',
    title: 'Services',
    slug: 'services',
    path: '/services',
    description: 'Service offerings including installation, training, support, and customization',
    type: 'system',
    editorType: 'code',
    createdAt: new Date().toISOString(),
    content: '',
  },
  {
    id: 'products',
    title: 'Products',
    slug: 'products',
    path: '/products',
    description: 'Busy software products lineup (Basic, Standard, Enterprise, Cloud)',
    type: 'system',
    editorType: 'code',
    createdAt: new Date().toISOString(),
    content: '',
  },
  {
    id: 'products-busy-21-basic',
    title: 'Busy 21 Basic',
    slug: 'products/busy-21-basic',
    path: '/products/busy-21-basic',
    description: 'Product details for Busy 21 Basic edition',
    type: 'system',
    editorType: 'code',
    createdAt: new Date().toISOString(),
    content: '',
  },
  {
    id: 'products-busy-21-standard',
    title: 'Busy 21 Standard',
    slug: 'products/busy-21-standard',
    path: '/products/busy-21-standard',
    description: 'Product details for Busy 21 Standard edition',
    type: 'system',
    editorType: 'code',
    createdAt: new Date().toISOString(),
    content: '',
  },
  {
    id: 'products-busy-21-enterprise',
    title: 'Busy 21 Enterprise',
    slug: 'products/busy-21-enterprise',
    path: '/products/busy-21-enterprise',
    description: 'Product details for Busy 21 Enterprise edition',
    type: 'system',
    editorType: 'code',
    createdAt: new Date().toISOString(),
    content: '',
  },
  {
    id: 'products-busy-on-cloud',
    title: 'Busy on Cloud',
    slug: 'products/busy-on-cloud',
    path: '/products/busy-on-cloud',
    description: 'Product details for Busy on Cloud edition',
    type: 'system',
    editorType: 'code',
    createdAt: new Date().toISOString(),
    content: '',
  },
  {
    id: 'contact',
    title: 'Contact Us',
    slug: 'contact',
    path: '/contact',
    description: 'Contact form and business information',
    type: 'system',
    editorType: 'code',
    createdAt: new Date().toISOString(),
    content: '',
  },
  {
    id: 'blog',
    title: 'Blog',
    slug: 'blog',
    path: '/blog',
    description: 'Blog and news articles',
    type: 'system',
    editorType: 'code',
    createdAt: new Date().toISOString(),
    content: '',
  },
  {
    id: 'downloads',
    title: 'Downloads',
    slug: 'downloads',
    path: '/downloads',
    description: 'Product downloads and resources',
    type: 'system',
    editorType: 'code',
    createdAt: new Date().toISOString(),
    content: '',
  },
];

/**
 * Get all available pages including system and custom pages
 */
export function getAllPages() {
  return pageRegistry;
}

/**
 * Get a page by ID
 */
export function getPageById(id: string) {
  return pageRegistry.find((p) => p.id === id);
}

/**
 * Get a page by slug
 */
export function getPageBySlug(slug: string) {
  return pageRegistry.find((p) => p.slug === slug);
}

/**
 * Get system pages only
 */
export function getSystemPages() {
  return pageRegistry.filter((p) => p.type === 'system');
}

/**
 * Get custom pages only (user-created)
 */
export function getCustomPages() {
  return pageRegistry.filter((p) => p.type === 'custom');
}
