'use client';

/**
 * Advanced Schema Markup for BusyNepal
 * Includes: Organization, LocalBusiness, Product, BreadcrumbList, FAQPage
 * Last Updated: January 28, 2026
 */

export function AdvancedSchemaMarkup() {
  // Organization Schema
  const organizationSchema = {
    "@context": "https://schema.org",
    "@type": "Organization",
    "name": "Neha Infotech - BusyNepal",
    "url": "https://busynepal.com",
    "logo": "https://busynepal.com/logo.png",
    "image": "https://busynepal.com/logo.png",
    "description": "Authorized Busy Accounting Software Distributor in Nepal. Providing complete accounting solutions, GST/VAT billing, and tax compliance software.",
    "foundingDate": "2015",
    "sameAs": [
      "https://www.facebook.com/profile.php?id=61574548711911",
      "https://youtube.com/@busynepal",
      "https://linkedin.com/company/busynepal",
      "https://instagram.com/nehainfotechh"
    ],
    "contactPoint": [
      {
        "@type": "ContactPoint",
        "telephone": "+977-9857834143",
        "contactType": "Customer Service",
        "email": "info@busynepal.com",
        "areaServed": "NP",
        "availableLanguage": ["en", "ne"]
      },
      {
        "@type": "ContactPoint",
        "telephone": "+977-9857834143",
        "contactType": "Sales",
        "email": "sales@busynepal.com",
        "areaServed": "NP"
      }
    ],
    "address": [
      {
        "@type": "PostalAddress",
        "streetAddress": "Nepalgunj-18",
        "addressLocality": "Banke",
        "addressRegion": "Banke",
        "postalCode": "21700",
        "addressCountry": "NP",
        "name": "Head Office"
      },
      {
        "@type": "PostalAddress",
        "streetAddress": "Ghorahi-15",
        "addressLocality": "Dang",
        "addressRegion": "Dang",
        "addressCountry": "NP",
        "name": "Branch Office"
      }
    ],
    "aggregateRating": {
      "@type": "AggregateRating",
      "ratingValue": "4.8",
      "reviewCount": "1200",
      "bestRating": "5",
      "worstRating": "1"
    }
  };

  // Local Business Schema
  const localBusinessSchema = {
    "@context": "https://schema.org",
    "@type": "LocalBusiness",
    "@id": "https://busynepal.com",
    "name": "Neha Infotech",
    "image": "https://busynepal.com/logo.png",
    "description": "Authorized Busy Accounting Software Distributor in Nepal",
    "url": "https://busynepal.com",
    "telephone": "+977-9857834143",
    "email": "info@busynepal.com",
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "Nepalgunj-18, Banke",
      "addressLocality": "Banke",
      "addressRegion": "Banke",
      "postalCode": "21700",
      "addressCountry": "NP"
    },
    "priceRange": "$$",
    "areaServed": {
      "@type": "Country",
      "name": "NP"
    },
    "availableLanguage": ["en", "ne"],
    "hours": {
      "@type": "OpeningHoursSpecification",
      "dayOfWeek": ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday"],
      "opens": "09:00",
      "closes": "18:00"
    },
    "aggregateRating": {
      "@type": "AggregateRating",
      "ratingValue": "4.8",
      "reviewCount": "1200"
    }
  };

  // Product Schema for Busy Software
  const productSchema = {
    "@context": "https://schema.org",
    "@type": "Product",
    "name": "Busy Accounting Software",
    "description": "Comprehensive accounting software solution with GST/VAT compliance, inventory management, and IRD approval.",
    "image": "https://busynepal.com/busy-product.png",
    "brand": {
      "@type": "Brand",
      "name": "Busy"
    },
    "offers": [
      {
        "@type": "Offer",
        "name": "Busy 21 Basic",
        "description": "Perfect for small businesses",
        "price": "Contact for price",
        "priceCurrency": "NPR",
        "availability": "https://schema.org/InStock",
        "url": "https://busynepal.com/products/busy-21-basic"
      },
      {
        "@type": "Offer",
        "name": "Busy 21 Standard",
        "description": "For growing businesses",
        "price": "Contact for price",
        "priceCurrency": "NPR",
        "availability": "https://schema.org/InStock",
        "url": "https://busynepal.com/products/busy-21-standard"
      },
      {
        "@type": "Offer",
        "name": "Busy 21 Enterprise",
        "description": "For large enterprises",
        "price": "Contact for price",
        "priceCurrency": "NPR",
        "availability": "https://schema.org/InStock",
        "url": "https://busynepal.com/products/busy-21-enterprise"
      },
      {
        "@type": "Offer",
        "name": "Busy on Cloud",
        "description": "Cloud-based accounting solution",
        "price": "Contact for price",
        "priceCurrency": "NPR",
        "availability": "https://schema.org/InStock",
        "url": "https://busynepal.com/products/busy-on-cloud"
      }
    ],
    "aggregateRating": {
      "@type": "AggregateRating",
      "ratingValue": "4.8",
      "reviewCount": "1200",
      "bestRating": "5",
      "worstRating": "1"
    }
  };

  // Breadcrumb Schema
  const breadcrumbSchema = {
    "@context": "https://schema.org",
    "@type": "BreadcrumbList",
    "itemListElement": [
      {
        "@type": "ListItem",
        "position": 1,
        "name": "Home",
        "item": "https://busynepal.com"
      },
      {
        "@type": "ListItem",
        "position": 2,
        "name": "Products",
        "item": "https://busynepal.com/products"
      },
      {
        "@type": "ListItem",
        "position": 3,
        "name": "Services",
        "item": "https://busynepal.com/services"
      },
      {
        "@type": "ListItem",
        "position": 4,
        "name": "Blog",
        "item": "https://busynepal.com/blog"
      },
      {
        "@type": "ListItem",
        "position": 5,
        "name": "Contact",
        "item": "https://busynepal.com/contact"
      }
    ]
  };

  // FAQ Schema
  const faqSchema = {
    "@context": "https://schema.org",
    "@type": "FAQPage",
    "mainEntity": [
      {
        "@type": "Question",
        "name": "What is Busy Accounting Software?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Busy is a comprehensive accounting software designed for businesses of all sizes. It offers features like accounting, inventory management, GST/VAT billing, and IRD compliance, all in an easy-to-use interface."
        }
      },
      {
        "@type": "Question",
        "name": "Is Busy Software IRD-Approved?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Yes, Busy accounting software is officially approved by Nepal's Inland Revenue Department (IRD) for VAT billing and tax compliance purposes."
        }
      },
      {
        "@type": "Question",
        "name": "What are the different versions of Busy 21?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Busy 21 comes in three editions: Basic (for small businesses), Standard (for growing businesses), and Enterprise (for large organizations). We also offer Busy on Cloud for remote access."
        }
      },
      {
        "@type": "Question",
        "name": "Do you provide training for Busy Software?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Yes, we provide comprehensive training programs including on-site training, online sessions, user manuals, and video tutorials to help your team master the software."
        }
      },
      {
        "@type": "Question",
        "name": "What is the cost of Busy Software in Nepal?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Pricing varies based on the version and features you choose. We offer different packages for small, medium, and large businesses. Contact us for a customized quote."
        }
      },
      {
        "@type": "Question",
        "name": "Do you offer customer support?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Yes, we provide 24/7 customer support through phone, email, remote desktop assistance, and on-site visits when needed."
        }
      }
    ]
  };

  // Software Application Schema
  const softwareAppSchema = {
    "@context": "https://schema.org",
    "@type": "SoftwareApplication",
    "name": "Busy Accounting Software",
    "description": "Complete accounting and inventory management solution with GST/VAT compliance and IRD approval",
    "applicationCategory": "BusinessApplication",
    "operatingSystem": "Windows",
    "url": "https://busynepal.com",
    "image": "https://busynepal.com/busy-product.png",
    "author": {
      "@type": "Organization",
      "name": "Tally Solutions"
    },
    "offers": {
      "@type": "Offer",
      "price": "Contact for quote",
      "priceCurrency": "NPR"
    },
    "aggregateRating": {
      "@type": "AggregateRating",
      "ratingValue": "4.8",
      "ratingCount": "1200"
    },
    "featureList": [
      "Accounting Management",
      "Inventory Management",
      "GST Billing",
      "VAT Compliance",
      "IRD Approval",
      "Multi-user Support",
      "Mobile App Access",
      "Cloud-based Option"
    ]
  };

  // Article Schema (for blog)
  const articleSchema = {
    "@context": "https://schema.org",
    "@type": "Article",
    "headline": "Expert Accounting & Business Articles",
    "description": "Read expert guides on accounting, tax compliance, GST, VAT billing, and business management.",
    "url": "https://busynepal.com/blog",
    "publisher": {
      "@type": "Organization",
      "name": "Neha Infotech",
      "url": "https://busynepal.com",
      "logo": {
        "@type": "ImageObject",
        "url": "https://busynepal.com/logo.png"
      }
    }
  };

  return (
    <>
      <script
        type="application/ld+json"
        dangerouslySetInnerHTML={{
          __html: JSON.stringify(organizationSchema),
        }}
      />
      <script
        type="application/ld+json"
        dangerouslySetInnerHTML={{
          __html: JSON.stringify(localBusinessSchema),
        }}
      />
      <script
        type="application/ld+json"
        dangerouslySetInnerHTML={{
          __html: JSON.stringify(productSchema),
        }}
      />
      <script
        type="application/ld+json"
        dangerouslySetInnerHTML={{
          __html: JSON.stringify(breadcrumbSchema),
        }}
      />
      <script
        type="application/ld+json"
        dangerouslySetInnerHTML={{
          __html: JSON.stringify(faqSchema),
        }}
      />
      <script
        type="application/ld+json"
        dangerouslySetInnerHTML={{
          __html: JSON.stringify(softwareAppSchema),
        }}
      />
      <script
        type="application/ld+json"
        dangerouslySetInnerHTML={{
          __html: JSON.stringify(articleSchema),
        }}
      />
    </>
  );
}
