'use client';

import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Badge } from '@/components/ui/badge';

// Update the component props interface to include 'builder'
interface PagePreviewProps {
  title: string;
  slug: string;
  content: string;
  editorType: 'visual' | 'code' | 'builder';
}

export const PagePreview = ({ title, slug, content, editorType }: PagePreviewProps) => {
  const renderContent = () => {
    if (editorType === 'code') {
      // For code editor, show syntax-highlighted preview
      return (
        <pre className="bg-gray-900 text-gray-100 p-4 rounded-lg overflow-auto text-sm font-mono max-h-96">
          <code>{content.substring(0, 500)}...</code>
        </pre>
      );
    }

    // For visual editor, parse markdown and HTML
    return (
      <div className="prose prose-sm max-w-none max-h-96 overflow-auto">
        <div className="whitespace-pre-wrap text-gray-700 leading-relaxed">
          {content}
        </div>
      </div>
    );
  };

  return (
    <Card className="border-dashed border-2">
      <CardHeader className="pb-3">
        <div className="flex items-start justify-between">
          <div>
            <CardTitle className="text-lg">{title || 'Untitled Page'}</CardTitle>
            <CardDescription className="mt-1">/{slug || 'slug-here'}</CardDescription>
          </div>
          <Badge variant="outline" className="text-xs">
            {editorType === 'visual' ? '🎨 Visual' : editorType === 'code' ? '💻 Code' : '🔧 Builder'}
          </Badge>
        </div>
      </CardHeader>
      <CardContent>
        <div className="space-y-3">
          <div>
            <p className="text-xs font-semibold text-gray-500 uppercase mb-2">Preview</p>
            {renderContent()}
          </div>
          <p className="text-xs text-gray-500 italic">
            {content.length} characters
          </p>
        </div>
      </CardContent>
    </Card>
  );
};
