import type { Metadata } from "next";

export const metadata: Metadata = {
  title: "Refund Policy | Busy Nepal",
  description: "Refund Policy for Busy Accounting Software. Learn about our terms regarding refunds.",
  keywords: ["refund policy", "busy software nepal"],
};

export default function RefundPolicy() {
  return (
    <div className="min-h-screen bg-gradient-to-b from-blue-50 to-white py-12 px-4 sm:px-6 lg:px-8">
      <div className="max-w-4xl mx-auto">
        <h1 className="text-4xl font-bold text-gray-900 mb-8">Refund Policy</h1>
        
        <div className="prose prose-lg max-w-none text-gray-700">
          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">1. Overview</h2>
            <p className="mb-4">
              At Neha Infotech, all sales are final. Once a purchase has been completed, it is non-refundable and non-cancellable under any circumstances.
            </p>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">2. Non-Refundable Policy</h2>
            <p className="mb-4">
              All purchases of our products and services are <strong>final and non-refundable</strong>, including but not limited to:
            </p>
            <ul className="list-disc list-inside space-y-2 mb-4">
              <li>Software licenses and downloads</li>
              <li>Subscription services</li>
              <li>Cloud-based solutions</li>
              <li>Training and consulting services</li>
              <li>Custom implementations</li>
              <li>Support and maintenance packages</li>
            </ul>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">3. Trial Version</h2>
            <p className="mb-4">
              We recommend that you thoroughly test our software using the free trial version before making a purchase. 
              The trial version is provided to allow you to evaluate the product and ensure it meets your requirements.
            </p>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">4. Support & Assistance</h2>
            <p className="mb-4">
              While refunds are not available, we provide comprehensive support to help you maximize the value of your purchase. 
              Please contact our support team if you experience any issues or need assistance.
            </p>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">5. Contact Information</h2>
            <p className="mb-4">
              For support inquiries, please contact:
            </p>
            <div className="bg-blue-50 p-4 rounded-lg">
              <p><strong>Support Department</strong></p>
              <p>Email: support@busynepal.com</p>
              <p>Phone: +977 9857834143</p>
              <p>Response Time: Within 24 Hours</p>
            </div>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">6. Policy Updates</h2>
            <p className="mb-4">
              We reserve the right to modify this policy at any time. Changes will be effective immediately upon posting to our website.
            </p>
          </section>

          <p className="text-sm text-gray-500 mt-8">
            Last updated: January 26, 2026
          </p>
        </div>
      </div>
    </div>
  );
}
