import { Button } from '@/components/ui/button';
import { Card, CardContent, CardHeader, CardFooter, CardTitle, CardDescription } from '@/components/ui/card';
import { Badge } from '@/components/ui/badge';
import Image from 'next/image';
import {
  CheckCircle2,
  BarChart3,
  Download,
  Users,
  Shield,
  Zap,
  FileText,
  Database,
  TrendingUp,
  Factory,
  MapPin,
  Clock,
  Check,
  X,
} from 'lucide-react';
import Link from 'next/link';

export default function Busy21StandardPage() {
  const features = [
    { icon: BarChart3, title: 'Advanced Accounting', description: 'Comprehensive accounting for growing businesses' },
    { icon: Download, title: 'Professional Billing', description: 'Create GST-compliant invoices easily' },
    { icon: Database, title: 'Multi-Location Inventory', description: 'Manage stock across multiple locations' },
    { icon: Factory, title: 'Manufacturing Module', description: 'Support for production processes' },
    { icon: Shield, title: 'Enhanced GST/VAT', description: 'Advanced tax compliance features' },
  ];

  const capabilities = [
    {
      title: 'Accounting',
      items: ['Advanced Accounting', 'Multi-Currency', 'Cost Centers', 'Budgets', 'Project Accounting'],
    },
    {
      title: 'Inventory',
      items: ['Multi-Location', 'Manufacturing', 'Bill of Materials', 'Batch/Serial Tracking', 'QC Management'],
    },
    {
      title: 'Billing',
      items: ['Multi-Currency Billing', 'GST/VAT Support', 'Credit Management', 'Recurring Invoices', 'Custom Templates'],
    },
    {
      title: 'Reports',
      items: ['50+ Reports', 'Custom Reports', 'Comparative Analysis', 'Budget vs Actual', 'Project Reports'],
    },
  ];

  const plans = [
    {
      name: 'Standard Single User',
      description: 'Perfect for single-operator growing businesses.',
      highlight: true,
      badge: 'Most Popular',
      users: '1 User',
      pricingOptions: [
        { period: 'Per Year', price: 'NPR 15,000' },
        { period: '3 Years', price: 'NPR 30,000' },
      ],
      features: [
        'Single User License',
        'Multi-Location Inventory',
        'Manufacturing Module',
        'Nepal VAT Reporting',
        '100+ Reports',
        '1 Year Free Support',
      ],
    },
    {
      name: 'Standard Multi User',
      description: 'Best for teams requiring network access.',
      highlight: false,
      users: 'Two or More Concurrent Users',
      pricingOptions: [
        { period: 'Per Year', price: 'NPR 35,000' },
        { period: '3 Years', price: 'NPR 70,000' },
      ],
      features: [
        '5 Concurrent Users',
        'Multi-Location Inventory',
        'Manufacturing Module',
        'Nepal VAT Reporting',
        '100+ Reports',
        '1 Year Free Support',
      ],
    },
    {
      name: 'Standard Count',
      description: 'For heavy inventory management and counting needs.',
      highlight: true,
      badge: 'Most Popular',
      users: 'Based on Count Systems',
      pricingOptions: [
        { period: 'Per Year', price: 'NPR 15,000' },
        { period: '3 Years', price: 'NPR 30,000' },
      ],
      features: [
        'Based on Count Systems',
        'Multi-Location Inventory',
        'Manufacturing Module',
        'Nepal VAT Reporting',
        '100+ Reports',
        '1 Year Free Support',
      ],
    },
  ];

  const comparisonData = [
    { feature: 'User Licenses', single: '1 User', multi: 'Two or More Concurrent Users', count: 'Count Based' },
    { feature: 'IRD Approved', single: 'Yes', multi: 'No', count: 'Yes' },
    { feature: 'Database Backend', single: 'Access/SQL Server', multi: 'Access', count: 'Access/SQL Server' },
    { feature: 'Multi-Location Inventory', single: 'Yes', multi: 'Yes', count: 'Yes' },
    { feature: 'Manufacturing Module', single: 'Full', multi: 'Full', count: 'Full' },
    { feature: 'Bill of Materials', single: 'Yes', multi: 'Yes', count: 'Yes' },
    { feature: 'Cost Centers', single: 'Yes', multi: 'Yes', count: 'Yes' },
    { feature: 'Batch/Serial Management', single: 'Yes', multi: 'Yes', count: 'Yes' },
    { feature: 'Reports', single: '100+', multi: '100+', count: '100+' },
    { feature: 'Support Level', single: 'Priority', multi: 'Priority', count: 'Priority' },
  ];

  return (
    <>
      {/* Hero Section */}
      <section className="bg-gradient-to-br from-orange-600 to-red-600 text-white py-20 pt-50">
        <div className="container mx-auto px-4">
          <div className="grid lg:grid-cols-2 gap-8 items-center">
            {/* Content */}
            <div>
              <Badge className="bg-white/20 hover:bg-white/20 text-white border-white/30 mb-6">
                Advanced Business Solution
              </Badge>
              <h1 className="text-4xl lg:text-6xl font-bold mb-6 tracking-tight">
                Busy 21 Standard
              </h1>
              <p className="text-xl text-orange-100 mb-8 leading-relaxed">
                Ideal for growing businesses, distributors, and manufacturers. 
                Choose the right edition for your scale.
              </p>
              <div className="flex flex-wrap gap-4">
                <Link href="/downloads">
                  <Button size="lg" className="bg-white text-orange-600 hover:bg-orange-50 font-semibold px-8">
                    <Download className="mr-2 h-5 w-5" />
                    Download Free Trial
                  </Button>
                </Link>
                <Link href="/contact">
                  <Button size="lg" variant="outline" className="border-white text-white hover:bg-white hover:text-orange-600 px-8">
                    Get Quote
                  </Button>
                </Link>
              </div>
            </div>
            
            {/* Image */}
            <div className="flex items-center justify-center">
              <div className="relative w-full max-w-md aspect-square bg-white/10 rounded-2xl border-2 border-white/20 overflow-hidden">
                <Image
                  src="/busy-post4.png"
                  alt="Busy 21 Standard Product"
                  fill
                  className="object-cover"
                  priority
                />
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Features */}
      <section className="py-16 bg-white">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Why Upgrade to Standard?
            </h2>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              Packed with advanced features designed for scaling operations.
            </p>
          </div>
          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            {features.map((feature, index) => (
              <Card key={index} className="border-2 border-transparent hover:border-orange-200 transition-all hover:shadow-lg">
                <CardContent className="p-6">
                  <div className="w-14 h-14 bg-orange-100 rounded-2xl flex items-center justify-center mb-5">
                    <feature.icon className="h-7 w-7 text-orange-600" />
                  </div>
                  <h3 className="text-xl font-bold text-gray-900 mb-3">
                    {feature.title}
                  </h3>
                  <p className="text-gray-600 leading-relaxed">
                    {feature.description}
                  </p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Capabilities */}
      <section className="py-16 bg-gray-50 border-y border-gray-100">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Advanced Capabilities
            </h2>
          </div>
          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
            {capabilities.map((capability, index) => (
              <Card key={index} className="border-none shadow-sm bg-white h-full">
                <CardHeader>
                  <h3 className="text-lg font-bold text-gray-900">
                    {capability.title}
                  </h3>
                </CardHeader>
                <CardContent>
                  <ul className="space-y-3">
                    {capability.items.map((item, i) => (
                      <li key={i} className="flex items-center gap-3 text-sm text-gray-600">
                        <CheckCircle2 className="h-4 w-4 text-orange-500 flex-shrink-0" />
                        {item}
                      </li>
                    ))}
                  </ul>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Pricing Section */}
      <section id="pricing" className="py-20 bg-white">
        <div className="container mx-auto px-4">
          <div className="text-center mb-16">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Choose Your Edition
            </h2>
            <p className="text-lg text-gray-600">
              Annual subscription. Includes 1 year of support and updates.
            </p>
          </div>

          <div className="grid lg:grid-cols-3 gap-8 max-w-7xl mx-auto items-start">
            {plans.map((plan, index) => (
              <Card 
                key={index} 
                className={`relative flex flex-col ${plan.highlight ? 'border-orange-500 shadow-2xl scale-105 z-10' : 'border-gray-200 shadow-sm'}`}
              >
                {plan.highlight && (
                  <div className="absolute top-0 right-0 bg-orange-500 text-white text-xs font-bold px-3 py-1 rounded-bl-lg">
                    {plan.badge}
                  </div>
                )}
                <CardHeader className="pb-6">
                  <CardTitle className="text-xl">{plan.name}</CardTitle>
                  <CardDescription className="text-base pt-2 min-h-[40px]">{plan.description}</CardDescription>
                  <div className="pt-4 space-y-3">
                    {plan.pricingOptions.map((option, idx) => (
                      <div key={idx} className="flex items-baseline justify-between pb-3 border-b border-gray-200 last:border-0">
                        <span className="text-gray-600 font-medium">{option.period}</span>
                        <span className="text-2xl font-extrabold text-gray-900">{option.price}</span>
                      </div>
                    ))}
                  </div>
                  <div className="mt-4 text-sm text-gray-500 font-medium">
                    {plan.users}
                  </div>
                </CardHeader>
                <CardContent className="flex-grow">
                  <ul className="space-y-4 mb-8">
                    {plan.features.map((feature, i) => (
                      <li key={i} className="flex items-start gap-3">
                        <Check className="h-5 w-5 text-green-500 flex-shrink-0 mt-0.5" />
                        <span className="text-gray-600 text-sm">{feature}</span>
                      </li>
                    ))}
                  </ul>
                </CardContent>
                <CardFooter className="pt-0">
                  <Link href="/downloads" className="w-full">
                    <Button 
                      className={`w-full h-12 font-semibold ${plan.highlight ? 'bg-orange-600 hover:bg-orange-700 text-white' : 'bg-gray-100 hover:bg-gray-200 text-gray-900'}`}
                    >
                      Download Trial
                    </Button>
                  </Link>
                </CardFooter>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Comparison Table */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="max-w-6xl mx-auto">
            <div className="text-center mb-12">
              <h2 className="text-3xl font-bold text-gray-900 mb-4">
                Compare Editions
              </h2>
              <p className="text-gray-600">Detailed feature breakdown for Standard Single User, Multi User, and Count.</p>
            </div>

            <div className="bg-white rounded-xl shadow-lg border border-gray-200 overflow-hidden">
              <div className="overflow-x-auto">
                <table className="w-full text-left border-collapse min-w-[600px]">
                  <thead>
                    <tr className="bg-gray-100 border-b border-gray-200">
                      <th className="p-6 font-semibold text-gray-900 w-1/4">Features</th>
                      <th className="p-6 font-semibold text-gray-900 text-center w-1/4">Single User</th>
                      <th className="p-6 font-semibold text-orange-600 text-center w-1/4 bg-orange-50/50">Multi User</th>
                      <th className="p-6 font-semibold text-gray-900 text-center w-1/4">Standard Count</th>
                    </tr>
                  </thead>
                  <tbody className="divide-y divide-gray-100">
                    {comparisonData.map((row, i) => (
                      <tr key={i} className="hover:bg-gray-50/50 transition-colors">
                        <td className="p-6 text-gray-700 font-medium">{row.feature}</td>
                        <td className="p-6 text-center text-gray-600 text-sm">{row.single}</td>
                        <td className="p-6 text-center font-medium text-gray-900 text-sm bg-orange-50/30">{row.multi}</td>
                        <td className="p-6 text-center font-medium text-gray-900 text-sm">{row.count}</td>
                      </tr>
                    ))}
                  </tbody>
                </table>
              </div>
            </div>
            
            <div className="mt-8 text-center">
               <Link href="/contact">
                <Button className="px-6 bg-orange-600 text-white hover:bg-orange-700">
                  Confused which to pick? Contact Sales
                </Button>
               </Link>
            </div>
          </div>
        </div>
      </section>

      {/* CTA */}
      <section className="py-20 bg-gradient-to-r from-orange-600 to-red-600 text-white">
        <div className="container mx-auto px-4 text-center">
          <h2 className="text-3xl lg:text-4xl font-bold mb-6">
            Empower Your Growing Business
          </h2>
          <p className="text-lg text-orange-100 mb-10 max-w-2xl mx-auto">
            Busy 21 Standard provides the tools you need to manage complexity, inventory, and manufacturing with ease.
          </p>
          <div className="flex flex-wrap justify-center gap-4">
            <Link href="/downloads">
              <Button size="lg" variant="outline" className="border-white text-white hover:bg-white hover:text-orange-600 px-8 h-12 text-lg">
                Download Free Trial
              </Button>
            </Link>
            <Link href="/contact">
              <Button size="lg" className="bg-white text-orange-600 hover:bg-orange-50 px-8 h-12 text-lg font-semibold">
                Schedule Demo
              </Button>
            </Link>
          </div>
        </div>
      </section>
    </>
  );
}