import { Button } from '@/components/ui/button';
import { Card, CardContent, CardHeader, CardFooter, CardTitle, CardDescription } from '@/components/ui/card';
import { Badge } from '@/components/ui/badge';import Image from 'next/image';import {
  CheckCircle2,
  BarChart3,
  Download,
  Users,
  Shield,
  Zap,
  FileText,
  Database,
  TrendingUp,
  Factory,
  MapPin,
  Settings,
  Crown,
  Check,
  Server,
  HardDrive,
} from 'lucide-react';
import Link from 'next/link';

export default function Busy21EnterprisePage() {
  const features = [
    { icon: Crown, title: 'Enterprise-Grade', description: 'Complete solution for large organizations' },
    { icon: Users, title: 'Unlimited Scalability', description: 'Support for unlimited users and transactions' },
    { icon: Server, title: 'SQL Database', description: 'Robust SQL backend for high data integrity and speed' },
    { icon: Shield, title: 'User Management', description: 'Role-based access control and data encryption' },
    { icon: Factory, title: 'Data Synchronization', description: 'High-speed data synchronization across locations' },
  ];

  const capabilities = [
    {
      title: 'Advanced Accounting',
      items: ['Multi-Currency', 'Cost Centers', 'Budgets', 'Payroll', 'Enquiry / Support' ],
    },
    {
      title: 'Inventory',
      items: ['Multi-Location', 'Manufacturing', 'Bill of Materials', 'Batch/Serial Tracking', 'QC Management'],
    },
    {
      title: 'Analytics',
      items: ['250+ Reports', 'Custom Reports', 'Dashboards', 'KPI Tracking', 'Predictive Analytics'],
    },
    {
      title: 'Security',
      items: ['Role-based Access', 'Audit Trails', 'Data Encryption', 'Backup & Recovery', 'User Permissions'],
    },
  ];

  const plans = [
    {
      name: 'Enterprise Single User',
      description: 'Powerful features for a single power user or financial controller.',
      highlight: false,
      users: '1 User',
      pricingOptions: [
        { period: 'Per Year', price: 'NPR 22000' },
        { period: '3 Years', price: 'NPR 45000' },
      ],
      features: [
        'Single User License',
        'Unlimited Companies',
        'Access & Sql Database Both Supports',
        'Multi-Location Inventory',
        'Payroll Support',
        '150+ Reports',
        'Priority Support',
      ],
    },
    {
      name: 'Enterprise Multi User',
      description: 'Full suite for large teams requiring concurrent access.',
      highlight: false,
      users: 'Unlimited Users',
      pricingOptions: [
        { period: 'Per Year', price: 'NPR 45000' },
        { period: '3 Years', price: 'NPR 90000' },
      ],
      features: [
        'Two or More Concurrent Users',
        'Unlimited Companies',
        'Multi-Location Inventory',
        'Payroll Support',
        'Manufacturing Module',
        'Batch/Serial Management',
        '150+ Reports',
        'Priority Support',
      ],
    },
    {
      name: 'Enterprise Count',
      description: 'Specialized for Multi-Location Billing.',
      highlight: true,
      badge: 'Most Popular',
      users: 'Count Based',
      pricingOptions: [
        { period: 'Per Year', price: 'NPR 22000' },
        { period: '3 Years', price: 'NPR 45000' },
      ],
      features: [
        'Unlimited Companies',
        'Multi-Location Billing',
        'IRD Billing Support',
        'Access & Sql Database Both Supports',
        'Batch/Serial Management',
        'Payroll Support',
        '150+ Reports',
        'Priority Support',
      ],
    },
  ];

  const comparisonData = [
    { feature: 'User Licenses', single: '1 User', multi: 'Two or More Concurrent Users', count: 'Count Based' },
    { feature: 'Database Backend', single: 'Access/SQL Server', multi: 'Access', count: 'Access/SQL Server' },
    { feature: 'Companies/Branches', single: 'Unlimited', multi: 'Unlimited', count: 'Unlimited' },
    { feature: 'Inventory Management', single: 'Multi-Location', multi: 'Multi-Location', count: 'Multi-Location' },
    { feature: 'Manufacturing', single: 'Full Module', multi: 'Full Module', count: 'Full Module' },
    { feature: 'IRD Approved', single: 'Yes', multi: 'No', count: 'Yes' },
    { feature: 'Custom Reports', single: 'Yes', multi: 'Yes', count: 'Yes' },
    { feature: 'Support', single: 'Priority 24/7', multi: 'Priority 24/7', count: 'Priority 24/7' },
  ];

  return (
    <>
      {/* Hero Section */}
      <section className="bg-gradient-to-br from-emerald-600 to-green-700 text-white py-20 pt-50">
        <div className="container mx-auto px-4">
          <div className="grid lg:grid-cols-2 gap-8 items-center">
            {/* Content */}
            <div>
              <Badge className="bg-white/20 hover:bg-white/20 text-white border-white/30 mb-6">
                For Large Organizations
              </Badge>
              <h1 className="text-4xl lg:text-6xl font-bold mb-6 tracking-tight">
                Busy 21 Enterprise
              </h1>
              <p className="text-xl text-green-100 mb-8 leading-relaxed">
                The ultimate ERP solution. Featuring SQL database support, unlimited scalability, and specialized tools for complex manufacturing and warehousing.
              </p>
              <div className="flex flex-wrap gap-4">
                <Link href="/downloads">
                  <Button size="lg" className="bg-white text-emerald-700 hover:bg-green-50 font-semibold px-8">
                    <Download className="mr-2 h-5 w-5" />
                    Download Free Trial
                  </Button>
                </Link>
                <Link href="/contact">
                  <Button size="lg" variant="outline" className="border-white text-white hover:bg-white hover:text-emerald-700 px-8">
                    Contact Sales
                  </Button>
                </Link>
              </div>
            </div>
            
            {/* Image */}
            <div className="flex items-center justify-center">
              <div className="relative w-full max-w-md aspect-square bg-white/10 rounded-2xl border-2 border-white/20 overflow-hidden">
                <Image
                  src="/busy-post4.png"
                  alt="Busy 21 Enterprise Product"
                  fill
                  className="object-cover"
                  priority
                />
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Features */}
      <section className="py-16 bg-white">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Enterprise Capabilities
            </h2>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              Built for power, performance, and total control.
            </p>
          </div>
          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            {features.map((feature, index) => (
              <Card key={index} className="border-2 border-transparent hover:border-green-200 transition-all hover:shadow-lg">
                <CardContent className="p-6">
                  <div className="w-14 h-14 bg-green-100 rounded-2xl flex items-center justify-center mb-5">
                    <feature.icon className="h-7 w-7 text-green-600" />
                  </div>
                  <h3 className="text-xl font-bold text-gray-900 mb-3">
                    {feature.title}
                  </h3>
                  <p className="text-gray-600 leading-relaxed">
                    {feature.description}
                  </p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Capabilities */}
      <section className="py-16 bg-gray-50 border-y border-gray-100">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              In-Depth Modules
            </h2>
          </div>
          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
            {capabilities.map((capability, index) => (
              <Card key={index} className="border-none shadow-sm bg-white h-full">
                <CardHeader>
                  <h3 className="text-lg font-bold text-gray-900">
                    {capability.title}
                  </h3>
                </CardHeader>
                <CardContent>
                  <ul className="space-y-3">
                    {capability.items.map((item, i) => (
                      <li key={i} className="flex items-center gap-3 text-sm text-gray-600">
                        <CheckCircle2 className="h-4 w-4 text-green-500 flex-shrink-0" />
                        {item}
                      </li>
                    ))}
                  </ul>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Pricing Section */}
      <section id="pricing" className="py-20 bg-white">
        <div className="container mx-auto px-4">
          <div className="text-center mb-16">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Flexible Enterprise Licensing
            </h2>
            <p className="text-lg text-gray-600">
              Annual subscription. Includes 1 year of support and updates.
            </p>
          </div>

          <div className="grid lg:grid-cols-3 gap-8 max-w-7xl mx-auto items-start">
            {plans.map((plan, index) => (
              <Card 
                key={index} 
                className={`relative flex flex-col ${plan.highlight ? 'border-green-500 shadow-2xl scale-105 z-10' : 'border-gray-200 shadow-sm'}`}
              >
                {plan.highlight && (
                  <div className="absolute top-0 right-0 bg-green-500 text-white text-xs font-bold px-3 py-1 rounded-bl-lg">
                    {plan.badge}
                  </div>
                )}
                <CardHeader className="pb-6">
                  <CardTitle className="text-xl">{plan.name}</CardTitle>
                  <CardDescription className="text-base pt-2 min-h-[40px]">{plan.description}</CardDescription>
                  <div className="pt-4 space-y-3">
                    {plan.pricingOptions.map((option, idx) => (
                      <div key={idx} className="flex items-baseline justify-between pb-3 border-b border-gray-200 last:border-0">
                        <span className="text-gray-600 font-medium">{option.period}</span>
                        <span className="text-2xl font-extrabold text-gray-900">{option.price}</span>
                      </div>
                    ))}
                  </div>
                  <div className="mt-4 text-sm text-gray-500 font-medium">
                    {plan.users}
                  </div>
                </CardHeader>
                <CardContent className="flex-grow">
                  <ul className="space-y-4 mb-8">
                    {plan.features.map((feature, i) => (
                      <li key={i} className="flex items-start gap-3">
                        <Check className="h-5 w-5 text-green-500 flex-shrink-0 mt-0.5" />
                        <span className="text-gray-600 text-sm">{feature}</span>
                      </li>
                    ))}
                  </ul>
                </CardContent>
                <CardFooter className="pt-0">
                  <Link href="/downloads" className="w-full">
                    <Button 
                      className={`w-full h-12 font-semibold ${plan.highlight ? 'bg-green-600 hover:bg-green-700 text-white' : 'bg-gray-100 hover:bg-gray-200 text-gray-900'}`}
                    >
                      Download Trial
                    </Button>
                  </Link>
                </CardFooter>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Comparison Table */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="max-w-6xl mx-auto">
            <div className="text-center mb-12">
              <h2 className="text-3xl font-bold text-gray-900 mb-4">
                Compare Enterprise Editions
              </h2>
              <p className="text-gray-600">Detailed breakdown of Single User, Multi User, and Enterprise Count capabilities.</p>
            </div>

            <div className="bg-white rounded-xl shadow-lg border border-gray-200 overflow-hidden">
              <div className="overflow-x-auto">
                <table className="w-full text-left border-collapse min-w-[600px]">
                  <thead>
                    <tr className="bg-gray-100 border-b border-gray-200">
                      <th className="p-6 font-semibold text-gray-900 w-1/4">Features</th>
                      <th className="p-6 font-semibold text-gray-900 text-center w-1/4">Single User</th>
                      <th className="p-6 font-semibold text-green-600 text-center w-1/4 bg-green-50/50">Multi User</th>
                      <th className="p-6 font-semibold text-gray-900 text-center w-1/4">Enterprise Count</th>
                    </tr>
                  </thead>
                  <tbody className="divide-y divide-gray-100">
                    {comparisonData.map((row, i) => (
                      <tr key={i} className="hover:bg-gray-50/50 transition-colors">
                        <td className="p-6 text-gray-700 font-medium">{row.feature}</td>
                        <td className="p-6 text-center text-gray-600 text-sm">{row.single}</td>
                        <td className="p-6 text-center font-medium text-gray-900 text-sm bg-green-50/30">{row.multi}</td>
                        <td className="p-6 text-center font-medium text-gray-900 text-sm">{row.count}</td>
                      </tr>
                    ))}
                  </tbody>
                </table>
              </div>
            </div>
            
            <div className="mt-8 text-center">
               <Link href="/contact">
                <Button className="px-6 bg-emerald-700 text-white hover:bg-emerald-800">
                  Talk to an Enterprise Expert
                </Button>
               </Link>
            </div>
          </div>
        </div>
      </section>

      {/* CTA */}
      <section className="py-20 bg-gradient-to-r from-emerald-600 to-green-700 text-white">
        <div className="container mx-auto px-4 text-center">
          <h2 className="text-3xl lg:text-4xl font-bold mb-6">
            Transform Your Business Operations
          </h2>
          <p className="text-lg text-green-100 mb-10 max-w-2xl mx-auto">
            Experience the power of Busy 21 Enterprise. Built for scale, security, and speed.
          </p>
          <div className="flex flex-wrap justify-center gap-4">
            <Link href="/downloads">
              <Button size="lg" variant="outline" className="border-white text-white hover:bg-white hover:text-emerald-700 px-8 h-12 text-lg">
                Download Free Trial
              </Button>
            </Link>
            <Link href="/contact">
              <Button size="lg" className="bg-white text-emerald-700 hover:bg-green-50 px-8 h-12 text-lg font-semibold">
                Request Demo
              </Button>
            </Link>
          </div>
        </div>
      </section>
    </>
  );
}