import type { Metadata } from "next";

export const metadata: Metadata = {
  title: "Privacy Policy | Busy Nepal",
  description: "Privacy Policy for Busy Accounting Software. Learn how we collect, use, and protect your personal data.",
  keywords: ["privacy policy", "data protection", "busy software nepal"],
};

export default function PrivacyPolicy() {
  return (
    <div className="min-h-screen bg-gradient-to-b from-blue-50 to-white py-12 px-4 sm:px-6 lg:px-8">
      <div className="max-w-4xl mx-auto">
        <h1 className="text-4xl font-bold text-gray-900 mb-8">Privacy Policy</h1>
        
        <div className="prose prose-lg max-w-none text-gray-700">
          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">1. Introduction</h2>
            <p className="mb-4">
              Neha Infotech ("we", "our", or "us") operates the Busy Nepal website. This page informs you of our policies 
              regarding the collection, use, and disclosure of personal data when you use our service and the choices you have 
              associated with that data.
            </p>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">2. Information Collection and Use</h2>
            <p className="mb-4">We collect several different types of information for various purposes to provide and improve our service to you:</p>
            
            <h3 className="text-xl font-semibold text-gray-800 mb-3">Personal Data:</h3>
            <ul className="list-disc list-inside space-y-2 mb-4">
              <li>Email address</li>
              <li>First name and last name</li>
              <li>Phone number</li>
              <li>Address, State, Province, ZIP/Postal code, City</li>
              <li>Cookies and Usage Data</li>
            </ul>

            <h3 className="text-xl font-semibold text-gray-800 mb-3">Usage Data:</h3>
            <p className="mb-4">
              When you access the Service by or through a mobile device, we may collect certain information automatically, 
              including, but not limited to, the type of mobile device you use, your mobile device unique ID, the IP address 
              of your mobile device, your mobile operating system, the type of mobile Internet browser you use, unique device 
              identifiers, and other diagnostic data.
            </p>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">3. Use of Data</h2>
            <p className="mb-4">Neha Infotech uses the collected data for various purposes:</p>
            <ul className="list-disc list-inside space-y-2 mb-4">
              <li>To provide and maintain our service</li>
              <li>To notify you about changes to our service</li>
              <li>To allow you to participate in interactive features of our service when you choose to do so</li>
              <li>To provide customer care and support</li>
              <li>To gather analysis or valuable information so that we can improve our service</li>
              <li>To monitor the usage of our service</li>
              <li>To detect, prevent, and address technical and security issues</li>
            </ul>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">4. Security of Data</h2>
            <p className="mb-4">
              The security of your data is important to us, but remember that no method of transmission over the Internet or 
              method of electronic storage is 100% secure. While we strive to use commercially acceptable means to protect your 
              Personal Data, we cannot guarantee its absolute security.
            </p>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">5. Cookies</h2>
            <p className="mb-4">
              We use cookies and similar tracking technologies to track activity on our service and hold certain information. 
              You can instruct your browser to refuse all cookies or to indicate when a cookie is being sent. However, if you 
              do not accept cookies, you may not be able to use some portions of our service.
            </p>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">6. Third-Party Services</h2>
            <p className="mb-4">
              Our service may contain links to third-party sites that are not operated by us. This Privacy Policy does not 
              apply to third-party websites, and we are not responsible for their privacy practices. We encourage you to review 
              the privacy policies of any third-party services before providing your personal information or using these services.
            </p>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">7. Changes to This Privacy Policy</h2>
            <p className="mb-4">
              We may update our Privacy Policy from time to time. We will notify you of any changes by posting the new Privacy 
              Policy on this page and updating the "Last updated" date at the bottom of this Privacy Policy.
            </p>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">8. Contact Us</h2>
            <p className="mb-4">
              If you have any questions about this Privacy Policy, please contact us:
            </p>
            <div className="bg-blue-50 p-4 rounded-lg">
              <p><strong>Neha Infotech</strong></p>
              <p>Email: privacy@busynepal.com</p>
              <p>Phone: +977-9857834143</p>
            </div>
          </section>

          <p className="text-sm text-gray-500 mt-8">
            Last updated: January 26, 2026
          </p>
        </div>
      </div>
    </div>
  );
}
