import type { Metadata } from "next";
import { Geist, Geist_Mono } from "next/font/google";
import "./globals.css";
import { Toaster } from "@/components/ui/toaster";
import Header from "@/components/header";
import Footer from "@/components/footer";
import WhatsAppChatbot from "@/components/whatsapp-chatbot";
import { SchemaMarkup } from "@/components/schema-markup";
import { AdvancedSchemaMarkup } from "@/components/advanced-schema-markup";

const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
  display: "swap",
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
  display: "swap",
});

export const metadata: Metadata = {
  metadataBase: new URL('https://busynepal.com'),
  title: "Busy Accounting Software in Nepal | Authorized Distributor | Neha Infotech",
  description: "Authorized Busy Accounting Software Distributor in Nepal. Complete accounting solution including Busy 21, Busy on Cloud, and IRD-approved billing software for GST, VAT, and tax compliance.",
  keywords: [
    "Busy Software Nepal",
    "Busy Nepal",
    "Busy 21",
    "Busy Software",
    "E-billing Software Nepal",
    "Busy on Cloud Nepal",
    "Busy 21 Enterprise Nepal",
    "Busy 21 Standard Nepal",
    "Busy 21 Basic Nepal",
    "Accounting Software in Nepal",
    "IRD Billing Software Nepal",
    "VAT Billing Software Nepal",
    "Busy Distributor Nepal",
    "Busy Accounting Software Nepal",
    "Busy 21 Nepal",
    "Accounting Software",
    "GST Accounting",
    "Inventory Management",
    "Neha Infotech",
    "BusyNepal",
    "Accounting Solution",
    "Business Software",
    "Busy Authorized Distributor",
    "Busy Channel Partner",
    "Business",
    "Busy Channel Partner Nepal",
    "About Busy Software",
    "Tax Software",
    "Tally Erp 9 Nepal",
    "Tally Prime Nepal",
    "Busy Software Support Nepal",
    "Busy Support Nepal",
    "Tally Support Nepal",
    "Tally Software Nepal"
  ],
  authors: [{ name: "Neha Infotech" }],
  creator: "Neha Infotech",
  publisher: "Neha Infotech",
  icons: {
    icon: "/favicon.ico",
    shortcut: "/favicon-16x16.png",
    apple: "/apple-touch-icon.png",
  },
  openGraph: {
    title: "Authorized Distributor of Busy Accounting Software in Nepal | Neha Infotech",
    description: "Authorized Busy Accounting Software Distributor in Nepal. Get complete accounting solution for your business.",
    url: "https://busynepal.com",
    siteName: "BusyNepal",
    locale: "en_NP",
    type: "website",
    images: [
      {
        url: "/logo.png",  // Your logo path
        width: 1200,
        height: 630,
        alt: "BusyNepal Logo",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Authorized Distributor of Busy Accounting Software in Nepal | Neha Infotech",
    description: "Authorized Busy Accounting Software Distributor in Nepal",
    images: ["/og-image.png"],
    creator: "@busynepal",
  },
  robots: {
    index: true,
    follow: true,
    googleBot: {
      index: true,
      follow: true,
      'max-video-preview': -1,
      'max-image-preview': 'large',
      'max-snippet': -1,
    },
  },
  verification: {
    google: "your-google-verification-code",
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en-NP" suppressHydrationWarning>
      <head>
        <link rel="canonical" href="https://busynepal.com" />
        <link
          rel="preload"
          as="image"
          href="/busy-post.png"
          type="image/png"
        />
        <SchemaMarkup />
        <AdvancedSchemaMarkup />
        {/* Google Analytics 4 */}
        <script async src="https://www.googletagmanager.com/gtag/js?id=G-NCS1S870CJ"></script>
        <script
          dangerouslySetInnerHTML={{
            __html: `
              window.dataLayer = window.dataLayer || [];
              function gtag(){dataLayer.push(arguments);}
              gtag('js', new Date());
              gtag('config', 'G-NCS1S870CJ', {
                page_path: window.location.pathname,
              });
            `,
          }}
        />
        {/* Facebook Pixel */}
        <script
          dangerouslySetInnerHTML={{
            __html: `
              !function(f,b,e,v,n,t,s)
              {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
              n.callMethod.apply(n,arguments):n.queue.push(arguments)};
              if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
              n.queue=[];t=b.createElement(e);t.async=!0;
              t.src=v;s=b.getElementsByTagName(e)[0];
              s.parentNode.insertBefore(t,s)}(window, document,'script',
              'https://connect.facebook.net/en_US/fbevents.js');
              fbq('init', '1277425214257192');
              fbq('track', 'PageView');
            `,
          }}
        />
      </head>
      <body
        className={`${geistSans.variable} ${geistMono.variable} antialiased bg-background text-foreground`}
      >
        <noscript>
          <img
            height="1"
            width="1"
            className="facebook-pixel-noscript"
            src="https://www.facebook.com/tr?id=1277425214257192&ev=PageView&noscript=1"
            alt="facebook-pixel"
            loading="lazy"
            decoding="async"
          />
        </noscript>
        <div className="flex flex-col min-h-screen">
          <Header />
          <main className="flex-1">
            {children}
          </main>
          <Footer />
          <WhatsAppChatbot />
        </div>
        <Toaster />
      </body>
    </html>
  );
}
