import { NextResponse } from 'next/server';
import { userStore } from '@/lib/userStore';

export async function POST(request: Request) {
  try {
    const body = await request.json();
    const { username, password } = body;

    // Find user with matching username and password
    const user = userStore.getAll().find(
      (u) => u.username === username && u.password === password
    );

    if (user) {
      const response = NextResponse.json(
        { message: 'Login successful' },
        { status: 200 }
      );

      // Set auth cookie
      response.cookies.set({
        name: 'adminAuth',
        value: JSON.stringify({
          username: user.username,
          userId: user.id,
          role: user.role,
          timestamp: new Date().getTime(),
        }),
        httpOnly: true,
        secure: process.env.NODE_ENV === 'production',
        sameSite: 'lax',
        maxAge: 24 * 60 * 60, // 24 hours
      });

      return response;
    } else {
      return NextResponse.json(
        { message: 'Invalid credentials' },
        { status: 401 }
      );
    }
  } catch (error) {
    console.error('Login error:', error);
    return NextResponse.json(
      { message: 'Login failed' },
      { status: 500 }
    );
  }
}
