'use client';

import { Card, CardContent } from '@/components/ui/card';
import { Badge } from '@/components/ui/badge';
import { CheckCircle2, Target, Eye, Users, Award, TrendingUp } from 'lucide-react';

const About = () => {
  const stats = [
    { icon: <Users className="w-6 h-6" />, value: '1000+', label: 'Happy Clients' },
    { icon: <TrendingUp className="w-6 h-6" />, value: '15+', label: 'Years Experience' },
    { icon: <Award className="w-6 h-6" />, value: '10+', label: 'Team Members' },
    { icon: <CheckCircle2 className="w-6 h-6" />, value: '99%', label: 'Satisfaction Rate' },
  ];

  const values = [
    {
      icon: <Target className="w-8 h-8" />,
      title: 'Customer First',
      description: 'We prioritize our customers\' needs and go the extra mile to ensure their success.',
    },
    {
      icon: <Eye className="w-8 h-8" />,
      title: 'Transparency',
      description: 'Honest and transparent in all our dealings with no hidden charges or surprises.',
    },
    {
      icon: <Award className="w-8 h-8" />,
      title: 'Excellence',
      description: 'Committed to delivering the highest quality products and services.',
    },
  ];

  const milestones = [
    { year: '2015', title: 'Founded', description: 'Neha Infotech was established in Nepalgunj, Banke, Nepal' },
    { year: '2016', title: 'Busy Dealer', description: 'Became Reseller of Busy Accounting Software' },
    { year: '2023', title: '1000+ Clients', description: 'Reached milestone of 1000 happy clients' },
    { year: '2025', title: 'Busy Partnership', description: 'Became authorized Busy software distributor in Nepal' },
    { year: '2025', title: '10+ Years', description: 'Celebrating 15+ years of excellence in accounting software' },
  ];

  return (
    <>
      {/* Hero Section */}
      <section className="pt-32 pb-20 gradient-hero">
        <div className="container-custom">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div>
              <Badge className="badge-blue mb-4">About Us</Badge>
              <h1 className="text-4xl md:text-5xl font-bold mb-6">
                Your Trusted{' '}
                <span className="text-gradient-primary">Busy Accounting Software Partner in Nepal</span>
              </h1>
              <p className="text-lg text-gray-600 leading-relaxed mb-6">
                Neha Infotech is the authorized distributor of Busy Accounting Software in Nepal.
                For over 10 years, we have been helping businesses of all sizes manage their
                finances efficiently with our comprehensive accounting solutions.
              </p>
              <p className="text-lg text-gray-600 leading-relaxed">
                From small startups to large enterprises, we provide personalized service,
                expert training, and reliable support to ensure your business accounting needs
                are met with excellence.Our team understands Nepal’s unique business and tax landscape, guiding you seamlessly through IRD compliance, VAT billing, and efficient workflow setup.
              </p>
               <p className="text-lg text-gray-600 leading-relaxed">
                Choose Neha Infotech for a partnership built on trust, expertise, and a proven commitment to your success. Let us help you streamline your finances, ensure compliance, and drive growth—with the official power of Busy.
              </p>
            </div>
            <div className="relative">
              <div className="aspect-square bg-gradient-primary rounded-2xl flex items-center justify-center text-white">
                <img
                  src="/busy-post2.png"
                  alt="Neha Infotech"
                  className="w-auto h-auto object-cover rounded-2xl"
                />
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Stats Section */}
      <section className="py-20 bg-white">
        <div className="container-custom">
          <div className="grid grid-cols-2 lg:grid-cols-4 gap-8">
            {stats.map((stat, index) => (
              <Card key={index} className="card-hover shadow-brand border-2 hover:border-[#005a9f] transition-all duration-300">
                <CardContent className="p-6 text-center">
                  <div className="gradient-primary p-3 rounded-lg text-white w-fit mx-auto mb-4">
                    {stat.icon}
                  </div>
                  <div className="text-3xl font-bold text-[#003d77] mb-1">{stat.value}</div>
                  <p className="text-gray-600">{stat.label}</p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Mission & Vision */}
      <section className="py-20 gradient-hero">
        <div className="container-custom">
          <div className="grid lg:grid-cols-2 gap-12">
            <div className="bg-white rounded-2xl p-8 shadow-brand-xl">
              <h2 className="text-3xl font-bold mb-6 text-[#003d77]">Our Mission</h2>
              <p className="text-lg text-gray-600 leading-relaxed">
                To empower businesses across Nepal with innovative accounting solutions that
                simplify financial management, ensure compliance, and drive growth. We are
                committed to delivering exceptional service and support to help our clients
                achieve their business goals.
              </p>
            </div>
            <div className="bg-white rounded-2xl p-8 shadow-brand-xl">
              <h2 className="text-3xl font-bold mb-6 text-[#003d77]">Our Vision</h2>
              <p className="text-lg text-gray-600 leading-relaxed">
                To be Nepal's most trusted accounting software partner, known for our expertise,
                reliability, and customer-centric approach. We aim to transform how businesses
                manage their finances through technology and innovation.
              </p>
            </div>
          </div>
        </div>
      </section>

      {/* Values */}
      <section className="py-20 bg-white">
        <div className="container-custom">
          <div className="text-center mb-16">
            <Badge className="badge-blue mb-4">Our Values</Badge>
            <h2 className="text-3xl md:text-4xl font-bold mb-4">What Drives Us</h2>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              Our core values shape everything we do and guide our decisions.
            </p>
          </div>

          <div className="grid md:grid-cols-3 gap-8">
            {values.map((value, index) => (
              <Card key={index} className="card-hover shadow-brand border-2 hover:border-[#005a9f] transition-all duration-300">
                <CardContent className="p-6">
                  <div className="gradient-primary p-3 rounded-lg text-white w-fit mb-4">
                    {value.icon}
                  </div>
                  <h3 className="text-xl font-bold mb-2">{value.title}</h3>
                  <p className="text-gray-600">{value.description}</p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Timeline */}
      <section className="py-20 gradient-hero">
        <div className="container-custom">
          <div className="text-center mb-16">
            <Badge className="badge-blue mb-4">Our Journey</Badge>
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Milestones</h2>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              Our journey from a small startup to Nepal's leading accounting software provider.
            </p>
          </div>

          <div className="space-y-6 max-w-3xl mx-auto">
            {milestones.map((milestone, index) => (
              <div key={index} className="flex gap-4">
                <div className="flex-shrink-0">
                  <div className="w-24 gradient-primary text-white rounded-lg p-3 text-center font-bold">
                    {milestone.year}
                  </div>
                </div>
                <div className="flex-1 bg-white rounded-lg p-4 shadow-brand border-l-4 border-[#005a9f]">
                  <h3 className="text-lg font-bold mb-1">{milestone.title}</h3>
                  <p className="text-gray-600">{milestone.description}</p>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* CTA */}
      <section className="py-20 gradient-primary text-white">
        <div className="container-custom text-center">
          <h2 className="text-3xl md:text-4xl font-bold mb-6">Join Our Family</h2>
          <p className="text-xl opacity-90 mb-8 max-w-2xl mx-auto">
            Become one of our 1000+ satisfied clients and experience the difference with
            Neha Infotech.
          </p>
          <a href="/contact" className="inline-block bg-white text-[#005a9f] hover:bg-gray-100 rounded-lg px-8 py-4 text-lg font-medium transition-colors">
            Get Started Today
          </a>
        </div>
      </section>
    </>
  );
};

export default About;
