"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hi = void 0;
const locale_1 = require("date-fns/locale");
const DateLib_js_1 = require("../classes/DateLib.js");
/** Hindi locale extended with DayPicker-specific translations. */
exports.hi = {
    ...locale_1.hi,
    labels: {
        labelDayButton: (date, modifiers, options, dateLib) => {
            const lib = dateLib ?? new DateLib_js_1.DateLib(options);
            let label = lib.format(date, "PPPP");
            if (modifiers.today)
                label = `आज, ${label}`;
            if (modifiers.selected)
                label = `${label}, चयनित`;
            return label;
        },
        labelMonthDropdown: "महीना चुनें",
        labelNext: "अगले महीने पर जाएं",
        labelPrevious: "पिछले महीने पर जाएं",
        labelWeekNumber: (weekNumber) => `सप्ताह ${weekNumber}`,
        labelYearDropdown: "वर्ष चुनें",
        labelGrid: (date, options, dateLib) => (dateLib ?? new DateLib_js_1.DateLib(options)).formatMonthYear(date),
        labelGridcell: (date, modifiers, options, dateLib) => {
            const lib = dateLib ?? new DateLib_js_1.DateLib(options);
            let label = lib.format(date, "PPPP");
            if (modifiers?.today) {
                label = `आज, ${label}`;
            }
            return label;
        },
        labelNav: "नेविगेशन बार",
        labelWeekNumberHeader: "सप्ताह संख्या",
        labelWeekday: (date, options, dateLib) => (dateLib ?? new DateLib_js_1.DateLib(options)).format(date, "cccc"),
    },
};
