'use strict';

var plugin = require('./plugin-B0KIcFlc.cjs');
var ExtractorCodec = require('./ExtractorCodec-D9Tw618d.cjs');
require('fs/promises');
require('path');
require('@parcel/watcher');
require('fs');
require('module');
require('@swc/core');

var JSONCodec = ExtractorCodec.defineCodec(() => ({
  decode(source) {
    const json = JSON.parse(source);
    const messages = [];
    traverseMessages(json, (message, id) => {
      messages.push({
        id,
        message
      });
    });
    return messages;
  },
  encode(messages) {
    const root = {};
    for (const message of plugin.getSortedMessages(messages)) {
      plugin.setNestedProperty(root, message.id, message.message);
    }
    return JSON.stringify(root, null, 2) + '\n';
  },
  toJSONString(source) {
    return source;
  }
}));
function traverseMessages(obj, callback, path = '') {
  const NAMESPACE_SEPARATOR = '.';
  for (const key of Object.keys(obj)) {
    const newPath = path ? path + NAMESPACE_SEPARATOR + key : key;
    const value = obj[key];
    if (typeof value === 'string') {
      callback(value, newPath);
    } else if (typeof value === 'object') {
      traverseMessages(value, callback, newPath);
    }
  }
}

exports.default = JSONCodec;
