import { isPrimaryPointer } from 'motion-dom';

function extractEventInfo(event) {
    return {
        point: {
            x: event.pageX,
            y: event.pageY,
        },
    };
}
const addPointerInfo = (handler) => {
    return (event) => isPrimaryPointer(event) && handler(event, extractEventInfo(event));
};

export { addPointerInfo, extractEventInfo };
//# sourceMappingURL=event-info.mjs.map
