Object.defineProperty(exports, '__esModule', { value: true });

var QRCode = require('qrcode');
var React = require('react');
var lodashEs = require('lodash-es');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

var QRCode__default = /*#__PURE__*/_interopDefault(QRCode);

process.env.NODE_ENV === 'development' || process.env.NODE_ENV === 'test';
const isBrowser = typeof window !== 'undefined';

const useIsomorphicLayoutEffect = isBrowser ? React.useLayoutEffect : React.useEffect;

const updateReducer = (num)=>(num + 1) % 1000000;
function useUpdate() {
    const [, update] = React.useReducer(updateReducer, 0);
    return update;
}

const useCustomCompareEffect = (effect, deps, depsEqual)=>{
    if (process.env.NODE_ENV !== 'production') {
        if (!Array.isArray(deps) || !deps.length) {
            console.warn('`useCustomCompareEffect` should not be used with no dependencies. Use React.useEffect instead.');
        }
        if (typeof depsEqual !== 'function') {
            console.warn('`useCustomCompareEffect` should be used with depsEqual callback for comparing deps list');
        }
    }
    const ref = React.useRef(undefined);
    const forceUpdate = useUpdate();
    if (!ref.current) {
        ref.current = deps;
    }
    useIsomorphicLayoutEffect(()=>{
        if (!depsEqual(deps, ref.current)) {
            ref.current = deps;
            forceUpdate();
        }
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
    React.useEffect(effect, ref.current);
};

const useDeepCompareEffect = (effect, deps)=>{
    if (process.env.NODE_ENV !== 'production') {
        if (!Array.isArray(deps) || !deps.length) {
            console.warn('`useDeepCompareEffect` should not be used with no dependencies. Use React.useEffect instead.');
        }
    }
    useCustomCompareEffect(effect, deps, lodashEs.isEqual);
};

const defaultOptions = {};

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
function generateQRCode(text, options) {
    return QRCode__default.default.toDataURL(text, options);
}
const useQRCode = (text, options = defaultOptions)=>{
    const [qrCode, setQRCode] = React.useState('');
    const [error, setError] = React.useState(null);
    useDeepCompareEffect(()=>{
        const generate = ()=>_async_to_generator(function*() {
                try {
                    const qrCode = yield generateQRCode(text, options);
                    setQRCode(qrCode);
                } catch (error) {
                    setError(error);
                }
            })();
        generate();
    }, [
        text,
        options
    ]);
    return {
        qrCode,
        error
    };
};

exports.generateQRCode = generateQRCode;
exports.useQRCode = useQRCode;
