import * as react from 'react';
import react__default, { DependencyList, MutableRefObject, EffectCallback, RefObject, Dispatch, SetStateAction, useEffect, useLayoutEffect, Ref, Context } from 'react';
import Cookies from 'js-cookie';
import { DebounceSettings, ThrottleSettings, DebouncedFunc as DebouncedFunc$1 } from 'lodash-es';
import * as lodash from 'lodash';
import { DebounceSettings as DebounceSettings$1, DebouncedFunc, ThrottleSettings as ThrottleSettings$1 } from 'lodash';
import { FetchEventSourceInit } from '@microsoft/fetch-event-source';

/**
 * @title useActiveElement
 * @returns_en Returns an instance of the type parameter `T` or `null`.
 * @returns 返回类型参数 `T` 或 `null` 的实例
 * @returns_zh-Hant 返回類型參數 `T` 或 `null` 的實例
 */
type UseActiveElement = <T extends Element>() => T | null;

declare const useActiveElement: UseActiveElement;

/**
 *
 * @title useAsyncEffect
 */
type UseAsyncEffect = <T>(
/**
 * @zh 支持promise的副作用函数
 * @zh-Hant 支援promise的副作用函數
 * @en effect that support promise
 */
effect: () => Promise<T> | T, 
/**
 * @zh 清理函数
 * @zh-Hant 清理函數
 * @en cleanup function
 * @defaultValue () => {}
 */
cleanup?: typeof effect, 
/**
 * @zh 依赖列表
 * @zh-Hant 依賴列表
 * @en dependency list
 */
deps?: DependencyList) => void;

declare const useAsyncEffect: UseAsyncEffect;

type TargetValue<T> = T | undefined | null;
type TargetType = HTMLElement | Element | Window | Document | EventTarget;
type BasicTarget<T extends TargetType = Element> = (() => TargetValue<T>) | TargetValue<T> | MutableRefObject<TargetValue<T>>;

/**
 * @title useClickOutside
 */
type UseClickOutside = (
/**
 * @zh dom对象
 * @zh-Hant dom對象
 * @en dom element
 */
target: BasicTarget<Element>, 
/**
 * @zh 监听函数
 * @zh-Hant 監聽函數
 * @en listener fucntion
 */
handler: (evt: EventType) => void, 
/**
 * @zh 监听函数是否生效
 * @zh-Hant 監聽函數是否生效
 * @en whether the listener fucntion is enabled
 */
enabled?: boolean) => void;
type EventType = MouseEvent | TouchEvent;

declare const useClickOutside: UseClickOutside;

/**
 * @title useCookie
 * @returns 包含以下元素的元组：
 * - cookie 的当前值。
 * - 更新 cookie 值的函数。
 * - 刷新 cookie 值的函数，以防其他事件更改它。
 * @returns_en A tuple with the following elements:
 * - The current value of the cookie.
 * - A function to update the value of the cookie.
 * - A function to refresh the value of the cookie, incase other events change it.
 * @returns_zh-Hant 包含以下元素的元組：
 * - cookie 的當前值。
 * - 更新 cookie 值的函數。
 * - 刷新 cookie 值的函數，以防其他事件更改它。
 */
type UseCookie = (
/**
 * @zh 键值
 * @zh-Hant 鍵值
 * @en key
 */
key: string, 
/**
 * @zh 透传给 `js-cookie` 的参数
 * @zh-Hant 透傳給 `js-cookie` 的參數
 * @en option pass to `js-cookie`
 */
options?: Cookies.CookieAttributes, 
/**
 * @zh 默认值，ssr必须传递
 * @zh-Hant 預設值，ssr必須傳遞
 * @en defaultValue, must be required in ssr
 */
defaultValue?: string) => readonly [
    UseCookieState,
    (newValue: UseCookieState | ((prevState: UseCookieState) => UseCookieState)) => void,
    () => void
];
/**
 * @title useCookieState
 */
type UseCookieState = string | undefined;

declare const useCookie: UseCookie;

/**
 * @title useCountdown
 * @returns_en A tuple with the following elements:
 * - hour
 * - minute.
 * - second.
 * @returns 包含以下元素的元组：
 * - 小时。
 * - 分钟。
 * - 秒数。
 * @returns_zh-Hant 包含以下元素的元組：
 * - 小時。
 * - 分鐘。
 * - 秒數。
 */
type UseCountDown = (
/**
 * @zh 时间差
 * @zh-Hant 時間差
 * @en time differ
 */
time: number, 
/**
 * @zh 时间格式化函数
 * @zh-Hant 時間格式化函數
 * @en time format function
 * @defaultValue HH MM SS
 */
format?: (num: number) => [string, string, string], 
/**
 * @zh 倒计时结束的回调函数
 * @zh-Hant 倒計時結束的回調函數
 * @en callback function for end of countdown
 */
callback?: () => void) => readonly [string, string, string];

declare const useCountDown: UseCountDown;

/**
 * @title useCounter
 * @returns_en A tuple with the following elements:
 * - The current value of the counter.
 * - A function to set the state of the counter. It can accept a number or a function that returns a number.
 * - A function to increment the counter. It optionally accepts a number to increment the counter by, defaulting to 1.
 * - A function to decrement the counter. It optionally accepts a number to decrement the counter by, defaulting to 1.
 * - A function to reset the counter to its initial value.
 * @returns 包含以下元素的元组：
 * - 计数器的当前值。
 * - 设置计数器状态的函数。 它可以接受数字或返回数字的函数。
 * - 递增计数器的函数。 它可以选择接受一个数字来增加计数器，默认为 1。
 * - 递减计数器的函数。 它可以选择接受一个数字来减少计数器，默认为 1。
 * - 将计数器重置为其初始值的函数。
 * @returns_zh-Hant 包含以下元素的元組：
 * - 計數器的當前值。
 * - 設定計數器狀態的函數。它可以接受數字或返回數字的函數。
 * - 遞增計數器的函數。它可以選擇接受一個數字來增加計數器，預設為 1。
 * - 遞減計數器的函數。它可以選擇接受一個數字來減少計數器，預設為 1。
 * - 將計數器重設為其初始值的函數。
 */
type UseCounter = (
/**
 * @zh 初始值，可以为数字或者一个初始化的函数
 * @zh-Hant 初始值，可以為數字或者一個初始化的函數
 * @en The initial value of the counter. It can be a number or a function that returns a number. If not provided, the counter will start from 0.
 * @defaultValue 0
 */
initialValue?: number | (() => number), 
/**
 * @zh 最大值。不提供则无上限
 * @zh-Hant 最大值。不提供則無上限
 * @en The maximum value that the counter can reach. If not provided or null, there is no upper limit.
 */
max?: number | null, 
/**
 * @zh 最小值。不提供则无下限
 * @zh-Hant 最小值。不提供則無下限
 * @en The minimum value that the counter can reach. If not provided or null, there is no lower limit.
 */
min?: number | null) => readonly [
    number,
    (newState: number | ((prev: number) => number) | (() => number)) => void,
    (delta?: number) => void,
    (delta?: number) => void,
    () => void
];

declare const useCounter: UseCounter;

declare const defaultOptions: UseCssVarOptions;
/**
 * @title useCssVar
 * @returns_en A tuple with the following elements:
 * - The current value of the css var.
 * - A function to update the value of the css var.
 *  @returns 包含以下元素的元组：
 * - css 变量值
 * - 更新 css 变量值的函数
 * @returns_zh-Hant 包含以下元素的元組：
 * - css 變數值
 * - 更新 css 變數值的函數
 */
type UseCssVar = <T extends HTMLElement = HTMLElement>(
/**
 * @zh 属性值，比如 --color
 * @zh-Hant 屬性值，比如 --color
 * @en prop, eg: --color
 */
prop: string, 
/**
 * @zh dom元素
 * @zh-Hant dom元素
 * @en dom element
 */
target: BasicTarget<T>, 
/**
 * @zh 默认值
 * @zh-Hant 預設值
 * @en default value
 */
defaultValue?: string, 
/**
 * @zh 可选项
 * @zh-Hant 可選項
 * @en options
 */
options?: UseCssVarOptions) => readonly [string, (v: string) => void];
/**
 * @title UseCssVarOptions
 */
interface UseCssVarOptions {
    /**
     * @en Use MutationObserver to monitor variable changes
     * @zh 使用 MutationObserver 来监听变量变更
     * @zh-Hant 使用 MutationObserver 來監聽變數變更
     * @defaultValue false
     */
    observe?: boolean;
}

declare const useCssVar: UseCssVar;

type DepsEqualFnType<TDeps extends DependencyList> = (prevDeps: TDeps, nextDeps: TDeps) => boolean;
/**
 * @title useCustomCompareEffect
 */
type UseCustomCompareEffect = <TDeps extends DependencyList>(
/**
 * @zh 副作用函数
 * @zh-Hant 副作用函數
 * @en effect callback
 */
effect: EffectCallback, 
/**
 * @zh 依赖列表
 * @zh-Hant 依賴列表
 * @en deps
 */
deps: TDeps, 
/**
 * @zh 依赖比较函数
 * @zh-Hant 依賴比較函數
 * @en deps compare function
 */
depsEqual: DepsEqualFnType<TDeps>) => void;

declare const useCustomCompareEffect: UseCustomCompareEffect;

/**
 * @title useCycleList
 * @returns_en A tuple with the following elements:
 * - The current index value of the list.
 * - A function to set index to prev.
 * - A function to set index to next.
 *  @returns 包含以下元素的元组：
 * - 数组中当前的索引对象值
 * - 设置索引为前一个的函数
 * - 设置索引为后一个的函数
 * @returns_zh-Hant 包含以下元素的元組：
 * - 陣列中當前的索引對象值
 * - 設定索引為前一個的函數
 * - 設定索引為後一個的函數
 */
type UseCycleList = <T>(
/**
 * @zh 循环数组
 * @zh-Hant 循環陣列
 * @en cycle array
 */
list: T[], 
/**
 * @zh 数组索引
 * @zh-Hant 陣列索引
 * @en array index
 */
i?: number) => readonly [T, (i?: number) => void, (i?: number) => void];

declare const useCycleList: UseCycleList;

/**
 * @title UseDarkOptions
 */
interface UseDarkOptions {
    /**
     * @en CSS Selector for the target element applying to
     * @zh 适用于目标元素的 CSS 选择器
     * @zh-Hant 適用於目標元素的 CSS 選擇器
     * @defaultValue 'html'
     */
    selector?: string;
    /**
     * @en HTML attribute applying the target element
     * @zh 应用到目标元素的 html 属性
     * @zh-Hant 應用到目標元素的 html 屬性
     * @defaultValue 'class'
     */
    attribute?: string;
    /**
     * @en default value
     * @zh 默认值
     * @zh-Hant 預設值
     * @defaultValue false
     */
    defaultValue?: boolean;
    /**
     * @en Key to persist the data into localStorage/sessionStorage.
     * @zh 将数据持久保存到 localStorage/sessionStorage 的键值
     * @zh-Hant 將資料持久保存到 localStorage/sessionStorage 的鍵值
     * @defaultValue 'reactuses-color-scheme'
     */
    storageKey?: string;
    /**
     * @en Storage object, can be localStorage or sessionStorage
     * @zh 存储对象，可以是localStorage或sessionStorage
     * @zh-Hant 儲存對象，可以是localStorage或sessionStorage
     * @defaultValue `localStorage`
     */
    storage?: () => Storage;
    /**
     * @en name dark apply to element
     * @zh  应用到目标元素上黑色类名称
     * @zh-Hant 應用到目標元素上黑色類名稱
     */
    classNameDark: string;
    /**
     * @en name light apply to element
     * @zh 应用到目标元素上的亮色类名称
     * @zh-Hant 應用到目標元素上的亮色類名稱
     */
    classNameLight: string;
}
/**
 * @title useDarkMode
 * @returns_en A tuple with the following elements:
 * - The current value of the dark state.
 * - A function to toggle the dark state.
 * -  A function to update the dark state.
 * @returns 包含以下元素的元组：
 * - 黑暗状态的当前值。
 * - 切换黑暗状态的功能。
 * - 更新黑暗状态的功能。
 * @returns_zh-Hant 包含以下元素的元組：
 * - 黑暗狀態的當前值。
 * - 切換黑暗狀態的功能。
 * - 更新黑暗狀態的功能。
 */
type UseDarkMode = (options: UseDarkOptions) => readonly [
    boolean | null,
    () => void,
    React.Dispatch<React.SetStateAction<boolean | null>>
];

declare const useDarkMode: UseDarkMode;

/**
 * @title useDebounce
 */
type UseDebounce = <T>(
/**
 * @zh 要防抖的值
 * @zh-Hant 要防抖的值
 * @en the value need to debounce
 */
value: T, 
/**
 * @zh 间隔时间
 * @zh-Hant 間隔時間
 * @en wait time
 */
wait?: number, 
/**
 * @zh 传递给 `lodash.debounce` 的选项
 * @zh-Hant 傳遞給 `lodash.debounce` 的選項
 * @en options passed to `lodash.debounce`
 */
options?: DebounceSettings) => T;

declare const useDebounce: UseDebounce;

/**
 * @title useDebounceFn
 * @returns_en A object with the following elements:
 * - run: exec function.
 * - cancel: cancel exec function.
 * - flush:  immediately exec function
 * @returns 具有以下元素的对象:
 * - run：执行函数。
 * - cancel：取消执行函数。
 * - flush: 立即执行函数
 * @returns_zh-Hant 具有以下元素的對象:
 * - run：執行函數。
 * - cancel：取消執行函數。
 * - flush: 立即執行函數
 */
type UseDebounceFn = <T extends (...args: any) => any>(
/**
 * @zh 要防抖的函数
 * @zh-Hant 要防抖的函數
 * @en debounce function
 */
fn: T, 
/**
 * @zh 间隔时间
 * @zh-Hant 間隔時間
 * @en wait time
 */
wait?: number, 
/**
 * @zh 传递给 `lodash.debounce` 的属性
 * @zh-Hant 傳遞給 `lodash.debounce` 的屬性
 * @en options passed to `lodash.debounce`
 */
options?: DebounceSettings$1) => {
    run: DebouncedFunc<(...args_0: Parameters<T>) => ReturnType<T>>;
    cancel: () => void;
    flush: any;
};

declare const useDebounceFn: UseDebounceFn;

/**
 * @title useDeepCompareEffect
 */
type UseDeepCompareEffect = (
/**
 * @zh 副作用函数
 * @zh-Hant 副作用函數
 * @en effect function
 */
effect: EffectCallback, 
/**
 * @zh 依赖列表
 * @zh-Hant 依賴列表
 * @en dep list
 */
deps: DependencyList) => void;

declare const useDeepCompareEffect: UseDeepCompareEffect;

declare function useDocumentVisibility(defaultValue?: DocumentVisibilityState): DocumentVisibilityState;

/**
 * @title useDoubleClick
 */
type UseDoubleClick = (props: UseDoubleClickProps) => void;
/**
 * @title UseDoubleClickProps
 */
interface UseDoubleClickProps {
    /**
     * @zh dom对象
     * @zh-Hant dom對象
     * @en dom element
     */
    target: BasicTarget<Element>;
    /**
     * @zh 延迟时间（毫秒）
     * @zh-Hant 延遲時間（毫秒）
     * @en latency time (milliseconds)
     */
    latency?: number | undefined;
    /**
     * @zh 单击事件处理函数
     * @zh-Hant 單擊事件處理函數
     * @en single click event handler
     */
    onSingleClick?: ((e?: MouseEvent | TouchEvent) => void) | undefined;
    /**
     * @zh 双击事件处理函数
     * @zh-Hant 雙擊事件處理函數
     * @en double click event handler
     */
    onDoubleClick?: ((e?: MouseEvent | TouchEvent) => void) | undefined;
}

declare const useDoubleClick: UseDoubleClick;

type Fn = (this: any, ...args: any[]) => any;
type Stoppable = [boolean, Fn, Fn];
type PointerType = 'mouse' | 'touch' | 'pen';
interface Position {
    x: number;
    y: number;
}
/**
 * @title Pausable
 */
interface Pausable$1 {
    /**
     * @en A ref indicate whether a pausable instance is active
     * @zh 一个 ref，表示一个 pausable 实例是否处于激活状态
     */
    isActive: boolean;
    /**
     * @en Temporary pause the effect from executing
     * @zh 暂时暂停效果的执行
     */
    pause: Fn;
    /**
     * @en Resume the effects
     * @zh 恢复效果
     */
    resume: Fn;
}

/**
 * @title useDraggable
 * @returns 包含以下元素的元组：
 * - x
 * - y
 * - 元素是否在拖动中
 * - 设置元素的位置
 * @returns_en A tuple with the following elements:
 * - x
 * - y
 * - Whether the element is being dragged
 * set the element position
 * @returns_zh-Hant 包含以下元素的元組：
 * - x
 * - y
 * - 元素是否在拖動中
 * - 設定元素的位置
 */
type UseDraggable = (
/**
 * @zh dom对象
 * @zh-Hant dom對象
 * @en dom element
 */
target: BasicTarget<HTMLElement | SVGElement>, 
/**
 * @zh 可选参数
 * @zh-Hant 可選參數
 * @en optional params
 */
options?: UseDraggableOptions) => readonly [number, number, boolean, Dispatch<SetStateAction<Position>>];
/**
 * @title  UseDraggableOptions
 */
interface UseDraggableOptions {
    /**
     * @en Only start the dragging when click on the element directly
     * @zh 仅当直接单击元素时才开始拖动
     * @defaultValue false
     */
    exact?: boolean;
    /**
     * @en Prevent events defaults
     * @zh 阻止默认事件
     * @defaultValue false
     */
    preventDefault?: boolean;
    /**
     * @en Prevent events propagation
     * @zh 阻止事件冒泡
     * @defaultValue false
     */
    stopPropagation?: boolean;
    /**
     * @en Element to attach `pointermove` and `pointerup` events to.
     * @zh 将“pointermove”和“pointerup”事件附加到的dom元素
     * @defaultValue window
     */
    draggingElement?: BasicTarget<HTMLElement | SVGElement>;
    /**
     * @en Element for calculating bounds (If not set, it will use the event's target).
     * @zh 设置拖拽容器边界
     * @defaultValue undefined
     */
    containerElement?: BasicTarget<HTMLElement | SVGAElement>;
    /**
     * @en Handle that triggers the drag event
     * @zh 触发拖动事件的dom元素
     * @defaultValue target
     */
    handle?: RefObject<HTMLElement | SVGElement>;
    /**
     * @en Pointer types that listen to.
     * @zh 监听的事件类型
     * @defaultValue ['mouse', 'touch', 'pen']
     */
    pointerTypes?: PointerType[];
    /**
     * @en Initial position of the element.
     * @zh 初始的元素位置
     * @defaultValue { x: 0, y: 0 }
     */
    initialValue?: Position;
    /**
     * @en Callback when the dragging starts. Return `false` to prevent dragging.
     * @zh 拖动开始时的回调。 返回“false”以防止拖动
     */
    onStart?: (position: Position, event: PointerEvent) => void | false;
    /**
     * @en Callback during dragging.
     * @zh 拖动时候的回调
     */
    onMove?: (position: Position, event: PointerEvent) => void;
    /**
     * @en Callback when dragging end.
     * @zh 拖动结束的回调
     */
    onEnd?: (position: Position, event: PointerEvent) => void;
}

declare const useDraggable: UseDraggable;

/**
 * @title useDropZone
 * @returns 文件是否在区域上
 * @returns_en Whether the file is on the zone
 * @returns_zh-Hant 檔案是否在區域上
 */
type UseDropZone = (
/**
 * @zh 目标元素
 * @zh-Hant 目標元素
 * @en target element
 */
target: BasicTarget<EventTarget>, 
/**
 * @zh 拖拽释放时候的回调
 * @zh-Hant 拖拽釋放時候的回調
 * @en drop callback
 */
onDrop?: ((files: File[] | null) => void) | undefined) => boolean;

declare const useDropZone: UseDropZone;

/**
 * @title useElementBounding
 */
type UseElementBounding = (
/**
 * @zh 目标元素
 * @zh-Hant 目標元素
 * @en target element
 */
target: BasicTarget<Element>, 
/**
 * @zh 可选参数
 * @zh-Hant 可選參數
 * @en optional params
 */
options?: UseElementBoundingOptions) => UseElementBoundingReturn;
/**
 * @title UseElementBoundingOptions
 */
interface UseElementBoundingOptions {
    /**
     * @en Reset values to 0 on component unmounted
     * @zh 将数值重置为0
     * @defaultValue true
     */
    reset?: boolean;
    /**
     * @en Listen to window resize event
     * @zh 是否监听 resize 事件
     * @defaultValue true
     */
    windowResize?: boolean;
    /**
     * @en Listen to window scroll event
     * @zh 是否监听 scroll 事件
     * @defaultValue true
     */
    windowScroll?: boolean;
    /**
     * @en Immediately call update on component mounted
     * @zh 立即更新
     * @default true
     */
    immediate?: boolean;
}
/**
 * @title UseElementBoundingReturn
 */
interface UseElementBoundingReturn {
    /**
     * @en Height of the element
     * @zh 元素的高度
     */
    readonly height: number;
    /**
     * @en Bottom position of the element
     * @zh 元素的底部位置
     */
    readonly bottom: number;
    /**
     * @en Left position of the element
     * @zh 元素的左侧位置
     */
    readonly left: number;
    /**
     * @en Right position of the element
     * @zh 元素的右侧位置
     */
    readonly right: number;
    /**
     * @en Top position of the element
     * @zh 元素的顶部位置
     */
    readonly top: number;
    /**
     * @en Width of the element
     * @zh 元素的宽度
     */
    readonly width: number;
    /**
     * @en X position of the element
     * @zh 元素的 X 位置
     */
    readonly x: number;
    /**
     * @en Y position of the element
     * @zh 元素的 Y 位置
     */
    readonly y: number;
    /**
     * @en Manual update
     * @zh 手动更新
     */
    readonly update: () => void;
}

declare const useElementBounding: UseElementBounding;

/**
 * @title useElementSize
 * @returns_en A tuple with the following elements:
 * - width
 * - height
 * @returns 包含以下元素的元组：
 * - 元素宽度。
 * - 元素高度。
 * @returns_zh-Hant 包含以下元素的元組：
 * - 元素寬度。
 * - 元素高度。
 */
type UseElementSize = (
/**
 * @zh dom对象
 * @zh-Hant dom對象
 * @en dom element
 */
target: BasicTarget<Element>, 
/**
 * @zh `resizeObserver` 参数
 * @en options passed to `resizeObserver`
 */
options?: ResizeObserverOptions) => readonly [number, number];

declare const useElementSize: UseElementSize;

/**
 * @title useElementVisibility
 * @returns 包含以下元素的元组：
 * - 当前元素是否可见。
 * - 停止监听函数。
 * @returns_en A tuple with the following elements:
 * - is the current element visible.
 * - stop observer listening function.
 * @returns_zh-Hant 包含以下元素的元組：
 * - 當前元素是否可見。
 * - 停止監聽函數。
 */
type UseElementVisibility = (
/**
 * @zh dom对象
 * @zh-Hant dom對象
 * @en dom element
 */
target: BasicTarget<HTMLElement | SVGElement>, 
/**
 * @zh 传递给 `intersectionObserver` 的选项
 * @zh-Hant 傳遞給 `intersectionObserver` 的選項
 * @en options passed to `intersectionObserver`
 */
options?: IntersectionObserverInit) => readonly [boolean, () => void];

declare const useElementVisibility: UseElementVisibility;

/**
 * @title useEvent
 */
type UseEvent = <T extends Fn>(
/**
 * @zh 函数
 * @zh-Hant 函數
 * @en function
 */
fn: T) => T;

/**
 * keep function reference immutable
 */
declare const useEvent: UseEvent;

/**
 * @title useEventEmitter
 * @returns 包含以下元素的元组：
 * - 添加监听器的函数。
 * - 触发函数。
 * - 停止函数。
 * @returns_en A tuple with the following elements:
 * - a function to add lisenter.
 * - fire functiion.
 * stop functiion
 * @returns_zh-Hant 包含以下元素的元組：
 * - 添加監聽器的函數。
 * - 觸發函數。
 * - 停止函數。
 */
type UseEventEmitter = <T, U = void>() => readonly [
    UseEventEmitterEvent<T, U>,
    (arg1: T, arg2: U) => void,
    () => void
];
interface UseEventEmitterListener<T, U = void> {
    (arg1: T, arg2: U): void;
}
interface UseEventEmitterDisposable {
    dispose: () => void;
}
interface UseEventEmitterEvent<T, U = void> {
    (listener: (arg1: T, arg2: U) => any): UseEventEmitterDisposable;
}
interface UseEventEmitterEventOnce<T, U = void> {
    (listener: (arg1: T, arg2: U) => any): void;
}
interface UseEventEmitterReturn<T, U = void> {
    /**
     * Subscribe to an event. When calling emit, the listeners will execute.
     * @param listener watch listener.
     * @returns a stop function to remove the current callback.
     */
    event: UseEventEmitterEvent<T, U>;
    /**
     * fire an event, the corresponding event listeners will execute.
     * @param event data sent.
     */
    fire: (arg1: T, arg2: U) => void;
    /**
     * Remove all corresponding listener.
     */
    dispose: () => void;
}

declare function useEventEmitter<T, U = void>(): readonly [UseEventEmitterEvent<T, U>, (arg1: T, arg2: U) => void, () => void];

type Target = BasicTarget<HTMLElement | Element | Window | Document | EventTarget>;
declare function useEventListener<K extends keyof WindowEventMap>(eventName: K, handler: (event: WindowEventMap[K]) => void, element?: Window, options?: boolean | AddEventListenerOptions): void;
declare function useEventListener<K extends keyof DocumentEventMap>(eventName: K, handler: (event: DocumentEventMap[K]) => void, element: Document, options?: boolean | AddEventListenerOptions): void;
declare function useEventListener<K extends keyof HTMLElementEventMap, T extends HTMLElement = HTMLDivElement>(eventName: K, handler: (event: HTMLElementEventMap[K]) => void, element: T, options?: boolean | AddEventListenerOptions): void;
declare function useEventListener<K extends keyof ElementEventMap>(eventName: K, handler: (event: ElementEventMap[K]) => void, element: Element, options?: boolean | AddEventListenerOptions): void;
declare function useEventListener<K = Event>(eventName: string, handler: (event: K) => void, element: EventTarget | null | undefined, options?: boolean | AddEventListenerOptions): void;
declare function useEventListener(eventName: string, handler: (...p: any) => void, element?: Target, options?: boolean | AddEventListenerOptions): void;

/**
 * @title useEyeDropper
 * @returns 包含以下元素的元组：
 * - 浏览器是否支持该特性。
 * - 打开颜色选择器的函数。
 * @returns_en A tuple with the following elements:
 * - Whether the browser supports this feature.
 * - A function to open eye dropper.
 * @returns_zh-Hant 包含以下元素的元組：
 * - 瀏覽器是否支援該特性。
 * - 打開顏色選擇器的函數。
 */
type UseEyeDropper = () => readonly [
    boolean,
    (options?: UseEyeDropperOpenOptions) => Promise<UseEyeDropperOpenReturnType>
];
/**
 * @title UseEyeDropperOpenOptions
 */
interface UseEyeDropperOpenOptions {
    /**
     * @zh 终止信号
     * @zh-Hant 終止信號
     * @en abort signal
     */
    signal?: AbortSignal;
}
/**
 * @title UseEyeDropperOpenReturnType
 */
interface UseEyeDropperOpenReturnType {
    /**
     * @zh rgb 颜色值
     * @en rgb color value
     */
    sRGBHex: string;
}

declare const useEyeDropper: UseEyeDropper;

declare function useFavicon(href: string, baseUrl?: string, rel?: string): void;

/**
 * @title useFileDialog
 * @returns 包含以下元素的元组：
 * - 文件数组。
 * - 打开文件选择器函数。
 * - 重置函数。
 * @returns_en A tuple with the following elements:
 * - file array.
 * - A function to open file dialog.
 * - A function to reset files
 * @returns_zh-Hant 包含以下元素的元組：
 * - 檔案陣列。
 * - 打開檔案選擇器函數。
 * - 重設函數。
 */
type UseFileDialog = (options?: UseFileDialogOptions) => readonly [
    FileList | null,
    (localOptions?: Partial<UseFileDialogOptions>) => Promise<FileList | null | undefined>,
    () => void
];
/**
 * @title UseFileDialogOptions
 */
interface UseFileDialogOptions {
    /**
     * @zh 选择多个文件
     * @zh-Hant 選擇多個檔案
     * @en choose multiple file
     * @defaultValue true
     */
    multiple?: boolean;
    /**
     * @zh 可以接受的文件类型
     * @en accept file type
     * @defaultValue '*'
     */
    accept?: string;
    /**
     * @zh [指定设备，可以从麦克风或者摄像头中获取文件](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/capture)
     * @en [Specify the device to obtain files from the microphone or camera](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/capture)
     * @see [HTMLInputElement Capture](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/capture)
     */
    capture?: string;
}

declare const useFileDialog: UseFileDialog;

/**
 * @title useFirstMountState
 * @returns 组件是否刚刚挂载的布尔值
 * @returns_en A boolean value indicating whether the component is just mounted
 * @returns_zh-Hant 組件是否剛剛掛載的布爾值
 */
type UseFirstMountState = () => boolean;

declare const useFirstMountState: UseFirstMountState;

/**
 * @title useFocus
 * @returns 包含以下元素的元组：
 * - 元素是否聚焦。
 * - 更新聚焦状态。
 * @returns_en A tuple with the following elements:
 * -  whether the element focus.
 * - A function to update focus state.
 * @returns_zh-Hant 包含以下元素的元組：
 * - 元素是否聚焦。
 * - 更新聚焦狀態。
 */
type UseFocus = (
/**
 * @zh dom对象
 * @zh-Hant dom對象
 * @en dom element
 */
target: BasicTarget<HTMLElement | SVGElement>, 
/**
 * @zh 默认值
 * @zh-Hant 預設值
 * @en defaultValue
 * @defaultValue false
 */
initialValue?: boolean) => readonly [boolean, (value: boolean) => void];

declare const useFocus: UseFocus;

/**
 * @title useFps
 * @returns 每秒帧数
 * @returns_en frames per second
 * @returns_zh-Hant 每秒幀數
 */
type UseFps = (options?: UseFpsOptions) => number;
/**
 * @title UseFpsOptions
 */
interface UseFpsOptions {
    /**
     * @en Calculate the FPS on every x frames.
     * @zh 每过 x 帧计算一次
     * @zh-Hant 每過 x 幀計算一次
     * @defaultValue 10
     */
    every?: number;
}

declare function useFps(options?: UseFpsOptions): number;

/**
 * @title useFullScreen
 * @returns 包含以下元素的元组：
 * - 当前是否处于全屏。
 * - 一个操作对象:
 * - enterFullscreen： 进入全屏。
 * - exitFullscreen： 退出全屏。
 * - toggleFullscreen： 切换全屏。
 * - isEnabled： 当前浏览器是否支持全屏。
 * @returns_en A tuple with the following elements:
 * - whether the browser is in fullscreen.
 * - a object：
 * - enterFullscreen
 * - exitFullscreen
 * - toggleFullscreen
 * - isEnabled: whether the browser support fullscreen
 * @returns_zh-Hant 包含以下元素的元組：
 * - 當前是否處於全螢幕。
 * - 一個操作對象:
 * - enterFullscreen： 進入全螢幕。
 * - exitFullscreen： 退出全螢幕。
 * - toggleFullscreen： 切換全螢幕。
 * - isEnabled： 當前瀏覽器是否支援全螢幕。
 */
type UseFullscreen = (
/**
 * @zh dom元素
 * @zh-Hant dom元素
 * @en dom element
 */
target: BasicTarget<Element>, 
/**
 * @zh 可选参数
 * @en optional params
 */
options?: UseFullScreenOptions) => readonly [
    /**
     * @zh 当前是否处于全屏
     * @en whether is in fullscreen
     */
    boolean,
    {
        /**
         * @zh 进入全屏
         * @en enter fullscreen
         */
        readonly enterFullscreen: () => void;
        /**
         * @zh 退出全屏
         * @en exit fullscreen
         */
        readonly exitFullscreen: () => void;
        /**
         * @zh 切换全屏
         * @en toggle fullscreen
         */
        readonly toggleFullscreen: () => void;
        /**
         * @zh 浏览器是否支持
         * @en whether the browser support fullscreen
         */
        readonly isEnabled: boolean;
    }
];
/**
 * @title UseFullScreenOptions
 */
interface UseFullScreenOptions {
    /**
     * @zh 退出时候的回调
     * @en exit callback
     */
    onExit?: () => void;
    /**
     * @zh 进入时候的回调
     * @en enter callback
     */
    onEnter?: () => void;
}

declare const useFullscreen: UseFullscreen;

/**
 * @title useGeoLocation
 * @returns 包含以下元素的对象：
 * - 坐标。
 * - 获取坐标的时间戳。
 * - 错误。
 * - 浏览器是否支持 `geolocation`。
 * @returns_en A object with the following elements:
 * - coordinates.
 * - timestamp when get coordinates.
 * - errors.
 * - Whether the browser supports `geolocation`.
 * @returns_zh-Hant 包含以下元素的對象：
 * - 坐標。
 * - 獲取坐標的時間戳。
 * - 錯誤。
 * - 瀏覽器是否支援 `geolocation`。
 */
type UseGeolocation = (
/**
 * @zh 可选 `PositionOptions` 参数
 * @zh-Hant 可選 `PositionOptions` 參數
 * @en optional `PositionOptions` params
 */
options?: Partial<PositionOptions>) => {
    readonly coordinates: GeolocationCoordinates;
    readonly locatedAt: number | null;
    readonly error: GeolocationPositionError | null;
    /**
     * @zh 浏览器是否支持 `geolocation`
     * @en Whether the browser supports `geolocation`
     */
    readonly isSupported: boolean;
};

declare const useGeolocation: UseGeolocation;

/**
 * @title useHover
 */
type UseHover = <T extends Element = HTMLDivElement>(
/**
 * @zh dom对象
 * @zh-Hant dom對象
 * @en dom element
 */
target: BasicTarget<T>) => boolean;

declare const useHover: UseHover;

/**
 * @title UseIdle
 * @returns 是否处于空闲
 * @returns_en whether user is idle
 * @returns_zh-Hant 是否處於空閒
 */
type UseIdle = (
/**
 * @zh 检测时间
 * @zh-Hant 檢測時間
 * @en detection time
 * @defaultValue 60e3
 */
ms?: number, 
/**
 * @zh 初始值
 * @zh-Hant 初始值
 * @en initial value
 * @defaultValue false
 */
initialState?: boolean, 
/**
 * @zh 监听的事件
 * @en listener events
 * @defaultValue ["mousemove","mousedown","resize","keydown","touchstart","wheel"]
 */
events?: (keyof WindowEventMap)[]) => boolean;

declare const useIdle: UseIdle;

/**
 * @title useScroll
 * @returns 包含以下元素的元组：
 * - x 值。
 * - y 值。
 * - 是否在滚动。
 * - 到达边界状态。
 * - 滚动方向
 * @returns_en A tuple with the following elements:
 * - The x value.
 * - The y value.
 * - Whether it is scrolling.
 * - Boundary arrival status.
 * - Scroll direction.
 * @returns_zh-Hant 包含以下元素的元組：
 * - x 值。
 * - y 值。
 * - 是否在滚動。
 * - 到達邊界狀態。
 * - 滚動方向
 */
type UseScroll = (
/**
 * @zh dom元素
 * @zh-Hant dom元素
 * @en dom elment
 */
target: BasicTarget<Element> | Window | Document, 
/**
 * @zh 可选参数
 * @zh-Hant 可選參數
 * @en optional params
 */
options?: UseScrollOptions) => readonly [
    number,
    number,
    boolean,
    UseScrollArrivedState,
    UseScrollDirection
];
/**
 * @title UseScrollOptions
 */
interface UseScrollOptions {
    /**
     * @en Throttle time for scroll event, it's disabled by default.
     * @zh 滚动事件的节流时间，默认关闭。
     * @zh-Hant 滚動事件的節流時間，預設關閉。
     * @defaultValue 0
     */
    throttle?: number;
    /**
     * @en The check time when scrolling ends.
     * This configuration will be setting to (throttle + idle) when the `throttle` is configured.
     * @zh 滚动结束时的检查时间。
     * 当配置 `throttle` 时，此配置将设置为 (throttle +idle)。
     * @zh-Hant 滚動結束時的檢查時間。
     * 當配置 `throttle` 時，此配置將設置為 (throttle +idle)。
     * @default 200
     */
    idle?: number;
    /**
     * @en Offset arrived states by x pixels
     * @zh 将到达状态偏移 x 像素
     * @zh-Hant 將到達狀態偏移 x 像素
     */
    offset?: UseScrollOffset;
    /**
     * @en Trigger it when scrolling.
     * @zh 滚动的回调
     * @zh-Hant 滚動的回調
     */
    onScroll?: (e: Event) => void;
    /**
     * @en Trigger it when scrolling ends.
     * @zh 滚动结束的回调
     * @zh-Hant 滚動結束的回調
     */
    onStop?: (e: Event) => void;
    /**
     * @en Listener options for scroll event.
     * @zh 滚动事件参数
     * @zh-Hant 滚動事件參數
     * @defaultValue {capture: false, passive: true}
     */
    eventListenerOptions?: boolean | AddEventListenerOptions;
}
interface UseScrollOffset {
    left?: number;
    right?: number;
    top?: number;
    bottom?: number;
}
/**
 * @title UseScrollArrivedState
 */
interface UseScrollArrivedState {
    /**
     * @en arrived left
     * @zh 到达左边
     * @zh-Hant 到達左邊
     */
    left: boolean;
    /**
     * @en arrived right
     * @zh 到达右边
     * @zh-Hant 到達右邊
     */
    right: boolean;
    /**
     * @en arrived top
     * @zh 到达顶部
     * @zh-Hant 到達頂部
     */
    top: boolean;
    /**
     * @en arrived bottom
     * @zh 到达底部
     * @zh-Hant 到達底部
     */
    bottom: boolean;
}
/**
 * @title UseScrollDirection
 */
interface UseScrollDirection {
    /**
     * @en scroll left
     * @zh 向左滚动
     * @zh-Hant 向左滚動
     */
    left: boolean;
    /**
     * @en scroll right
     * @zh 向右滚动
     * @zh-Hant 向右滚動
     */
    right: boolean;
    /**
     * @en scroll top
     * @zh 向上滚动
     * @zh-Hant 向上滚動
     */
    top: boolean;
    /**
     * @en scroll bottom
     * @zh 向下滚动
     * @zh-Hant 向下滚動
     */
    bottom: boolean;
}

/**
 * @title useInfiniteScroll
 */
type UseInfiniteScroll = (
/**
 * @zh dom元素
 * @zh-Hant dom元素
 * @en dom element
 */
target: BasicTarget<Element>, 
/**
 * @zh 加载更多函数
 * @zh-Hant 加載更多函數
 * @en load more function
 */
onLoadMore: UseInfiniteScrollLoadMore, 
/**
 * @zh 可选参数
 * @en optional params
 */
options?: UseInfiniteScrollOptions) => void;
/**
 * @title UseInfiniteScrollLoadMore
 */
type UseInfiniteScrollLoadMore = (
/**
 * @zh `useScroll` 返回的状态
 * @en the return state of `useScroll`
 */
state: readonly [
    number,
    number,
    boolean,
    UseInfiniteScrollArrivedState,
    UseInfiniteScrollDirection
]) => void | Promise<void>;
/**
 * @title UseInfiniteScrollOptions
 */
interface UseInfiniteScrollOptions extends UseScrollOptions {
    /**
     * @en The minimum distance between the bottom of the element and the bottom of the viewport
     * @zh 元素底部与视口底部之间的最小距离
     * @defaultValue 0
     */
    distance?: number;
    /**
     * @en The direction in which to listen the scroll.
     * @zh 滚动方向
     * @defaultValue 'bottom'
     */
    direction?: 'top' | 'bottom' | 'left' | 'right';
    /**
     * @en Whether to preserve the current scroll position when loading more items.
     * @zh 加载更多项目时是否保留当前滚动位置
     * @defaultValueValue false
     */
    preserveScrollPosition?: boolean;
}
/**
 * @title UseInfiniteScrollArrivedState
 */
interface UseInfiniteScrollArrivedState {
    /**
     * @en arrived left
     * @zh 到达左边
     */
    left: boolean;
    /**
     * @en arrived right
     * @zh 到达右边
     */
    right: boolean;
    /**
     * @en arrived top
     * @zh 到达顶部
     */
    top: boolean;
    /**
     * @en arrived bottom
     * @zh 到达底部
     */
    bottom: boolean;
}
/**
 * @title UseInfiniteScrollDirection
 */
interface UseInfiniteScrollDirection {
    /**
     * @en scroll left
     * @zh 向左滚动
     */
    left: boolean;
    /**
     * @en scroll right
     * @zh 向右滚动
     */
    right: boolean;
    /**
     * @en scroll top
     * @zh 向上滚动
     */
    top: boolean;
    /**
     * @en scroll bottom
     * @zh 向下滚动
     */
    bottom: boolean;
}

declare const useInfiniteScroll: UseInfiniteScroll;

/**
 * @title useIntersectionObserver
 * @returns 停止监听函数
 * @returns_en stop listening function
 * @returns_zh-Hant 停止監聽函數
 */
type UseIntersectionObserver = (
/**
 * @zh dom元素
 * @zh-Hant dom元素
 * @en dom element
 */
target: BasicTarget<Element>, 
/**
 * @zh 回调
 * @zh-Hant 回調
 * @en callback
 */
callback: IntersectionObserverCallback, 
/**
 * @zh 传递给 `IntersectionObserver` 的参数
 * @en options passed to `IntersectionObserver`
 */
options?: IntersectionObserverInit) => () => void;

declare const useIntersectionObserver: UseIntersectionObserver;

/**
 * @title useInterval
 */
type UseInterval = (
/**
 * @zh 回调
 * @zh-Hant 回調
 * @en callback
 */
callback: () => void, 
/**
 * @zh 时间，如果为 `null` 的话则停止计时器
 * @zh-Hant 時間，如果為 `null` 的話則停止計時器
 * @en Time, if `null` then stop the timer
 */
delay?: number | null, 
/**
 * @zh 可选参数
 * @en optional params
 */
options?: UseIntervalOptions) => Pausable;
/**
 * @title UseIntervalOptions
 */
interface UseIntervalOptions {
    /**
     * @zh 是否立即执行。
     * @en Whether to execute immediately.
     */
    immediate?: boolean;
    /**
     * @zh 是否控制执行。
     * @en Whether to control execution.
     */
    controls?: boolean;
}
/**
 * @title Pausable
 */
interface Pausable {
    /**
     * @en A ref indicate whether a pausable instance is active
     * @zh 一个 ref，指示一个 pausable 实例是否处于激活状态
     */
    isActive: RefObject<boolean>;
    /**
     * @en Temporary pause the effect from executing
     * @zh 暂时暂停执行效果
     */
    pause: () => void;
    /**
     * @en Resume the effects
     * @zh 恢复效果
     */
    resume: () => void;
}

declare const useInterval: UseInterval;

declare const useIsomorphicLayoutEffect: typeof useEffect;

/**
 * @title useKeyModifier
 * @returns 按键是否被按下
 * @returns_en Whether the key is pressed
 * @returns_zh-Hant 按鍵是否被按下
 */
type UseKeyModifier = (
/**
 * @zh 键位
 * @zh-Hant 鍵位
 * @en key modifier
 */
modifier: KeyModifier, 
/**
 * @zh 可选参数
 * @zh-Hant 可選參數
 * @en optional params
 */
options?: UseModifierOptions) => boolean;
type KeyModifier = 'Alt' | 'AltGraph' | 'CapsLock' | 'Control' | 'Fn' | 'FnLock' | 'Meta' | 'NumLock' | 'ScrollLock' | 'Shift' | 'Symbol' | 'SymbolLock';
/**
 * @title UseModifierOptions
 */
interface UseModifierOptions {
    /**
     * @en Event names that will prompt update to modifier states
     * @zh 更新按键状态的事件
     * @defaultValue ['mousedown', 'mouseup', 'keydown', 'keyup']
     */
    events?: (keyof WindowEventMap)[];
    /**
     * @en Initial value of the returned ref
     * @zh 初始值
     * @defaultValue false
     */
    initial?: boolean;
}

declare const useKeyModifier: UseKeyModifier;

/**
 * @title useLatest
 * @returns ref 对象
 * @returns_en ref object
 * @returns_zh-Hant ref 對象
 */
type UseLatest = <T>(
/**
 * @zh 追踪值
 * @zh-Hant 追蹤值
 * @en tracked value
 */
value: T) => MutableRefObject<T>;

declare const useLatest: UseLatest;

interface Serializer<T> {
    read: (raw: string) => T;
    write: (value: T) => string;
}
interface UseStorageOptions<T> {
    /**
     * @en Custom data serialization
     * @zh 自定义数据序列化
     */
    serializer?: Serializer<T>;
    /**
     * @en On error callback
     * @zh 错误回调
     * @defaultValue `console.error`
     */
    onError?: (error: unknown) => void;
    /**
     * @en set to storage when nodata in first mount
     * @zh 首次挂载时没有数据时设置到 storage
     * @deprecated
     */
    effectStorageValue?: T | (() => T);
    /**
     * @en set to storage when nodata in first mount
     * @zh 首次挂载时没有数据时设置到 storage
     */
    mountStorageValue?: T | (() => T);
    /**
     * @en listen to storage changes
     * @zh 监听 storage 变化
     * @defaultValue `true`
     */
    listenToStorageChanges?: boolean;
}

declare function useLocalStorage(key: string, defaults: string, options?: UseStorageOptions<string>): readonly [string | null, Dispatch<SetStateAction<string | null>>];
declare function useLocalStorage(key: string, defaults: number, options?: UseStorageOptions<number>): readonly [number | null, Dispatch<SetStateAction<number | null>>];
declare function useLocalStorage(key: string, defaults: boolean, options?: UseStorageOptions<boolean>): readonly [boolean | null, Dispatch<SetStateAction<boolean | null>>];
declare function useLocalStorage<T>(key: string, defaults: T, options?: UseStorageOptions<T>): readonly [T | null, Dispatch<SetStateAction<T | null>>];
declare function useLocalStorage<T = unknown>(key: string, defaults: null, options?: UseStorageOptions<T>): readonly [T | null, Dispatch<SetStateAction<T | null>>];

/**
 * @title useLocationSelector
 */
type UseLocationSelector = <R>(
/**
 * @zh 选择器
 * @zh-Hant 選擇器
 * @en selector function
 */
selector: (location: Location) => R, 
/**
 * @zh 默认值
 * @zh-Hant 預設值
 * @en default value
 */
fallback?: R | undefined) => R | undefined;

declare const useLocationSelector: UseLocationSelector;

/**
 * @title useLongPress
 * @returns 包含以下元素的对象：
 * - onMouseDown 鼠标按下事件。
 * - onTouchStart 手指按下事件。
 * - onMouseUp 鼠标松开事件。
 * - onMouseLeave 鼠标离开事件
 * - onTouchEnd 手指松开事件
 * @returns_en A object with the following elements:
 * - onMouseDown: Mouse down event.
 * - onTouchStart: Finger touch start event.
 * - onMouseUp: Mouse up event.
 * - onMouseLeave: Mouse leave event.
 * - onTouchEnd: Finger touch end event.
 * @returns_zh-Hant 包含以下元素的對象：
 * - onMouseDown 滑鼠按下事件。
 * - onTouchStart 手指按下事件。
 * - onMouseUp 滑鼠放開事件。
 * - onMouseLeave 滑鼠離開事件
 * - onTouchEnd 手指放開事件
 */
type UseLongPress = (
/**
 * @zh 回调
 * @zh-Hant 回調
 * @en callback
 */
callback: (e: TouchEvent | MouseEvent) => void, 
/**
 * @zh 可选参数
 * @zh-Hant 可選參數
 * @en optional params
 */
options?: UseLongPressOptions) => {
    readonly onMouseDown: (e: any) => void;
    readonly onTouchStart: (e: any) => void;
    readonly onMouseUp: () => void;
    readonly onMouseLeave: () => void;
    readonly onTouchEnd: () => void;
};
/**
 * @title UseLongPressOptions
 */
interface UseLongPressOptions {
    /**
     * @zh 阻止默认事件
     * @zh-Hant 阻止預設事件
     * @en whether prevent default event
     * @defaultValue true
     */
    isPreventDefault?: boolean;
    /**
     * @zh 延迟
     * @zh-Hant 延遲
     * @en delay time
     * @defaultValue 300
     */
    delay?: number;
}

declare const useLongPress: UseLongPress;

/**
 * @title useMeasure
 * @returns [DOMRect值,停止监听函数]
 * @returns_en [DOMRect, stop listening function]
 * @returns_zh-Hant [DOMRect值,停止監聽函數]
 */
type UseMeasure = (
/**
 * @zh dom对象
 * @zh-Hant dom對象
 * @en dom element
 */
target: BasicTarget<Element>, 
/**
 * @zh 可选参数
 * @zh-Hant 可選參數
 * @en optional params
 */
options?: ResizeObserverOptions) => readonly [UseMeasureRect, () => void];
/**
 * @title UseMeasureRect
 */
type UseMeasureRect = Omit<DOMRectReadOnly, 'toJSON'>;

declare const useMeasure: UseMeasure;

/**
 * @title useMediaDevices
 * @returns 包含以下元素的元组：
 * - 媒体设备信息。
 * - 请求媒体设备权限。
 * @returns_en A tuple with the following elements:
 * - The media devices info.
 * - A function to request media devices permission.
 * @returns_zh-Hant 包含以下元素的元組：
 * - 媒體設備信息。
 * - 請求媒體設備權限。
 */
type UseMediaDevices = (
/**
 * @zh 可选参数
 * @zh-Hant 可選參數
 * @en optional params
 */
options?: UseMediaDeviceOptions) => readonly [
    {
        devices: {
            deviceId: string;
            groupId: string;
            kind: MediaDeviceKind;
            label: string;
        }[];
    },
    () => Promise<boolean>
];
/**
 * @title UseMediaDeviceOptions
 */
interface UseMediaDeviceOptions {
    /**
     * @en Request for permissions immediately if it's not granted,
     * otherwise label and deviceIds could be empty
     * @zh 自动请求权限
     * @zh-Hant 自動請求權限
     * @defaultValue false
     */
    requestPermissions?: boolean;
    /**
     * @en Request for types of media permissions
     * @zh 请求媒体权限类型
     * @zh-Hant 請求媒體權限類型
     * @defaultValue { audio: true, video: true }
     */
    constraints?: MediaStreamConstraints;
}

declare const useMediaDevices: UseMediaDevices;

/**
 * @title useMediaQuery
 * @returns 是否符合媒体查询
 * @returns_en whether comply with media inquiries
 * @returns_zh-Hant 是否符合媒體查詢
 */
type UseMediaQuery = (
/**
 * @zh 媒体查询字符串
 * @zh-Hant 媒體查詢字符串
 * @en media query string
 */
query: string, 
/**
 * @zh 默认值
 * @zh-Hant 預設值
 * @en default value
 */
defaultState?: boolean) => boolean;

declare const useMediaQuery: UseMediaQuery;

/**
 * @title useMount
 */
type UseMount = (
/**
 * @zh 副作用函数
 * @zh-Hant 副作用函數
 * @en effect function
 */
effect: () => void) => void;

declare const useMount: UseMount;

declare function useMountedState(): () => boolean;

/**
 * @title useMouse
 * @returns 鼠标位置
 * @returns_en Mouse Position
 * @returns_zh-Hant 滑鼠位置
 */
type UseMouse = (
/**
 * @zh dom元素
 * @zh-Hant dom元素
 * @en dom element
 */
target?: BasicTarget) => UseMouseCursorState;
/**
 * @title UseMouseCursorState
 */
interface UseMouseCursorState {
    screenX: number;
    screenY: number;
    clientX: number;
    clientY: number;
    pageX: number;
    pageY: number;
    elementX: number;
    elementY: number;
    elementH: number;
    elementW: number;
    elementPosX: number;
    elementPosY: number;
}

declare const useMouse: UseMouse;

/**
 * @title useMousePressed
 * @returns 包含以下元素的元组：
 * - 鼠标是否按下。
 * - 按下的事件来源。
 * @returns_en A tuple with the following elements:
 * - whether the mouse is pressed.
 * - the pressed source type
 * @returns_zh-Hant 包含以下元素的元組：
 * - 滑鼠是否按下。
 * - 按下的事件來源。
 */
type UseMousePressed = (
/**
 * @zh dom对象
 * @zh-Hant dom對象
 * @en dom element
 */
target?: BasicTarget<Element>, 
/**
 * @zh 可选参数
 * @en optional params
 */
options?: UseMousePressedOptions) => readonly [boolean, UseMousePressedSourceType];
/**
 * @title UseMousePressedOptions
 */
interface UseMousePressedOptions {
    /**
     * @en Listen to `touchstart` `touchend` events
     * @zh 监听 `touchstart` 事件
     * @defaultValue true
     */
    touch?: boolean;
    /**
     * @en Listen to `dragstart` `drop` and `dragend` events
     * @zh 监听 `dragStart` 事件
     * @defaultValue true
     */
    drag?: boolean;
    /**
     * @en Initial values
     * @zh 初始值
     * @defaultValue false
     */
    initialValue?: boolean | (() => boolean);
}
/**
 * @title UseMousePressedSourceType
 */
type UseMousePressedSourceType = 'mouse' | 'touch' | null;

declare const useMousePressed: UseMousePressed;

/**
 * @title UseMutationObserver
 * @returns 停止函数
 * @returns_en stop listenering function
 * @returns_zh-Hant 停止函數
 */
type UseMutationObserver = (
/**
 * @zh 回调
 * @zh-Hant 回調
 * @en callback
 */
callback: MutationCallback, 
/**
 * @zh dom元素
 * @zh-Hant dom元素
 * @en dom对象
 */
target: BasicTarget, 
/**
 * @zh 传递给 `MutationObserver` 的参数
 * @en options passed to `MutationObserver`
 */
options?: MutationObserverInit) => () => void;

declare const useMutationObserver: UseMutationObserver;

/**
 * @title useNetwork
 */
type UseNetwork = () => IUseNetworkState;
/**
 * @title IUseNetworkState
 */
interface IUseNetworkState {
    /**
     * @en Whether browser connected to the network or not.
     * @zh 浏览器是否连接网络
     * @zh-Hant 瀏覽器是否連接網路
     */
    online: boolean | undefined;
    /**
     * @en Previous value of `online` property. Helps to identify if browser
     * just connected or lost connection.
     * @zh `online` 属性的先前值。 帮助识别浏览器是否
     * 刚刚连接或失去连接。
     * @zh-Hant `online` 屬性的先前值。 幫助識別瀏覽器是否
     * 剛剛連接或失去連接。
     */
    previous: boolean | undefined;
    /**
     * @en The {Date} object pointing to the moment when state change occurred.
     * @zh {Date} 对象指向状态更改发生的时刻。
     */
    since: Date | undefined;
    /**
     * @en Effective bandwidth estimate in megabits per second, rounded to the
     * nearest multiple of 25 kilobits per seconds.
     * @zh 有效带宽估计（以兆位每秒为单位），四舍五入到
     * 25 kbps 的最接近倍数。
     */
    downlink: INetworkInformation['downlink'] | undefined;
    /**
     * @en Maximum downlink speed, in megabits per second (Mbps), for the
     * underlying connection technology
     * @zh 最大下行链路速度，以兆比特每秒 (Mbps) 为单位
     */
    downlinkMax: INetworkInformation['downlinkMax'] | undefined;
    /**
     * @en Effective type of the connection meaning one of 'slow-2g', '2g', '3g', or '4g'.
     * This value is determined using a combination of recently observed round-trip time
     * and downlink values.
     * @zh 连接的有效类型，表示“slow-2g”、“2g”、“3g”或“4g”之一。
     * 该值是根据最近观察到的往返时间和和下行链路值的组合确定的
     */
    effectiveType: INetworkInformation['effectiveType'] | undefined;
    /**
     * @en Estimated effective round-trip time of the current connection, rounded
     * to the nearest multiple of 25 milliseconds
     * @zh 当前连接的估计有效往返时间，四舍五入
     * 精确到 25 毫秒的最接近倍数
     */
    rtt: INetworkInformation['rtt'] | undefined;
    /**
     * @en {true} if the user has set a reduced data usage option on the user agent.
     * @zh 如果用户在用户代理上设置了减少数据使用选项，则为 {true}。
     */
    saveData: INetworkInformation['saveData'] | undefined;
    /**
     * @en The type of connection a device is using to communicate with the network.
     * It will be one of the following values:
     *  - bluetooth
     *  - cellular
     *  - ethernet
     *  - none
     *  - wifi
     *  - wimax
     *  - other
     *  - unknown
     * @zh 设备用于与网络通信的连接类型。
     * 它将是以下值之一：
     *  - 蓝牙
     * - 蜂窝网络
     * - 以太网
     *  - 没有任何
     *  - 无线上网
     * - 无线麦克斯
     *  - 其他
     * - 未知
     */
    type: INetworkInformation['type'] | undefined;
}
interface INetworkInformation extends EventTarget {
    readonly downlink: number;
    readonly downlinkMax: number;
    readonly effectiveType: 'slow-2g' | '2g' | '3g' | '4g';
    readonly rtt: number;
    readonly saveData: boolean;
    readonly type: 'bluetooth' | 'cellular' | 'ethernet' | 'none' | 'wifi' | 'wimax' | 'other' | 'unknown';
    onChange: (event: Event) => void;
}

declare const useNetwork: UseNetwork;

/**
 * @title useObjectUrl
 * @returns 返回一个由 Blob 或 MediaSource 对象生成的 URL（如果存在），否则返回 undefined
 * @returns_en Returns a URL created from the Blob or MediaSource object, or undefined if none exists
 * @returns_zh-Hant 返回一個由 Blob 或 MediaSource 對象生成的 URL（如果存在），否則返回 undefined
 */
type UseObjectUrl = (
/**
 * @zh 文件或者媒体对象
 * @zh-Hant 檔案或者媒體對象
 * @en file or media source
 */
object: Blob | MediaSource) => string | undefined;

declare const useObjectUrl: UseObjectUrl;

declare const useOnceEffect: typeof useEffect | typeof react.useLayoutEffect;

declare const useOnceLayoutEffect: typeof react.useEffect | typeof useLayoutEffect;

/**
 * @title useOnline
 * @returns 网络是否在线
 * @returns_en whether netwotk is online
 * @returns_zh-Hant 網路是否在線
 */
type UseOnline = () => boolean | undefined;

declare const useOnline: UseOnline;

/**
 * @title useOrientation
 * @returns 包含以下元素的元组：
 * - 方向状态。
 * - 锁定方向。
 * - 解锁方向。
 * @returns_en A tuple with the following elements:
 * - orientation type.
 * - lock orientation.
 * - unlock orientation.
 * @returns_zh-Hant 包含以下元素的元組：
 * - 方向狀態。
 * - 鎖定方向。
 * - 解鎖方向。
 */
type UseOrientation = (
/**
 * @zh 初始值
 * @zh-Hant 初始值
 * @en initial value
 */
initialState?: UseOrientationState) => readonly [
    UseOrientationState,
    (type: UseOrientationLockType) => any,
    () => void
];
/**
 * @title UseOrientationState
 */
interface UseOrientationState {
    /**
     * @zh 角度
     * @en document angle
     */
    angle: number;
    /**
     * @zh 方向类型
     * @en orientation type
     */
    type: UseOrientationType | undefined;
}
/**
 * @title UseOrientationType
 */
type UseOrientationType = 'portrait-primary' | 'portrait-secondary' | 'landscape-primary' | 'landscape-secondary';
/**
 * @title UseOrientationLockType
 */
type UseOrientationLockType = 'any' | 'natural' | 'landscape' | 'portrait' | 'portrait-primary' | 'portrait-secondary' | 'landscape-primary' | 'landscape-secondary';

declare const useOrientation: UseOrientation;

declare function usePageLeave(): boolean;

/**
 * @title usePermission
 * @returns 权限状态
 * @returns_en permission state
 * @returns_zh-Hant 權限狀態
 */
type UsePermission = (
/**
 * @zh 权限描述符
 * @zh-Hant 權限描述符
 * @en permission desc
 */
permissionDesc: UsePermissionGeneralPermissionDescriptor | UsePermissionGeneralPermissionDescriptor['name']) => UsePermissionState;
/**
 * @title UsePermissionState
 */
type UsePermissionState = PermissionState | '';
/**
 * @title UsePermissionGeneralPermissionDescriptor
 */
type UsePermissionGeneralPermissionDescriptor = PermissionDescriptor | {
    name: UsePermissionDescriptorNamePolyfill;
};
/**
 * @title UsePermissionDescriptorNamePolyfill
 */
type UsePermissionDescriptorNamePolyfill = 'accelerometer' | 'accessibility-events' | 'ambient-light-sensor' | 'background-sync' | 'camera' | 'clipboard-read' | 'clipboard-write' | 'gyroscope' | 'magnetometer' | 'microphone' | 'notifications' | 'payment-handler' | 'persistent-storage' | 'push' | 'speaker';

declare const usePermission: UsePermission;

/**
 * @title usePreferredColorScheme
 * @returns prefers-color-scheme的媒体查询值
 * @returns_en value of prefers-color-scheme media query
 * @returns_zh-Hant prefers-color-scheme的媒體查詢值
 */
type UsePreferredColorScheme = (
/**
 * @zh 默认值
 * @zh-Hant 預設值
 * @en default value
 * @defaultValue no-preference
 */
defaultState?: ColorScheme) => ColorScheme;
/**
 * @title ColorScheme
 */
type ColorScheme = 'dark' | 'light' | 'no-preference';

declare const usePreferredColorScheme: UsePreferredColorScheme;

/**
 * @title usePreferredContrast
 */
type UsePreferredContrast = (
/**
 * @zh 默认值
 * @zh-Hant 預設值
 * @en default value
 * @defaultValue no-preference
 */
defaultState?: Contrast) => Contrast;
/**
 * @title Contrast
 */
type Contrast = 'more' | 'less' | 'custom' | 'no-preference';

declare const usePreferredContrast: UsePreferredContrast;

declare function usePreferredDark(defaultState?: boolean): boolean;

declare function usePrevious<T>(value: T): T | undefined;

/**
 * @title useRafFn
 * @returns 包含以下元素的元组：
 * - 停止函数。
 * - 开始函数。
 * - 函数是否在执行中。
 * @returns_en A tuple with the following elements:
 * - stop function
 * - start function
 * whether function is running
 * @returns_zh-Hant 包含以下元素的元組：
 * - 停止函數。
 * - 開始函數。
 * - 函數是否在執行中。
 */
type UseRafFn = (
/**
 * @zh 回调
 * @zh-Hant 回調
 * @en callback
 */
callback: FrameRequestCallback, 
/**
 * @zh 立即执行
 * @en immediatly start
 */
initiallyActive?: boolean) => readonly [() => void, () => void, () => boolean];

declare const useRafFn: UseRafFn;

declare function useRafState<S>(initialState: S | (() => S)): readonly [S, Dispatch<SetStateAction<S>>];

declare function useReducedMotion(defaultState?: boolean): boolean;

/**
 * @title useResizeObserver
 */
type UseResizeObserver = (
/**
 * @zh dom元素
 * @zh-Hant dom元素
 * @en dom element
 */
target: BasicTarget<Element>, 
/**
 * @zh 回调
 * @zh-Hant 回調
 * @en callback
 */
callback: ResizeObserverCallback, 
/**
 * @zh `resizeObserver` 参数
 * @en options passed to `resizeObserver`
 */
options?: ResizeObserverOptions) => () => void;

declare const useResizeObserver: UseResizeObserver;

declare function useScreenSafeArea(): readonly [string, string, string, string, lodash.DebouncedFunc<() => void>];

/**
 * @title UseScratchState
 */
interface UseScratchState {
    /**
     * @zh 是否正在刮擦
     * @zh-Hant 是否正在刮擦
     * @en Whether scratching is in progress
     */
    isScratching: boolean;
    /**
     * @zh 开始时间戳
     * @zh-Hant 開始時間戳
     * @en Start timestamp
     */
    start?: number;
    /**
     * @zh 结束时间戳
     * @zh-Hant 結束時間戳
     * @en End timestamp
     */
    end?: number;
    /**
     * @zh 相对于元素的 x 坐标
     * @zh-Hant 相對於元素的 x 座標
     * @en x coordinate relative to element
     */
    x?: number;
    /**
     * @zh 相对于元素的 y 坐标
     * @zh-Hant 相對於元素的 y 座標
     * @en y coordinate relative to element
     */
    y?: number;
    /**
     * @zh x 方向的增量
     * @zh-Hant x 方向的增量
     * @en Delta in x direction
     */
    dx?: number;
    /**
     * @zh y 方向的增量
     * @zh-Hant y 方向的增量
     * @en Delta in y direction
     */
    dy?: number;
    /**
     * @zh 文档中的 x 坐标
     * @zh-Hant 文檔中的 x 座標
     * @en x coordinate in document
     */
    docX?: number;
    /**
     * @zh 文档中的 y 坐标
     * @zh-Hant 文檔中的 y 座標
     * @en y coordinate in document
     */
    docY?: number;
    /**
     * @zh 元素在文档中的 x 位置
     * @zh-Hant 元素在文檔中的 x 位置
     * @en Element x position in document
     */
    posX?: number;
    /**
     * @zh 元素在文档中的 y 位置
     * @zh-Hant 元素在文檔中的 y 位置
     * @en Element y position in document
     */
    posY?: number;
    /**
     * @zh 元素高度
     * @zh-Hant 元素高度
     * @en Element height
     */
    elH?: number;
    /**
     * @zh 元素宽度
     * @zh-Hant 元素寬度
     * @en Element width
     */
    elW?: number;
    /**
     * @zh 元素 x 位置
     * @zh-Hant 元素 x 位置
     * @en Element x position
     */
    elX?: number;
    /**
     * @zh 元素 y 位置
     * @zh-Hant 元素 y 位置
     * @en Element y position
     */
    elY?: number;
}
/**
 * @title UseScratchOptions
 */
interface UseScratchOptions {
    /**
     * @zh 是否禁用
     * @zh-Hant 是否禁用
     * @en Whether to disable
     * @default false
     */
    disabled?: boolean;
    /**
     * @zh 刮擦时的回调
     * @zh-Hant 刮擦時的回調
     * @en Callback during scratching
     */
    onScratch?: (state: UseScratchState) => void;
    /**
     * @zh 开始刮擦时的回调
     * @zh-Hant 開始刮擦時的回調
     * @en Callback when scratching starts
     */
    onScratchStart?: (state: UseScratchState) => void;
    /**
     * @zh 结束刮擦时的回调
     * @zh-Hant 結束刮擦時的回調
     * @en Callback when scratching ends
     */
    onScratchEnd?: (state: UseScratchState) => void;
}
/**
 * @title useScratch
 * @returns 刮擦状态
 * @returns_en Scratch state
 * @returns_zh-Hant 刮擦狀態
 */
type UseScratch = (
/**
 * @zh 目标元素
 * @zh-Hant 目標元素
 * @en Target element
 */
target: BasicTarget<HTMLElement>, 
/**
 * @zh 配置项
 * @zh-Hant 配置項
 * @en Options
 */
options?: UseScratchOptions) => UseScratchState;

declare const useScratch: UseScratch;

/**
 * @title useScriptTag
 * @returns 包含以下元素的元组：
 * - 用来加载资源的 html 元素。
 * - 资源加载状态。
 * - 资源加载函数。
 * - 资源卸载函数
 * @returns_en A tuple with the following elements:
 * - html element used to load resources.
 * - Resource loading status.
 * - Resource loading function.
 * - Resource unloading function
 * @returns_zh-Hant 包含以下元素的元組：
 * - 用來加載資源的 html 元素。
 * - 資源加載狀態。
 * - 資源加載函數。
 * - 資源卸載函數
 */
type UseScriptTag = (
/**
 * @zh 资源地址
 * @zh-Hant 資源地址
 * @en source
 */
src: string, 
/**
 * @zh 资源加载完成的回调
 * @zh-Hant 資源加載完成的回調
 * @en source loaded callback
 */
onLoaded?: (el: HTMLScriptElement) => void, 
/**
 * @zh 可选参数
 * @zh-Hant 可選參數
 * @en optional params
 */
options?: UseScriptTagOptions) => readonly [
    HTMLScriptElement | null,
    UseScriptTagStatus,
    (waitForScriptLoad?: boolean) => Promise<HTMLScriptElement | boolean>,
    () => void
];
/**
 * @title UseScriptTagOptions
 */
interface UseScriptTagOptions {
    /**
     * @en Load the script immediately
     * @zh 立即加载资源
     * @zh-Hant 立即加載資源
     * @defaultValue true
     */
    immediate?: boolean;
    /**
     * @en Add `async` attribute to the script tag
     * @zh 在 `script` 标签上加上 `async`
     * @zh-Hant 在 `script` 標籤上加上 `async`
     * @defaultValue true
     */
    async?: boolean;
    /**
     * @en Script type
     * @zh 脚本类型
     * @zh-Hant 腳本類型
     * @defaultValue 'text/javascript'
     */
    type?: string;
    /**
     * @en Manual controls the timing of loading and unloading
     * @zh 手动控制加载和卸载时机
     * @zh-Hant 手動控制加載和卸載時機
     * @defaultValue false
     */
    manual?: boolean;
    /**
     * @zh 跨域属性
     * @zh-Hant 跨域屬性
     * @en cross origin
     */
    crossOrigin?: 'anonymous' | 'use-credentials';
    /**
     * @en referrer policy
     * @zh 来源属性
     * @zh-Hant 來源屬性
     */
    referrerPolicy?: 'no-referrer' | 'no-referrer-when-downgrade' | 'origin' | 'origin-when-cross-origin' | 'same-origin' | 'strict-origin' | 'strict-origin-when-cross-origin' | 'unsafe-url';
    /**
     * @en Add `noModule` attribute to the script tag
     * @zh 在 `script` 标签上加上 `noModule`
     * @zh-Hant 在 `script` 標籤上加上 `noModule`
     */
    noModule?: boolean;
    /**
     * @en Add `defer` attribute to the script tag
     * @zh 在 `script` 标签上加上 `defer`
     * @zh-Hant 在 `script` 標籤上加上 `defer`
     */
    defer?: boolean;
    /**
     * @en Add custom attribute to the script tag
     * @zh 在 script 标签上添加自定义属性
     * @zh-Hant 在 script 標籤上添加自定義屬性
     */
    attrs?: Record<string, string>;
}
/**
 * @title UseScriptTagStatus
 */
type UseScriptTagStatus = 'idle' | 'loading' | 'ready' | 'error';

declare const useScriptTag: UseScriptTag;

declare const useScroll: UseScroll;

/**
 * @title useScrollIntoView
 * @returns 包含以下元素的对象：
 * - scrollIntoView：滚动进入视口函数。
 * - cancel： 取消滚动函数。
 * @returns_en A object with the following elements:
 * - scrollIntoView: scroll target element into viewport
 * - cancel: cancel scroll function
 * @returns_zh-Hant 包含以下元素的對象：
 * - scrollIntoView：滚動進入視口函數。
 * - cancel： 取消滚動函數。
 */
type UseScrollIntoView = (
/**
 * @zh dom对象
 * @zh-Hant dom對象
 * @en dom element
 */
targetElement: BasicTarget<HTMLElement>, 
/**
 * @zh 可选参数
 * @en optional params
 */ params?: UseScrollIntoViewParams, 
/**
 * @zh 滚动容器
 * @en scroll container
 */
scrollElement?: BasicTarget<HTMLElement>) => {
    scrollIntoView: (animation?: UseScrollIntoViewAnimation) => void;
    cancel: () => void;
};
/**
 * @title UseScrollIntoViewAnimation
 */
interface UseScrollIntoViewAnimation {
    /**
     * @en target element alignment relatively to parent based on current axis
     * @zh 基于当前轴的目标元素相对于父元素的对齐方式
     */
    alignment?: 'start' | 'end' | 'center';
}
/**
 * @title  UseScrollIntoViewParams
 */
interface UseScrollIntoViewParams {
    /**
     * @en callback fired after scroll
     * @zh 滚动完成回调
     */
    onScrollFinish?: () => void;
    /**
     * @en duration of scroll in milliseconds
     * @zh 滚动时间
     * @defaultValue 1250
     */
    duration?: number;
    /**
     * @en axis of scroll
     * @zh 滚动方向
     * @defaultValue y
     */
    axis?: 'x' | 'y';
    /**
     * @en custom mathematical easing function
     * @zh 自定义缓和数学函数
     * @defaultValue (t: number) => t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t
     */
    easing?: (t: number) => number;
    /**
     * @en additional distance between nearest edge and element
     * @zh 最近的边缘和元素之间的附加距离
     * @defaultValue 0
     */
    offset?: number;
    /**
     * @en indicator if animation may be interrupted by user scrolling
     * @zh 指示动画是否可能因用户滚动而中断
     * @defaultValue true
     */
    cancelable?: boolean;
    /**
     * @en prevents content jumping in scrolling lists with multiple targets
     * @zh 防止内容在具有多个目标的滚动列表中跳跃
     */
    isList?: boolean;
}

declare const useScrollIntoView: UseScrollIntoView;

/**
 * @title useScrollLock
 * @returns 包含以下元素的元组：
 * - 是否锁定。
 * - 更新锁定值的函数。
 * @returns_en A tuple with the following elements:
 * - whether scroll is locked.
 * - A function to update the value of lock state.
 * @returns_zh-Hant 包含以下元素的元組：
 * - 是否鎖定。
 * - 更新鎖定值的函數。
 */
type UseScrollLock = (
/**
 * @zh dom元素
 * @zh-Hant dom元素
 * @en dom element
 */
target: BasicTarget<HTMLElement>, 
/**
 * @zh 默认值
 * @en default value
 * @defaultValue false
 */
initialState?: boolean) => readonly [boolean, (flag: boolean) => void];

declare const useScrollLock: UseScrollLock;

declare function useSessionStorage(key: string, defaults: string, options?: UseStorageOptions<string>): readonly [string | null, Dispatch<SetStateAction<string | null>>];
declare function useSessionStorage(key: string, defaults: number, options?: UseStorageOptions<number>): readonly [number | null, Dispatch<SetStateAction<number | null>>];
declare function useSessionStorage(key: string, defaults: boolean, options?: UseStorageOptions<boolean>): readonly [boolean | null, Dispatch<SetStateAction<boolean | null>>];
declare function useSessionStorage<T>(key: string, defaults: T, options?: UseStorageOptions<T>): readonly [T | null, Dispatch<SetStateAction<T | null>>];
declare function useSessionStorage<T = unknown>(key: string, defaults: null, options?: UseStorageOptions<T>): readonly [T | null, Dispatch<SetStateAction<T | null>>];

/**
 * @title useSetState
 * @returns 包含以下元素的元组：
 * - state 的当前值。
 * - 更新 state 值的函数。
 * @returns_en A tuple with the following elements:
 * - The current value of the state.
 * - A function to update the value of the state.
 * @returns_zh-Hant 包含以下元素的元組：
 * - state 的當前值。
 * - 更新 state 值的函數。
 */
type UseSetState = <T extends Record<string, any>>(
/**
 * @zh 初始值
 * @zh-Hant 初始值
 * @en initial value
 */
initialState: T) => readonly [
    T,
    (statePartial: Partial<T> | ((currentState: T) => Partial<T>)) => void
];

declare const useSetState: UseSetState;

/**
 * @title useSticky
 * @returns 包含以下元素的元组：
 * - 当前是否粘滞。
 * - 更新粘滞值的函数。
 * @returns_en A tuple with the following elements:
 * - The current state of sticky.
 * - A function to update the value of sticky.
 * @returns_zh-Hant 包含以下元素的元組：
 * - 當前是否粘滞。
 * - 更新粘滞值的函數。
 */
type UseSticky = (
/**
 * @zh dom元素
 * @zh-Hant dom元素
 * @en dom element
 */
targetElement: BasicTarget<HTMLElement>, 
/**
 * @zh 可选参数
 * @en optional params
 */
params: UseStickyParams, 
/**
 * @zh 滚动容器
 * @en scroll container
 */
scrollElement?: BasicTarget<HTMLElement>) => [boolean, React.Dispatch<React.SetStateAction<boolean>>];
/**
 * @title UseStickyParams
 */
interface UseStickyParams {
    /**
     * @en axis of scroll
     * @zh 滚动方向
     * @defaultValue y
     */
    axis?: 'x' | 'y';
    /**
     * @en cover height or width
     * @zh 沉浸式高度/宽度
     * @defaultValue 0
     */
    nav: number;
}

declare function useSticky(targetElement: BasicTarget<HTMLElement>, { axis, nav }: UseStickyParams, scrollElement?: BasicTarget<HTMLElement>): [boolean, react__default.Dispatch<react__default.SetStateAction<boolean>>];

declare function useSupported(callback: () => unknown, sync?: boolean): boolean;

/**
 * @title useTextDirection
 * @returns 包含以下元素的元组：
 * - 文字方向。
 * - 更新文字方向值的函数。
 * @returns_en A tuple with the following elements:
 * - The current value of the text direction.
 * - A function to update the value of the text direction.
 * @returns_zh-Hant 包含以下元素的元組：
 * - 文字方向。
 * - 更新文字方向值的函數。
 */
type UseTextDirection = (
/**
 * @zh 可选参数
 * @zh-Hant 可選參數
 * @en optional params
 */
options?: UseTextDirectionOptions) => readonly [UseTextDirectionValue, (value: UseTextDirectionValue) => void];
/**
 * @title UseTextDirectionOptions
 */
interface UseTextDirectionOptions {
    /**
     * @en CSS Selector for the target element applying to
     * @zh 适用于目标元素的 CSS 选择器
     * @zh-Hant 適用於目標元素的 CSS 選擇器
     * @defaultValue 'html'
     */
    selector?: string;
    /**
     * @en Initial value
     * @zh 初始值
     * @zh-Hant 初始值
     * @defaultValue 'ltr'
     */
    initialValue?: UseTextDirectionValue;
}
/**
 * @title UseTextDirectionValue
 */
type UseTextDirectionValue = 'ltr' | 'rtl' | 'auto';

declare const useTextDirection: UseTextDirection;

/**
 * @title useTextSelection
 * @returns 选择的文本对象
 * @returns_en selected text object
 * @returns_zh-Hant 選擇的文本對象
 */
type UseTextSelection = () => Selection | null;

declare const useTextSelection: UseTextSelection;

/**
 * @title useThrottle
 */
type UseThrottle = <T>(
/**
 * @zh 要节流的值
 * @zh-Hant 要節流的值
 * @en the value need to throttle
 */
value: T, 
/**
 * @zh 间隔时间
 * @zh-Hant 間隔時間
 * @en wait time
 */
wait?: number, 
/**
 * @zh 传递给 `lodash.throttle` 的选项
 * @en options passed to `lodash.throttle`
 */
options?: ThrottleSettings) => T;

declare const useThrottle: UseThrottle;

declare function useThrottleFn<T extends (...args: any) => any>(fn: T, wait?: number, options?: ThrottleSettings): {
    run: lodash.DebouncedFuncLeading<(...args_0: Parameters<T>) => ReturnType<T>>;
    cancel: () => void;
    flush: () => ReturnType<T>;
};

/**
 * @title useTimeout
 * @returns 包含以下元素的元组：
 * - 是否等待定时器执行。
 * - 设置定时器。
 * - 取消定时器。
 * @returns_en A tuple with the following elements:
 * - Whether to wait for the timer to execute.
 * - Set timer.
 * - Cancel timer.
 * @returns_zh-Hant 包含以下元素的元組：
 * - 是否等待定時器執行。
 * - 設定定時器。
 * - 取消定時器。
 */
type UseTimeout = (
/**
 * @zh 间隔时间
 * @zh-Hant 間隔時間
 * @en wait time
 */
ms?: number
/**
 * @zh 可选参数
 * @zh-Hant 可選參數
 * @en optional param
 */ , options?: UseTimeoutOptions) => Stoppable;
/**
 * @title UseTimeoutOptions
 */
interface UseTimeoutOptions {
    /**
     * @en Start the timer immediate after calling this function
     * @zh 立即设置定时器
     * @zh-Hant 立即設定定時器
     * @defaultValue true
     */
    immediate?: boolean;
}

declare const useTimeout: UseTimeout;

/**
 * @title useTimeoutFn
 * @returns 包含以下元素的元组：
 * - 是否等待定时器执行。
 * - 设置定时器。
 * - 取消定时器。
 * @returns_en A tuple with the following elements:
 * - Whether to wait for the timer to execute.
 * - Set timer.
 * - Cancel timer.
 * @returns_zh-Hant 包含以下元素的元組：
 * - 是否等待定時器執行。
 * - 設置定時器。
 * - 取消定時器。
 */
type UseTimeoutFn = (
/**
 * @zh 回调
 * @zh-Hant 回調
 * @en callback
 */
cb: (...args: unknown[]) => any, 
/**
 * @zh 间隔时间
 * @zh-Hant 間隔時間
 * @en wait time
 */
interval: number, 
/**
 * @zh 可选参数
 * @zh-Hant 可選參數
 * @en optional param
 */
options?: UseTimeoutFnOptions) => Stoppable;
/**
 * @title UseTimeoutFnOptions
 */
interface UseTimeoutFnOptions {
    /**
     * @en Start the timer immediate after calling this function
     * @zh 立即设置定时器
     * @zh-Hant 立即設置定時器
     * @defaultValue true
     */
    immediate?: boolean;
}

/**
 * Wrapper for `setTimeout` with controls.
 *
 * @param cb
 * @param interval
 * @param options
 */
declare const useTimeoutFn: UseTimeoutFn;

/**
 * @title useTitle
 */
type UseTitle = (
/**
 * @zh 标题
 * @zh-Hant 標題
 * @en title
 */
title: string) => void;

declare const useTitle: UseTitle;

/**
 * @title useToggle
 * @returns 包含以下元素的元组：
 * - 布尔状态的当前值。
 * - 切换布尔状态值的函数。
 * @returns_en A tuple with the following elements:
 * - The current value of the bool state.
 * - A function to update the value of the bool state.
 * @returns_zh-Hant 包含以下元素的元組：
 * - 布林狀態的當前值。
 * - 切換布林狀態值的函數。
 */
type UseToggle = (
/**
 * @zh 初始值
 * @zh-Hant 初始值
 * @en initialValue
 */
initialValue: boolean) => [boolean, (nextValue?: any) => void];

declare const useToggle: UseToggle;

declare function useUnmount(fn: () => void): void;

declare function useUpdate(): () => void;

declare const useUpdateEffect: typeof useEffect | typeof react.useLayoutEffect;

declare const useUpdateLayoutEffect: typeof react.useEffect | typeof useLayoutEffect;

/**
 * @title useWebNotification
 */
type UseWebNotification = (
/**
 * @zh 自动请求权限
 * @zh-Hant 自動請求權限
 * @en auto request permission
 */
requestPermissions?: boolean) => UseWebNotificationReturn;
/**
 * @title UseWebNotificationReturn
 */
interface UseWebNotificationReturn {
    /**
     * @zh 浏览器是否支持
     * @zh-Hant 瀏覽器是否支援
     * @en whether browser support
     */
    readonly isSupported: boolean;
    /**
     * @zh 展示函数
     * @en show function
     */
    readonly show: UseWebNotificationShow;
    /**
     * @zh 关闭函数
     * @en close function
     */
    readonly close: () => void;
    /**
     * @zh 请求权限函数
     * @en request permissions function
     */
    readonly ensurePermissions: () => Promise<boolean | undefined>;
    /**
     * @zh 权限状态
     * @en permission status
     */
    readonly permissionGranted: React.MutableRefObject<boolean>;
}
/**
 * @title UseWebNotificationShow
 */
type UseWebNotificationShow = (
/**
 * @zh 通知标题
 * @en notification title
 */
title: string, 
/**
 * @zh 通知选项
 * @en options passed to `NotificationOptions`
 */
options?: NotificationOptions) => Notification | undefined;

declare const useWebNotification: UseWebNotification;

declare function useWindowsFocus(defauleValue?: boolean): boolean;

/**
 * @title useWindowScroll
 * @returns {UseWindowScrollState}
 */
type UseWindowScroll = () => UseWindowScrollState;
/**
 * @title useWindowScrollState
 */
interface UseWindowScrollState {
    /**
     * @zh 水平滚动的像素值
     * @zh-Hant 水平滚動的像素值
     * @en pixel value of horizontal scrolling
     */
    x: number;
    /**
     * @zh 垂直滚动的像素值
     * @zh-Hant 垂直滚動的像素值
     * @en pixel value of vertical scrolling
     */
    y: number;
}

declare function useWindowScroll(): UseWindowScrollState;

/**
 * @title useWindowSize
 * @returns_en A object with the following elements:
 * - width: The current window width.
 * - height: The current window height.
 * @returns 包含以下元素的对象：
 * - width：当前视窗宽度。
 * - height： 当前视窗高度。
 * @returns_zh-Hant 包含以下元素的對象：
 * - width：當前視窗寬度。
 * - height： 當前視窗高度。
 */
type UseWindowSize = () => {
    readonly width: number;
    readonly height: number;
};

declare const useWindowSize: UseWindowSize;

/**
 * @title useClipBoard
 * @returns_en Returns a readonly tuple.
 * @returns 返回只读元组.
 * @returns_zh-Hant 返回唯讀元組.
 */
type UseClipboard = () => readonly [string, (txt: string) => Promise<void>];

declare const useClipboard: UseClipboard;

type Platform = 'ios' | 'android' | 'unknown';
/**
 * @title UsePlatformProps
 */
interface UsePlatformProps {
    /**
     * @zh 服务端渲染时，需要传递 `userAgent`
     * @zh-Hant 服務端渲染時，需要傳遞 `userAgent`
     * @en When server rendering, you need to pass `userAgent`
     */
    userAgent?: string;
}
/**
 * @title usePlatform
 * @returns 和平台相关的对象
 * @returns_en object that related to platform
 */
type UsePlatform = (props?: UsePlatformProps) => UsePlatformReturn;
/**
 * @title UsePlatformReturn
 */
interface UsePlatformReturn {
    /**
     * @zh 平台
     * @en platform
     */
    platform: Platform;
    /**
     * @zh 是否在小程序中
     * @en Whether in mini program
     */
    isInMiniProgram: () => boolean;
    /**
     * @zh 是否在微信中
     * @en whether in wechat
     */
    isInWechat: () => boolean;
    /**
     * @zh 是否是 iPhoneX
     * @en whether is iPhoneX
     */
    isiPhoneX: () => boolean;
}

declare const usePlatform: UsePlatform;

declare function useMobileLandscape(): boolean;

/**
 * @title useControlledState
 * @returns_en A tuple with the following elements:
 * - The current value.
 * - A function to update the value.
 * @returns 包含以下元素的元组：
 * - 当前值。
 * - 更新当前值的函数。
 * @returns_zh-Hant 包含以下元素的元組：
 * - 當前值。
 * - 更新當前值的函數。
 */
type UseControlled = <T>(
/**
 * @en controlled value
 * @zh 受控值
 * @zh-Hant 受控值
 */
value: T | undefined, 
/**
 * @en default value
 * @zh 默认值
 * @zh-Hant 預設值
 */
defaultValue: T, 
/**
 * @en callback when value change
 * @zh 值改变时的回调
 * @zh-Hant 值改變時的回調
 */
onChange?: ((v: T, ...args: any[]) => void) | undefined) => [T, (value: T) => void];

declare const useControlled: UseControlled;

/**
 * @title UseDisclosureProps
 */
interface UseDisclosureProps {
    /**
     * @en Whether the disclosure is open, if passed, it will be controlled
     * @zh 是否打开，传了则为受控
     * @zh-Hant 是否打開，傳了則為受控
     */
    isOpen?: boolean;
    /**
     * @en default open state
     * @zh 默认打开状态
     * @zh-Hant 預設打開狀態
     */
    defaultOpen?: boolean;
    /**
     * @en Callback when disclosure is closed
     * @zh 关闭时的回调
     * @zh-Hant 關閉時的回調
     */
    onClose?: () => void;
    /**
     * @en Callback when disclosure is opened
     * @zh 打开时的回调
     * @zh-Hant 打開時的回調
     */
    onOpen?: () => void;
    /**
     * @en Callback when disclosure is changed
     * @zh 状态改变时的回调
     * @zh-Hant 狀態改變時的回調
     */
    onChange?: (isOpen: boolean | undefined) => void;
}
/**
 * @title useDisclosure
 */
type UseDisclosure = (props?: UseDisclosureProps) => {
    isOpen: boolean;
    onOpen: () => void;
    onClose: () => void;
    onOpenChange: () => void;
    isControlled: boolean;
};

declare function useDisclosure(props?: UseDisclosureProps): {
    isOpen: boolean;
    onOpen: () => void;
    onClose: () => void;
    onOpenChange: () => void;
    isControlled: boolean;
};

type EventSourceStatus = 'CONNECTING' | 'CONNECTED' | 'DISCONNECTED';
/**
 * @title UseEventSourceOptions
 */
interface UseEventSourceOptions extends EventSourceInit {
    /**
     * @en immediately open the connection, enabled by default
     * @zh 立即打开连接, 默认打开
     * @zh-Hant 立即打開連接, 預設打開
     */
    immediate?: boolean;
    /**
     * @en Automatically reconnect when the connection is disconnected
     * @zh 连接断开时自动重连
     * @zh-Hant 連接斷開時自動重連
     */
    autoReconnect?: UseEventSourceAutoReconnectOptions;
}
/**
 * @title UseEventSourceAutoReconnectOptions
 */
interface UseEventSourceAutoReconnectOptions {
    /**
     * @en The number of retries, if it is a function, it will be called to determine whether to retry
     * @zh 重试次数，如果是函数，会调用来判断是否重试
     */
    retries?: number | (() => boolean);
    /**
     * @en The delay time before reconnecting
     * @zh 重连前的延迟时间
     */
    delay?: number;
    /**
     * @en Callback when reconnection fails
     * @zh 重连失败时的回调
     */
    onFailed?: () => void;
}
type UseEventSource = <Events extends string[]>(
/**
 * @en The URL of the server-sent event
 * @zh 服务器发送事件的 URL
 */
url: string | URL, 
/**
 * @en The event name to listen to
 * @zh 要监听的事件名
 */
events?: Events, 
/**
 * @en EventSource options
 * @zh EventSource 选项
 */
options?: UseEventSourceOptions) => UseEventSourceReturn;
/**
 * @title UseEventSourceReturn
 */
interface UseEventSourceReturn {
    /**
     * @en EventSource instance
     * @zh EventSource 实例
     */
    eventSourceRef: React.MutableRefObject<EventSource | null>;
    /**
     * @en The data received
     * @zh 接收到的数据
     */
    data: string | null;
    /**
     * @en The error occurred
     * @zh 发生的错误
     */
    error: Event | null;
    /**
     * @en The status of the connection
     * @zh 连接的状态
     */
    status: EventSourceStatus;
    /**
     * @en The last event ID
     * @zh 最后的事件 ID
     */
    lastEventId: string | null;
    /**
     * @en The event name
     * @zh 事件名
     */
    event: string | null;
    /**
     * @zh 关闭连接
     * @en Close the connection
     */
    close: () => void;
    /**
     * @zh 打开连接
     *  @en Open the connection
     */
    open: () => void;
}

declare const useEventSource: UseEventSource;

/**
 * @title useMergedRef
 * @returns 合并多个 ref 的函数
 * @returns_en A function that merges multiple refs
 * @returns_zh-Hant 合併多個 ref 的函數
 */
type UseMergedRef = <T>(...refs: PossibleRef<T>[]) => (node: T | null) => void;
type PossibleRef<T> = Ref<T> | undefined;

declare function assignRef<T>(ref: PossibleRef<T>, value: T): void;
declare function mergeRefs<T>(...refs: PossibleRef<T>[]): (node: T | null) => void;
declare function useMergedRefs<T>(...refs: PossibleRef<T>[]): (node: T | null) => void;

/**
 * @description copy from swr
 */
declare const use: any;

/**
 * @title UsePreferredLanguages
 * @returns 语言偏好
 * @returns_en preferred languages
 * @returns_zh-Hant 語言偏好
 */
type UsePreferredLanguages = (
/**
 * @zh 默认值
 * @zh-Hant 預設值
 * @en defaule value
 */ defaultLanguages?: string[]) => string[];

declare const usePreferredLanguages: UsePreferredLanguages;

/**
 * @title UseBroadcastChannelOptions
 */
interface UseBroadcastChannelOptions {
    /**
     * @zh 频道名称
     * @zh-Hant 頻道名稱
     * @en channel name
     */
    name: string;
}
/**
 * @title UseBroadcastChannel
 */
type UseBroadcastChannel = <D, P>(
/**
 * @zh 选项
 * @zh-Hant 選項
 * @en options
 */
options: UseBroadcastChannelOptions) => UseBroadcastChannelReturn<D, P>;
/**
 * @title UseBroadcastChannelReturn
 */
interface UseBroadcastChannelReturn<D, P> {
    /**
     * @zh 是否支持
     * @zh-Hant 是否支援
     * @en is supported
     */
    readonly isSupported: boolean;
    /**
     * @zh 频道
     * @zh-Hant 頻道
     * @en channel
     */
    readonly channel: BroadcastChannel | undefined;
    /**
     * @zh 数据
     * @zh-Hant 資料
     * @en data
     */
    readonly data: D | undefined;
    /**
     * @zh 发送数据
     * @zh-Hant 發送資料
     * @en post data
     */
    readonly post: (data: P) => void;
    /**
     * @zh 关闭
     * @zh-Hant 關閉
     * @en close
     */
    readonly close: () => void;
    /**
     * @zh 错误
     * @zh-Hant 錯誤
     * @en error
     */
    readonly error: Event | null;
    /**
     * @zh 是否关闭
     * @zh-Hant 是否關閉
     * @en is closed
     */
    readonly isClosed: boolean;
    /**
     * @zh 时间戳
     * @zh-Hant 時間戳
     * @en timestamp
     */
    readonly timeStamp: number;
}

declare const useBroadcastChannel: UseBroadcastChannel;

/**
 * @title useBoolean
 * @returns_en An object with the following properties:
 * - value: The current boolean value.
 * - setValue: A function to set the boolean value directly.
 * - setTrue: A function to set the value to true.
 * - setFalse: A function to set the value to false.
 * - toggle: A function to toggle the boolean value.
 * @returns 包含以下属性的对象：
 * - value: 当前的布尔值。
 * - setValue: 直接设置布尔值的函数。
 * - setTrue: 将值设置为 true 的函数。
 * - setFalse: 将值设置为 false 的函数。
 * - toggle: 切换布尔值的函数。
 * @returns_zh-Hant 包含以下屬性的物件：
 * - value: 當前的布林值。
 * - setValue: 直接設定布林值的函數。
 * - setTrue: 將值設定為 true 的函數。
 * - setFalse: 將值設定為 false 的函數。
 * - toggle: 切換布林值的函數。
 */
type UseBoolean = (
/**
 * @zh 初始值，默认为 false
 * @zh-Hant 初始值，預設為 false
 * @en The initial boolean value. Defaults to false.
 */
initialValue?: boolean) => {
    readonly value: boolean;
    readonly setValue: (value: boolean) => void;
    readonly setTrue: () => void;
    readonly setFalse: () => void;
    readonly toggle: () => void;
};

declare const useBoolean: UseBoolean;

/**
 * @title UseDevicePixelRatio
 */
type UseDevicePixelRatio = () => UseDevicePixelRatioReturn;
/**
 * @title UseDevicePixelRatioReturn
 */
interface UseDevicePixelRatioReturn {
    /**
     * @zh 像素比率
     * @zh-Hant 像素比率
     * @en Pixel ratio
     */
    pixelRatio: number;
}

declare const useDevicePixelRatio: UseDevicePixelRatio;

/**
 * @title UseElementByPoint
 */
type UseElementByPoint = <M extends boolean = false>(
/**
 * @en options
 * @zh 配置项
 * @zh-Hant 配置項
 */
options: UseElementByPointOptions<M>) => UseElementByPointReturn<M>;
/**
 * @title UseElementByPointOptions
 */
interface UseElementByPointOptions<M extends boolean = false> {
    /**
     * @en The x coordinate of the point
     * @zh 点的 x 坐标
     */
    x: number | (() => number);
    /**
     * @en The y coordinate of the point
     * @zh 点的 y 坐标
     */
    y: number | (() => number);
    /**
     * @en The document to query
     * @zh 要查询的文档
     */
    document?: Document | null;
    /**
     * @en Whether to query multiple elements
     * @zh 是否查询多个元素
     */
    multiple?: M;
    /**
     * @en The interval to query the element
     * @zh 查询元素的间隔
     */
    interval?: number | 'requestAnimationFrame';
    /**
     * @en Whether to query the element immediately
     * @zh 是否立即查询元素
     */
    immediate?: boolean;
}
/**
 * @title UseElementByPointReturn
 */
interface UseElementByPointReturn<M extends boolean> extends Pausable$1 {
    /**
     * @en Whether the feature is supported
     * @zh 功能是否支持
     */
    isSupported: boolean;
    /**
     * @en The queried element
     * @zh 查询到的元素
     */
    element: M extends true ? Element[] : Element | null;
}

declare const useElementByPoint: UseElementByPoint;

/**
 * @title UseFetchEventSourceStatus
 * @description Connection status of EventSource
 */
type UseFetchEventSourceStatus = 'CONNECTING' | 'CONNECTED' | 'DISCONNECTED';
/**
 * @title UseFetchEventSourceAutoReconnectOptions
 */
interface UseFetchEventSourceAutoReconnectOptions {
    /**
     * @en The number of retries, if it is a function, it will be called to determine whether to retry
     * @zh 重试次数，如果是函数，会调用来判断是否重试
     * @zh-Hant 重試次數，如果是函數，會調用來判斷是否重試
     */
    retries?: number | (() => boolean);
    /**
     * @en The delay time before reconnecting (ms)
     * @zh 重连前的延迟时间（毫秒）
     * @zh-Hant 重連前的延遲時間（毫秒）
     */
    delay?: number;
    /**
     * @en Callback when reconnection fails
     * @zh 重连失败时的回调
     * @zh-Hant 重連失敗時的回調
     */
    onFailed?: () => void;
}
/**
 * @title UseFetchEventSourceOptions
 */
interface UseFetchEventSourceOptions extends Omit<FetchEventSourceInit, 'signal'> {
    /**
     * @en HTTP method for the request
     * @zh HTTP 请求方法
     */
    method?: string;
    /**
     * @en Request headers
     * @zh 请求头
     */
    headers?: Record<string, string>;
    /**
     * @en Request body for POST requests
     * @zh POST 请求的请求体
     */
    body?: any;
    /**
     * @en Use credentials
     * @zh 使用凭证
     */
    withCredentials?: boolean;
    /**
     * @en Immediately open the connection, enabled by default
     * @zh 立即打开连接，默认打开
     */
    immediate?: boolean;
    /**
     * @en Automatically reconnect when the connection is disconnected
     * @zh 连接断开时自动重连
     */
    autoReconnect?: UseFetchEventSourceAutoReconnectOptions;
    /**
     * @en Callback when connection opens
     * @zh 连接打开时的回调
     */
    onOpen?: () => void;
    /**
     * @en Callback when message received
     * @zh 接收到消息时的回调
     */
    onMessage?: (event: UseFetchEventSourceMessage) => void;
    /**
     * @en Callback when error occurs, return number to retry after specified milliseconds
     * @zh 发生错误时的回调，返回数字表示多少毫秒后重试
     */
    onError?: (error: Error) => number | void | null | undefined;
    /**
     * @en Callback when connection closes
     * @zh 连接关闭时的回调
     */
    onClose?: () => void;
}
/**
 * @title UseFetchEventSourceMessage
 */
interface UseFetchEventSourceMessage {
    /**
     * @en The event ID
     * @zh 事件 ID
     */
    id: string | null;
    /**
     * @en The event type
     * @zh 事件类型
     */
    event: string | null;
    /**
     * @en The event data
     * @zh 事件数据
     */
    data: string;
}
/**
 * @title UseFetchEventSourceReturn
 */
interface UseFetchEventSourceReturn {
    /**
     * @en The data received
     * @zh 接收到的数据
     */
    data: string | null;
    /**
     * @en The error occurred
     * @zh 发生的错误
     */
    error: Error | null;
    /**
     * @en The status of the connection
     * @zh 连接的状态
     */
    status: UseFetchEventSourceStatus;
    /**
     * @en The last event ID
     * @zh 最后的事件 ID
     */
    lastEventId: string | null;
    /**
     * @en The event name
     * @zh 事件名
     */
    event: string | null;
    /**
     * @en Close the connection
     * @zh 关闭连接
     */
    close: () => void;
    /**
     * @en Open the connection
     * @zh 打开连接
     */
    open: () => void;
}
/**
 * @title UseFetchEventSource
 */
type UseFetchEventSource = (
/**
 * @en The URL of the server-sent event
 * @zh 服务器发送事件的 URL
 */
url: string | URL, 
/**
 * @en EventSource options
 * @zh EventSource 选项
 */
options?: UseFetchEventSourceOptions) => UseFetchEventSourceReturn;

declare const useFetchEventSource: UseFetchEventSource;

/**
 * @title useMap
 * @returns_en An object with the following properties:
 * - map: The current Map instance.
 * - set: A function to set a key-value pair in the map.
 * - get: A function to get a value by key from the map.
 * - remove: A function to remove a key from the map and return whether it existed.
 * - has: A function to check if a key exists in the map.
 * - clear: A function to clear all entries from the map.
 * - reset: A function to reset the map to its initial state.
 * - size: The current size of the map.
 * @returns 包含以下属性的对象：
 * - map: 当前的 Map 实例。
 * - set: 在 map 中设置键值对的函数。
 * - get: 通过键从 map 中获取值的函数。
 * @returns_zh-Hant 包含以下屬性的對象：
 * - map: 當前的 Map 實例。
 * - set: 在 map 中設定鍵值對的函數。
 * - get: 通過鍵從 map 中獲取值的函數。
 * - remove: 從 map 中刪除鍵並返回是否存在的函數。
 * - has: 檢查鍵是否存在於 map 中的函數。
 * - clear: 清除 map 中所有條目的函數。
 * - reset: 將 map 重置為其初始狀態的函數。
 * - size: map 的當前大小。
 */
type UseMap = <K = any, V = any>(
/**
 * @zh 初始值，可以为 Map 实例、数组或者一个初始化的函数
 * @zh-Hant 初始值，可以為 Map 實例、數組或者一個初始化的函數
 * @en The initial value of the map. It can be a Map instance, an array of key-value pairs, or a function that returns initial entries.
 */
initialValue?: Map<K, V> | readonly (readonly [K, V])[] | (() => Map<K, V> | readonly (readonly [K, V])[])) => {
    readonly map: Map<K, V>;
    readonly set: (key: K, value: V) => void;
    readonly get: (key: K) => V | undefined;
    readonly remove: (key: K) => boolean;
    readonly has: (key: K) => boolean;
    readonly clear: () => void;
    readonly reset: () => void;
    readonly size: number;
};

declare const useMap: UseMap;

/**
 * @title UseColorModeOptions
 */
interface UseColorModeOptions<T extends string = string> {
    /**
     * @en CSS Selector for the target element applying to
     * @zh 适用于目标元素的 CSS 选择器
     * @zh-Hant 適用於目標元素的 CSS 選擇器
     * @defaultValue 'html'
     */
    selector?: string;
    /**
     * @en HTML attribute applying the target element
     * @zh 应用到目标元素的 html 属性
     * @zh-Hant 應用到目標元素的 html 屬性
     * @defaultValue 'class'
     */
    attribute?: string;
    /**
     * @en Available color modes
     * @zh 可用的颜色模式
     * @zh-Hant 可用的顏色模式
     */
    modes: T[];
    /**
     * @en Default color mode
     * @zh 默认颜色模式
     * @zh-Hant 預設顏色模式
     */
    defaultValue?: T;
    /**
     * @en Key to persist the data into localStorage/sessionStorage.
     * @zh 将数据持久保存到 localStorage/sessionStorage 的键值
     * @zh-Hant 將資料持久保存到 localStorage/sessionStorage 的鍵值
     * @defaultValue 'reactuses-color-mode'
     */
    storageKey?: string;
    /**
     * @en Storage object, can be localStorage or sessionStorage
     * @zh 存储对象，可以是localStorage或sessionStorage
     * @zh-Hant 儲存對象，可以是localStorage或sessionStorage
     * @defaultValue `localStorage`
     */
    storage?: () => Storage | undefined;
    /**
     * @en Function to get initial color mode from system preference
     * @zh 从系统偏好获取初始颜色模式的函数
     * @zh-Hant 從系統偏好獲取初始顏色模式的函數
     */
    initialValueDetector?: () => T;
    /**
     * @en Mapping of color modes to their corresponding class names or attribute values
     * @zh 颜色模式到对应类名或属性值的映射
     * @zh-Hant 顏色模式到對應類名或屬性值的映射
     */
    modeClassNames?: Partial<Record<T, string>>;
}
/**
 * @title useColorMode
 * @returns_en A tuple with the following elements:
 * - The current color mode value.
 * - A function to set the color mode.
 * - A function to cycle through available modes.
 * @returns 包含以下元素的元组：
 * - 当前颜色模式值。
 * - 设置颜色模式的函数。
 * - 循环切换可用模式的函数。
 * @returns_zh-Hant 包含以下元素的元組：
 * - 當前顏色模式值。
 * - 設定顏色模式的函數。
 * - 循環切換可用模式的函數。
 */
type UseColorMode<T extends string = string> = (options: UseColorModeOptions<T>) => readonly [
    T | null,
    React.Dispatch<React.SetStateAction<T | null>>,
    () => void
];

declare const useColorMode: UseColorMode;

interface SpeechRecognitionErrorEvent extends Event {
    readonly error: string;
    readonly message: string;
}
interface SpeechRecognitionEvent extends Event {
    readonly resultIndex: number;
    readonly results: SpeechRecognitionResultList;
}
interface SpeechRecognitionResult {
    readonly isFinal: boolean;
    readonly length: number;
    item: (index: number) => SpeechRecognitionAlternative;
    [index: number]: SpeechRecognitionAlternative;
}
interface SpeechRecognitionAlternative {
    readonly transcript: string;
    readonly confidence: number;
}
interface SpeechRecognitionResultList {
    readonly length: number;
    item: (index: number) => SpeechRecognitionResult;
    [index: number]: SpeechRecognitionResult;
}
interface SpeechRecognition extends EventTarget {
    continuous: boolean;
    grammars: any;
    interimResults: boolean;
    lang: string;
    maxAlternatives: number;
    serviceURI: string;
    onaudioend: ((this: SpeechRecognition, ev: Event) => any) | null;
    onaudiostart: ((this: SpeechRecognition, ev: Event) => any) | null;
    onend: ((this: SpeechRecognition, ev: Event) => any) | null;
    onerror: ((this: SpeechRecognition, ev: SpeechRecognitionErrorEvent) => any) | null;
    onnomatch: ((this: SpeechRecognition, ev: SpeechRecognitionEvent) => any) | null;
    onresult: ((this: SpeechRecognition, ev: SpeechRecognitionEvent) => any) | null;
    onsoundend: ((this: SpeechRecognition, ev: Event) => any) | null;
    onsoundstart: ((this: SpeechRecognition, ev: Event) => any) | null;
    onspeechend: ((this: SpeechRecognition, ev: Event) => any) | null;
    onspeechstart: ((this: SpeechRecognition, ev: Event) => any) | null;
    onstart: ((this: SpeechRecognition, ev: Event) => any) | null;
    abort: () => void;
    start: () => void;
    stop: () => void;
}
declare global {
    interface Window {
        SpeechRecognition?: new () => SpeechRecognition;
        webkitSpeechRecognition?: new () => SpeechRecognition;
    }
}

/**
 * @title UseSpeechRecognitionOptions
 */
interface UseSpeechRecognitionOptions {
    /**
     * Controls whether continuous results are returned for each recognition, or only a single result.
     *
     * @zh 控制是否为每次识别返回连续结果，或仅返回单个结果
     * @zh-Hant 控制是否為每次識別返回連續結果，或僅返回單個結果
     * @en Controls whether continuous results are returned for each recognition, or only a single result
     * @default true
     */
    continuous?: boolean;
    /**
     * Controls whether interim results should be returned (true) or not (false.) Interim results are results that are not yet final
     *
     * @zh 控制是否应返回临时结果（true）或不返回（false）。临时结果是尚未最终确定的结果
     * @zh-Hant 控制是否應返回臨時結果（true）或不返回（false）。臨時結果是尚未最終確定的結果
     * @en Controls whether interim results should be returned (true) or not (false.) Interim results are results that are not yet final
     * @default true
     */
    interimResults?: boolean;
    /**
     * Language for SpeechRecognition
     *
     * @zh 语音识别的语言
     * @zh-Hant 語音識別的語言
     * @en Language for SpeechRecognition
     * @default 'en-US'
     */
    lang?: string;
    /**
     * A number representing the maximum returned alternatives for each result.
     *
     * @zh 表示每个结果返回的最大备选项数量的数字
     * @zh-Hant 表示每個結果返回的最大備選項數量的數字
     * @en A number representing the maximum returned alternatives for each result
     * @see https://developer.mozilla.org/en-US/docs/Web/API/SpeechRecognition/maxAlternatives
     * @default 1
     */
    maxAlternatives?: number;
}
/**
 * @title useSpeechRecognition
 * @returns 包含以下元素的对象：
 * - 是否支持语音识别。
 * - 是否正在监听。
 * - 识别结果是否为最终结果。
 * - SpeechRecognition 实例。
 * - 识别结果文本。
 * - 错误信息。
 * - 切换监听状态的函数。
 * - 开始监听的函数。
 * - 停止监听的函数。
 * @returns_en A object with the following elements:
 * - Whether speech recognition is supported.
 * - Whether currently listening.
 * - Whether the recognition result is final.
 * - SpeechRecognition instance.
 * - Recognition result text.
 * - Error information.
 * - Function to toggle listening state.
 * - Function to start listening.
 * - Function to stop listening.
 * @returns_zh-Hant 包含以下元素的對象：
 * - 是否支持語音識別。
 * - 是否正在監聽。
 * - 識別結果是否為最終結果。
 * - SpeechRecognition 實例。
 * - 識別結果文本。
 * - 錯誤信息。
 * - 切換監聽狀態的函數。
 * - 開始監聽的函數。
 * - 停止監聽的函數。
 */
type UseSpeechRecognition = (
/**
 * @zh 可选的语音识别配置参数
 * @zh-Hant 可選的語音識別配置參數
 * @en Optional speech recognition configuration options
 */
options?: UseSpeechRecognitionOptions) => {
    /**
     * @zh 浏览器是否支持语音识别
     * @zh-Hant 瀏覽器是否支持語音識別
     * @en Whether the browser supports speech recognition
     */
    readonly isSupported: boolean;
    /**
     * @zh 是否正在监听
     * @zh-Hant 是否正在監聽
     * @en Whether currently listening
     */
    readonly isListening: boolean;
    /**
     * @zh 识别结果是否为最终结果
     * @zh-Hant 識別結果是否為最終結果
     * @en Whether the recognition result is final
     */
    readonly isFinal: boolean;
    /**
     * @zh SpeechRecognition 实例
     * @zh-Hant SpeechRecognition 實例
     * @en SpeechRecognition instance
     */
    readonly recognition: SpeechRecognition | undefined;
    /**
     * @zh 识别结果文本
     * @zh-Hant 識別結果文本
     * @en Recognition result text
     */
    readonly result: string;
    /**
     * @zh 错误信息
     * @zh-Hant 錯誤信息
     * @en Error information
     */
    readonly error: SpeechRecognitionErrorEvent | undefined;
    /**
     * @zh 切换监听状态
     * @zh-Hant 切換監聽狀態
     * @en Toggle listening state
     */
    readonly toggle: (value?: boolean, startOptions?: Partial<UseSpeechRecognitionOptions>) => void;
    /**
     * @zh 开始监听
     * @zh-Hant 開始監聽
     * @en Start listening
     */
    readonly start: (startOptions?: Partial<UseSpeechRecognitionOptions>) => void;
    /**
     * @zh 停止监听
     * @zh-Hant 停止監聽
     * @en Stop listening
     */
    readonly stop: () => void;
};
type UseSpeechRecognitionReturn = ReturnType<UseSpeechRecognition>;

declare const useSpeechRecognition: UseSpeechRecognition;

/**
 * @title useDocumentVisiblity
 * @returns_en document visibility
 * @returns 文档可见性
 * @returns_zh-Hant 文檔可見性
 */
type UseDocumentVisibility = (
/**
 * @zh 默认值
 * @zh-Hant 預設值
 * @en default value
 */
defaultValue?: DocumentVisibilityState) => DocumentVisibilityState;

/**
 * @title useEventListener
 */
type UseEventListener = (
/**
 * @zh 事件名称
 * @zh-Hant 事件名稱
 * @en event name
 */
eventName: string, 
/**
 * @zh 事件处理器
 * @zh-Hant 事件處理器
 * @en event handler
 */
handler: (event: any) => void, 
/**
 * @zh dom元素
 * @en dom element
 * @defaultValue `window`
 */
element?: HTMLElement | Element | Window | Document | EventTarget | null | undefined, 
/**
 * @zh 监听选项
 * @en listener options
 */
options?: boolean | AddEventListenerOptions | undefined) => void;

/**
 * @title useFavicon
 */
type UseFavicon = (
/**
 * @zh 图标路径
 * @zh-Hant 圖標路徑
 * @en icon href
 */
href: string, 
/**
 * @zh 基础 url
 * @zh-Hant 基礎 url
 * @en base url
 */
baseUrl?: string, 
/**
 * @zh 设置 link 标签的 rel 属性
 * @zh-Hant 設定 link 標籤的 rel 屬性
 * @en set rel attribute to link element
 * @defaultValue icon
 */
rel?: string) => void;

/**
 * @title useLocalStorage
 * @returns 包含以下元素的元组：
 * - localStorage 的当前值。
 * - 更新 localStorage 值的函数。
 * @returns_en A tuple with the following elements:
 * - The current value of the localStorage.
 * - A function to update the value of the localStorage.
 * @returns_zh-Hant 包含以下元素的元組：
 * - localStorage 的當前值。
 * - 更新 localStorage 值的函數。
 */
type UseLocalStorage = <T extends string | number | boolean | object | null>(
/**
 * @zh 键值
 * @zh-Hant 鍵值
 * @en key
 */
key: string, 
/**
 * @zh 默认值
 * @zh-Hant 預設值
 * @en default value
 */
defaultValue?: T, 
/**
 * @zh 可选参数
 * @zh-Hant 可選參數
 * @en optional params
 */
options?: UseLocalStorageOptions<T>) => readonly [T | null, Dispatch<SetStateAction<T | null>>];
/**
 * @title UseLocalStorageOptions
 */
interface UseLocalStorageOptions<T> {
    /**
     * @en Custom data serialization
     * @zh 自定义数据序列化
     * @zh-Hant 自訂資料序列化
     */
    serializer?: UseLocalStorageSerializer<T>;
    /**
     * @en On error callback
     * @zh 错误回调
     * @zh-Hant 錯誤回呼
     * @defaultValue `console.error`
     */
    onError?: (error: unknown) => void;
    /**
     * @en set to storage when nodata in first mount, deprecated
     * @zh 首次挂载时没有数据时设置到 storage, 已弃用
     * @zh-Hant 首次掛載時沒有資料時設定到 storage，已棄用
     * @deprecated
     */
    effectStorageValue?: T | (() => T);
    /**
     * @en set to storage when nodata in first mount
     * @zh 首次挂载时没有数据时设置到 storage
     * @zh-Hant 首次掛載時沒有資料時設定到 storage
     */
    mountStorageValue?: T | (() => T);
    /**
     * @en listen to storage changes
     * @zh 监听 storage 变化
     * @zh-Hant 監聽 storage 變化
     * @defaultValue `true`
     */
    listenToStorageChanges?: boolean;
}
/**
 * @title UseLocalStorageSerializer
 */
interface UseLocalStorageSerializer<T> {
    /**
     * @en Custom data read
     * @zh 自定义数据读取
     * @zh-Hant 自訂資料讀取
     */
    read: (raw: string) => T;
    /**
     * @en Custom data write
     * @zh 自定义数据写入
     * @zh-Hant 自訂資料寫入
     */
    write: (value: T) => string;
}

/**
 * @title useMountedState
 * @returns 组件的挂载状态
 * @returns_en component mounted state
 * @returns_zh-Hant 組件的挂載狀態
 */
type UseMountedState = () => () => boolean;

/**
 * @title usePageLeave
 * @returns 鼠标是否离开页面
 * @returns_en whether the mouse leave page
 * @returns_zh-Hant 滑鼠是否離開頁面
 */
type UsePageLeave = () => boolean;

/**
 * @title usePreferredDark
 * @returns 是否偏好黑色
 * @returns_en whether prefer dark
 * @returns_zh-Hant 是否偏好黑色
 */
type UsePreferredDark = (
/**
 * @zh 默认值
 * @zh-Hant 預設值
 * @en defaule value
 */
defaultState?: boolean) => boolean;

/**
 * @title usePrevious
 * @returns 更新前的值
 * @returns_en previous value
 * @returns_zh-Hant 更新前的值
 */
type UsePrevious = <T>(
/**
 * @zh 状态值
 * @zh-Hant 狀態值
 * @en state value
 */
state: T) => T | undefined;

/**
 * @title useRafState
 * @returns 包含以下元素的元组：
 * - state 的当前值。
 * - 在 `requestAnimationFrame` 中更新 state 值的函数。
 * @returns_en A tuple with the following elements:
 * - the state value
 * - a function to update state in `requestAnimationFrame`
 * @returns_zh-Hant 包含以下元素的元組：
 * - state 的當前值。
 * - 在 `requestAnimationFrame` 中更新 state 值的函數。
 */
type UseRafState = <S>(
/**
 * @zh 状态值
 * @zh-Hant 狀態值
 * @en state value
 */
initialState: S | (() => S)) => readonly [S, Dispatch<SetStateAction<S>>];

/**
 * @title useReducedMotion
 * @returns 是否偏好减少动画
 * @returns_en whether prefer reduced motion
 * @returns_zh-Hant 是否偏好減少動畫
 */
type UseReducedMotion = (
/**
 * @zh 默认值
 * @zh-Hant 預設值
 * @en default value
 */
defaultState?: boolean) => boolean;

/**
 * @title useScreenSafeArea
 * @returns 包含以下元素的元组：
 * - 顶部安全距离。
 * - 右边安全距离。
 * - 底部安全距离。
 * - 左边安全距离，
 * - 手动更新函数
 * @returns_en A tuple with the following elements:
 * - top safe distance
 * - right safe distance
 * - bottom safe distance
 * - left safe distance
 * @returns_zh-Hant 包含以下元素的元組：
 * - 頂部安全距離。
 * - 右邊安全距離。
 * - 底部安全距離。
 * - 左邊安全距離，
 * - 手動更新函數
 * - munual update function
 */
type UseScreenSafeArea = () => readonly [string, string, string, string, DebouncedFunc$1<() => void>];

/**
 * @title useSessionStorage
 * @returns 包含以下元素的元组：
 * - sessionStorage 的当前值。
 * - 更新 sessionStorage 值的函数。
 * @returns_en A tuple with the following elements:
 * - The current value of the sessionStorage.
 * - A function to update the value of the sessionStorage.
 * @returns_zh-Hant 包含以下元素的元組：
 * - sessionStorage 的當前值。
 * - 更新 sessionStorage 值的函數。
 */
type UseSessionStorage = <T extends string | number | boolean | object | null>(
/**
 * @zh 键值
 * @zh-Hant 鍵值
 * @en key
 */
key: string, 
/**
 * @zh 默认值
 * @zh-Hant 預設值
 * @en default value
 */
defaultValue?: T, 
/**
 * @zh 可选参数
 * @zh-Hant 可選參數
 * @en optional params
 */
options?: UseSessionStorageOptions<T>) => readonly [T | null, Dispatch<SetStateAction<T | null>>];
/**
 * @title UseSessionStorageOptions
 */
interface UseSessionStorageOptions<T> {
    /**
     * @en Custom data serialization
     * @zh 自定义数据序列化
     * @zh-Hant 自定義數據序列化
     */
    serializer?: UseSessionStorageSerializer<T>;
    /**
     * @en On error callback
     * @zh 错误回调
     * @zh-Hant 錯誤回調
     * @defaultValue `console.error`
     */
    onError?: (error: unknown) => void;
    /**
     * @en set to storage when nodata in first mount, deprecated
     * @zh 首次挂载时没有数据时设置到 storage, 已弃用
     * @zh-Hant 首次掛載時沒有數據時設置到 storage, 已棄用
     * @deprecated
     */
    effectStorageValue?: T | (() => T);
    /**
     * @en set to storage when nodata in first mount
     * @zh 首次挂载时没有数据时设置到 storage
     * @zh-Hant 首次掛載時沒有數據時設置到 storage
     */
    mountStorageValue?: T | (() => T);
    /**
     * @en listen to storage changes
     * @zh 监听 storage 变化
     * @zh-Hant 監聽 storage 變化
     * @defaultValue `true`
     */
    listenToStorageChanges?: boolean;
}
/**
 * @title UseSessionStorageSerializer
 */
interface UseSessionStorageSerializer<T> {
    /**
     * @en Custom data read
     * @zh 自定义数据读取
     * @zh-Hant 自定義數據讀取
     */
    read: (raw: string) => T;
    /**
     * @en Custom data write
     * @zh 自定义数据写入
     * @zh-Hant 自定義數據寫入
     */
    write: (value: T) => string;
}

/**
 * @title useSupported
 * @returns 浏览器是否支持
 * @returns_en whether the browser support
 * @returns_zh-Hant 瀏覽器是否支援
 */
type UseSupported = (
/**
 * @zh 测试回调
 * @zh-Hant 測試回調
 * @en test callback
 */
callback: () => unknown, 
/**
 * @zh 使用 useLayoutEffect来进行测试
 * @zh-Hant 使用 useLayoutEffect來進行測試
 * @en use useLayoutEffect to test
 * @defaultValue false
 */
sync?: boolean) => boolean;

/**
 * @title useThrottleFn
 * @returns_en A object with the following elements:
 * - run: exec function.
 * - cancel: cancel exec function.
 * - flush:  immediately exec function
 * @returns 具有以下元素的对象:
 * - run：执行函数。
 * - cancel：取消执行函数。
 * - flush: 立即执行函数
 * @returns_zh-Hant 具有以下元素的對象:
 * - run：執行函數。
 * - cancel：取消執行函數。
 * - flush: 立即執行函數
 */
type UseThrottleFn = <T extends (...args: any) => any>(
/**
 * @zh 要节流的函数
 * @zh-Hant 要節流的函數
 * @en Throttle function
 */
fn: T, 
/**
 * @zh 间隔时间
 * @zh-Hant 間隔時間
 * @en wait time
 */
wait?: number, 
/**
 * @zh 传递给 `lodash.throttle` 的属性
 * @zh-Hant 傳遞給 `lodash.throttle` 的屬性
 * @en options passed to `lodash.throttle`
 */
options?: ThrottleSettings$1) => {
    run: DebouncedFunc<(...args_0: Parameters<T>) => ReturnType<T>>;
    cancel: () => void;
    flush: any;
};

/**
 * @title useUnmount
 */
type UseUnmount = (
/**
 * @zh 清理函数
 * @zh-Hant 清理函數
 * @en clear function
 */
fn: () => void) => void;

/**
 * @title useUpdate
 * @returns 强制更新函数
 * @returns_en rerender trigger function
 * @returns_zh-Hant 強制更新函數
 */
type UseUpdate = () => () => void;

/**
 * @title useWindowsFocus
 * @returns 窗口是否聚焦
 * @returns_en whether window focus
 * @returns_zh-Hant 窗口是否聚焦
 */
type UseWindowsFocus = (
/**
 * @zh 默认值
 * @zh-Hant 預設值
 * @en defauleValue
 */
defauleValue?: boolean) => boolean;

/**
 * @title useMobileLandscape
 * @returns 是否是移动端横屏
 * @returns_en whether is mobile landscape
 * @returns_zh-Hant 是否是行動端橫屏
 */
type UseMobileLandscape = () => boolean;

interface ThenableImpl<T> {
    then: (onFulfill: (value: T) => unknown, onReject: (error: unknown) => unknown) => void | PromiseLike<unknown>;
}
interface UntrackedThenable<T> extends ThenableImpl<T> {
    status?: void;
}
interface PendingThenable<T> extends ThenableImpl<T> {
    status: 'pending';
}
interface FulfilledThenable<T> extends ThenableImpl<T> {
    status: 'fulfilled';
    value: T;
}
interface RejectedThenable<T> extends ThenableImpl<T> {
    status: 'rejected';
    reason: unknown;
}
type Thenable<T> = UntrackedThenable<T> | PendingThenable<T> | FulfilledThenable<T> | RejectedThenable<T>;
type Usable<T> = Thenable<T> | Context<T>;
/**
 * @title Use
 * @returns 解析状态值
 * @returns_en resolved state value
 * @returns_zh-Hant 解析狀態值
 */
type Use = <T>(
/**
 * @zh promise 或者 context
 * @zh-Hant promise 或者 context
 * @en promise or context
 */
usable: Usable<T>) => T;

export { assignRef, defaultOptions, mergeRefs, use, useActiveElement, useAsyncEffect, useBoolean, useBroadcastChannel, useClickOutside as useClickAway, useClickOutside, useClipboard, useColorMode, useControlled, useCookie, useClipboard as useCopyToClipboard, useCountDown, useCounter, useCssVar, useCustomCompareEffect, useCycleList, useDarkMode, useDebounce, useDebounceFn, useDeepCompareEffect, useDevicePixelRatio, useDisclosure, useDocumentVisibility, useDoubleClick, useDraggable, useDropZone, useElementBounding, useElementByPoint, useElementSize, useElementVisibility, useEvent, useEventEmitter, useEventListener, useEventSource, useEyeDropper, useFavicon, useFetchEventSource, useFileDialog, useFirstMountState, useFocus, useFps, useFullscreen, useGeolocation, useHover, useIdle, useInfiniteScroll, useIntersectionObserver, useInterval, useIsomorphicLayoutEffect, useKeyModifier, useLatest, useLocalStorage, useLocationSelector, useLongPress, useMap, useMeasure, useMediaDevices, useMediaQuery, useMergedRefs, useMobileLandscape, useMount, useMountedState, useMouse, useMousePressed, useMutationObserver, useNetwork, useObjectUrl, useOnceEffect, useOnceLayoutEffect, useOnline, useOrientation, usePageLeave, usePermission, usePlatform, usePreferredColorScheme, usePreferredContrast, usePreferredDark, usePreferredLanguages, usePrevious, useRafFn, useRafState, useReducedMotion, useResizeObserver, useScratch, useScreenSafeArea, useScriptTag, useScroll, useScrollIntoView, useScrollLock, useSessionStorage, useSetState, useSpeechRecognition, useSticky, useSupported, useTextDirection, useTextSelection, useThrottle, useThrottleFn, useTimeout, useTimeoutFn, useTitle, useToggle, useUnmount, useUpdate, useUpdateEffect, useUpdateLayoutEffect, useWebNotification, useWindowScroll, useWindowSize, useWindowsFocus };
export type { ColorScheme, Contrast, DepsEqualFnType, EventSourceStatus, EventType, INetworkInformation, IUseNetworkState, KeyModifier, Pausable, Platform, PossibleRef, Use, UseActiveElement, UseAsyncEffect, UseBoolean, UseBroadcastChannel, UseBroadcastChannelOptions, UseBroadcastChannelReturn, UseClickOutside, UseClipboard, UseColorMode, UseColorModeOptions, UseControlled, UseCookie, UseCookieState, UseCountDown, UseCounter, UseCssVar, UseCssVarOptions, UseCustomCompareEffect, UseCycleList, UseDarkMode, UseDarkOptions, UseDebounce, UseDebounceFn, UseDeepCompareEffect, UseDevicePixelRatio, UseDevicePixelRatioReturn, UseDisclosure, UseDisclosureProps, UseDocumentVisibility, UseDoubleClick, UseDoubleClickProps, UseDraggable, UseDraggableOptions, UseDropZone, UseElementBounding, UseElementBoundingOptions, UseElementBoundingReturn, UseElementByPoint, UseElementByPointOptions, UseElementByPointReturn, UseElementSize, UseElementVisibility, UseEvent, UseEventEmitter, UseEventEmitterDisposable, UseEventEmitterEvent, UseEventEmitterEventOnce, UseEventEmitterListener, UseEventEmitterReturn, UseEventListener, UseEventSource, UseEventSourceAutoReconnectOptions, UseEventSourceOptions, UseEventSourceReturn, UseEyeDropper, UseEyeDropperOpenOptions, UseEyeDropperOpenReturnType, UseFavicon, UseFetchEventSource, UseFetchEventSourceAutoReconnectOptions, UseFetchEventSourceMessage, UseFetchEventSourceOptions, UseFetchEventSourceReturn, UseFetchEventSourceStatus, UseFileDialog, UseFileDialogOptions, UseFirstMountState, UseFocus, UseFps, UseFpsOptions, UseFullScreenOptions, UseFullscreen, UseGeolocation, UseHover, UseIdle, UseInfiniteScroll, UseInfiniteScrollArrivedState, UseInfiniteScrollDirection, UseInfiniteScrollLoadMore, UseInfiniteScrollOptions, UseIntersectionObserver, UseInterval, UseIntervalOptions, UseKeyModifier, UseLatest, UseLocalStorage, UseLocalStorageOptions, UseLocalStorageSerializer, UseLocationSelector, UseLongPress, UseLongPressOptions, UseMap, UseMeasure, UseMeasureRect, UseMediaDeviceOptions, UseMediaDevices, UseMediaQuery, UseMergedRef, UseMobileLandscape, UseModifierOptions, UseMount, UseMountedState, UseMouse, UseMouseCursorState, UseMousePressed, UseMousePressedOptions, UseMousePressedSourceType, UseMutationObserver, UseNetwork, UseObjectUrl, UseOnline, UseOrientation, UseOrientationLockType, UseOrientationState, UseOrientationType, UsePageLeave, UsePermission, UsePermissionDescriptorNamePolyfill, UsePermissionGeneralPermissionDescriptor, UsePermissionState, UsePlatform, UsePlatformProps, UsePlatformReturn, UsePreferredColorScheme, UsePreferredContrast, UsePreferredDark, UsePreferredLanguages, UsePrevious, UseRafFn, UseRafState, UseReducedMotion, UseResizeObserver, UseScratch, UseScratchOptions, UseScratchState, UseScreenSafeArea, UseScriptTag, UseScriptTagOptions, UseScriptTagStatus, UseScroll, UseScrollArrivedState, UseScrollDirection, UseScrollIntoView, UseScrollIntoViewAnimation, UseScrollIntoViewParams, UseScrollLock, UseScrollOffset, UseScrollOptions, UseSessionStorage, UseSessionStorageOptions, UseSessionStorageSerializer, UseSetState, UseSpeechRecognition, UseSpeechRecognitionOptions, UseSpeechRecognitionReturn, UseSticky, UseStickyParams, UseSupported, UseTextDirection, UseTextDirectionOptions, UseTextDirectionValue, UseTextSelection, UseThrottle, UseThrottleFn, UseTimeout, UseTimeoutFn, UseTimeoutFnOptions, UseTimeoutOptions, UseTitle, UseToggle, UseUnmount, UseUpdate, UseWebNotification, UseWebNotificationReturn, UseWebNotificationShow, UseWindowScroll, UseWindowScrollState, UseWindowSize, UseWindowsFocus };
