#!/usr/bin/env pwsh
$basedir=Split-Path $MyInvocation.MyCommand.Definition -Parent

$exe=""
if ($PSVersionTable.PSVersion -lt "6.0" -or $IsWindows) {
  # Fix case when both the Windows and Linux builds of Node
  # are installed in the same directory
  $exe=".exe"
}
$ret=0
if (Test-Path "$basedir/bun$exe") {
  # Support pipeline input
  if ($MyInvocation.ExpectingInput) {
    $input | & "$basedir/bun$exe"  "$basedir/../z-ai-web-dev-sdk/dist/cli.js" $args
  } else {
    & "$basedir/bun$exe"  "$basedir/../z-ai-web-dev-sdk/dist/cli.js" $args
  }
  $ret=$LASTEXITCODE
} else {
  # Support pipeline input
  if ($MyInvocation.ExpectingInput) {
    $input | & "bun$exe"  "$basedir/../z-ai-web-dev-sdk/dist/cli.js" $args
  } else {
    & "bun$exe"  "$basedir/../z-ai-web-dev-sdk/dist/cli.js" $args
  }
  $ret=$LASTEXITCODE
}
exit $ret
