'use client';

import { useState } from 'react';
import { MessageCircle, X, Send, Minimize2, Maximize2 } from 'lucide-react';

const WhatsAppChatbot = () => {
  const [isOpen, setIsOpen] = useState(false);
  const [isMinimized, setIsMinimized] = useState(false);
  const [message, setMessage] = useState('');

  const phoneNumber = '9779857834143';
  const whatsappUrl = `https://wa.me/${phoneNumber}`;

  const handleSend = () => {
    if (message.trim()) {
      const encodedMessage = encodeURIComponent(message);
      window.open(`${whatsappUrl}?text=${encodedMessage}`, '_blank');
      setMessage('');
    } else {
      window.open(whatsappUrl, '_blank');
    }
  };

  const quickMessages = [
    'I want to know about Busy 21 pricing',
    'I need support for Busy software',
    'I want to download Busy 21',
    'I want a demo of Busy software',
  ];

  return (
    <div className="whatsapp-chatbot">
      {/* Chat Window */}
      <div
        className={`whatsapp-chatbot-window bg-white rounded-2xl shadow-2xl overflow-hidden ${isOpen ? 'open' : ''} ${
          isMinimized ? 'h-14' : 'h-[500px]'
        } flex flex-col`}
      >
        {/* Header */}
        <div className="bg-[#128C7E] text-white p-4 flex items-center justify-between flex-shrink-0">
            <div className="flex items-center gap-3">
              <div className="w-10 h-10 rounded-full bg-white/20 flex items-center justify-center">
                <MessageCircle className="w-6 h-6" />
              </div>
              <div>
                <h3 className="font-semibold">BusyNepal Support</h3>
                <p className="text-xs opacity-80">Online • Typically replies instantly</p>
              </div>
            </div>
            <div className="flex items-center gap-2">
              <button
                onClick={() => setIsMinimized(!isMinimized)}
                className="p-1 hover:bg-white/10 rounded-lg transition-colors"
                aria-label={isMinimized ? 'Maximize' : 'Minimize'}
              >
                {isMinimized ? (
                  <Maximize2 className="w-4 h-4" />
                ) : (
                  <Minimize2 className="w-4 h-4" />
                )}
              </button>
              <button
                onClick={() => setIsOpen(false)}
                className="p-1 hover:bg-white/10 rounded-lg transition-colors"
                aria-label="Close"
              >
                <X className="w-4 h-4" />
              </button>
            </div>
          </div>

          {!isMinimized && (
            <>
              {/* Messages */}
              <div className="flex-1 p-4 overflow-y-auto bg-gray-50 max-h-[340px]">
                <div className="space-y-4">
                  {/* Welcome Message */}
                  <div className="flex gap-3">
                    <div className="w-8 h-8 rounded-full bg-[#128C7E] flex items-center justify-center flex-shrink-0">
                      <MessageCircle className="w-5 h-5 text-white" />
                    </div>
                    <div className="bg-white rounded-lg rounded-tl-none p-3 shadow-sm max-w-[250px]">
                      <p className="text-sm text-gray-800">
                        Namaste! 👋 Welcome to BusyNepal Support. How can I help you today?
                      </p>
                    </div>
                  </div>

                  {/* Quick Messages */}
                  <div className="space-y-2">
                    <p className="text-xs text-gray-500 mb-2">Quick replies:</p>
                    {quickMessages.map((quickMsg, index) => (
                      <button
                        key={index}
                        onClick={() => {
                          setMessage(quickMsg);
                          handleSend();
                        }}
                        className="block w-full text-left bg-white hover:bg-[#128C7E]/10 border border-gray-200 rounded-lg px-3 py-2 text-sm text-gray-700 hover:text-[#128C7E] transition-colors"
                      >
                        {quickMsg}
                      </button>
                    ))}
                  </div>
                </div>
              </div>

              {/* Input */}
              <div className="p-4 bg-white border-t border-gray-200">
                <div className="flex items-center gap-2">
                  <input
                    type="text"
                    value={message}
                    onChange={(e) => setMessage(e.target.value)}
                    placeholder="Type a message..."
                    className="flex-1 px-4 py-2 border border-gray-300 rounded-full text-sm focus:outline-none focus:border-[#128C7E] focus:ring-2 focus:ring-[#128C7E]/10 transition-all"
                    onKeyPress={(e) => {
                      if (e.key === 'Enter') {
                        handleSend();
                      }
                    }}
                  />
                  <button
                    onClick={handleSend}
                    className="p-2 bg-[#128C7E] hover:bg-[#075E54] text-white rounded-full transition-colors"
                    aria-label="Send message"
                  >
                    <Send className="w-5 h-5" />
                  </button>
                </div>
              </div>
            </>
          )}
        </div>

      {/* Floating Button */}
      <button
        onClick={() => setIsOpen(!isOpen)}
        className="whatsapp-chatbot-button flex items-center justify-center shadow-lg hover:shadow-xl transform hover:scale-110 transition-all duration-300"
        aria-label={isOpen ? 'Close WhatsApp chat' : 'Open WhatsApp chat'}
      >
        {isOpen ? <X className="w-8 h-8" /> : <MessageCircle className="w-8 h-8" />}
      </button>
    </div>
  );
};

export default WhatsAppChatbot;
