export function SchemaMarkup() {
  const organizationSchema = {
    "@context": "https://schema.org",
    "@type": "Organization",
    "name": "Neha Infotech - BusyNepal",
    "url": "https://busynepal.com",
    "logo": "https://busynepal.com/logo.png",
    "description": "Authorized Busy Accounting Software Distributor in Nepal",
    "sameAs": [
      "https://www.facebook.com/profile.php?id=61574548711911",
      "https://youtube.com/@busynepal",
      "https://linkedin.com/company/busynepal",
      "https://instagram.com/nehainfotechh"
    ],
    "contactPoint": {
      "@type": "ContactPoint",
      "telephone": "+977-9857834143",
      "contactType": "Customer Service",
      "email": "info@busynepal.com"
    },
    "address": [
      {
        "@type": "PostalAddress",
        "streetAddress": "Nepalgunj-18",
        "addressLocality": "Banke",
        "addressCountry": "NP",
        "name": "Head-Office"
      },
      {
        "@type": "PostalAddress",
        "streetAddress": "Ghorahi-15",
        "addressLocality": "Dang",
        "addressCountry": "NP",
        "name": "Branch-Office"
      }
    ]
  };

  const localBusinessSchema = {
    "@context": "https://schema.org",
    "@type": "LocalBusiness",
    "name": "Neha Infotech",
    "image": "https://busynepal.com/logo.png",
    "description": "Authorized Busy Accounting Software Distributor in Nepal",
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "Nepalgunj-18, Banke",
      "addressLocality": "Banke",
      "addressRegion": "Banke",
      "addressCountry": "NP"
    },
    "telephone": "+977-9857834143",
    "url": "https://busynepal.com",
    "priceRange": "$$"
  };

  return (
    <>
      <script
        type="application/ld+json"
        dangerouslySetInnerHTML={{
          __html: JSON.stringify(organizationSchema),
        }}
      />
      <script
        type="application/ld+json"
        dangerouslySetInnerHTML={{
          __html: JSON.stringify(localBusinessSchema),
        }}
      />
    </>
  );
}
