'use client';

import Link from 'next/link';
import { Phone, Mail, MapPin, Facebook, Youtube, Linkedin, Instagram } from 'lucide-react';
import { EmailLink, PhoneLink } from './protected-contact';

const Footer = () => {
  const currentYear = new Date().getFullYear();

  const pageLinks = [
    { name: 'Home', href: '/' },
    { name: 'Services', href: '/services' },
    { name: 'Blog', href: '/blog' },
    { name: 'About', href: '/about' },
    { name: 'Downloads', href: '/downloads' },
    { name: 'Contact', href: '/contact' },
  ];
  const usefulLinks = [
    { name: 'Privacy Policy', href: '/privacy-policy' },
    { name: 'Terms & Conditions', href: '/terms' },
    { name: 'Refund Policy', href: '/refund-policy' },
    { name: 'Testimonials', href: '/testimonials' },
    { name: 'FAQ', href: '/faq' },
  ];

  const contactInfo = [
    {
      icon: <MapPin className="w-4 h-4" />,
      text: 'Head-Office: Nepalgunj-18,Banke, Nepal',
  
    },
    {
      icon: <MapPin className="w-4 h-4" />,
      text: 'Branch-Office: Ghorahi-15,Dang, Nepal',
    },
    {
      icon: <Phone className="w-4 h-4" />,
      text: '+977-9857834143',
    },
    {
      icon: <Phone className="w-4 h-4" />,
      text: '+977-9840632000',
    },
    {
      icon: <Phone className="w-4 h-4" />,
      text: '+977-9809750131',
    },
    {
      icon: <Mail className="w-4 h-4" />,
      text: 'email',
      isEmail: true,
      emailAddress: 'info@busynepal.com',
    },
  ];

  return (
    <footer className="bg-[#002d55] text-white">
      {/* Main Footer Content */}
      <div className="py-12">
        <div className="container-custom">
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            {/* Company Info */}
            <div>
              <div className="mb-4">
                <div className="flex items-center gap-3 mb-4">
                  <img
                    src="/logo.png"
                    alt="BusyNepal Logo"
                    className="w-12 h-auto rounded-lg"
                  />
                  <div>
                    <h3 className="text-lg font-bold">Neha Infotech</h3>
                    <p className="text-xs text-gray-300">Busy Authorized Channel Partner in Nepal</p>
                  </div>
                </div>
              </div>
              <p className="text-sm text-gray-300 mb-6 leading-relaxed">
                Authorized Busy Accounting Software Distributor in Nepal. We provide comprehensive
                accounting solutions for businesses of all sizes, helping you manage your
                finances efficiently and effectively.
              </p>
              {/* Social Links */}
              <div className="flex items-center gap-4">
                <a
                  href="https://www.facebook.com/profile.php?id=61574548711911"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-colors"
                  aria-label="Facebook"
                >
                  <Facebook className="w-5 h-5" />
                </a>
                <a
                  href="https://youtube.com/@techhbijay"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-colors"
                  aria-label="YouTube"
                >
                  <Youtube className="w-5 h-5" />
                </a>
                <a
                  href="https://www.linkedin.com/in/busy-software-nepal-8419453a8/"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-colors"
                  aria-label="LinkedIn"
                >
                  <Linkedin className="w-5 h-5" />
                </a>
                <a
                  href="https://instagram.com/nehainfotechh"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-colors"
                  aria-label="Instagram"
                >
                  <Instagram className="w-5 h-5" />
                </a>
              </div>
            </div>

            {/* Page Links */}
            <div>
              <h4 className="text-lg font-bold mb-6">Quick Links</h4>
              <ul className="space-y-3">
                {pageLinks.map((link) => (
                  <li key={link.name}>
                    <Link
                      href={link.href}
                      className="text-sm text-gray-300 hover:text-white transition-colors"
                    >
                      {link.name}
                    </Link>
                  </li>
                ))}
              </ul>
            </div>
            {/* Useful Links */}
            <div>
              <h4 className="text-lg font-bold mb-6">Useful Links</h4>
              <ul className="space-y-3">
                {usefulLinks.map((link) => (
                  <li key={link.name}>
                    <Link
                      href={link.href}
                      className="text-sm text-gray-300 hover:text-white transition-colors"
                    >
                      {link.name}
                    </Link>
                  </li>
                ))}
              </ul>
            </div>

            {/* Contact Info */}
            <div>
              <h4 className="text-lg font-bold mb-6">Contact Us</h4>
              <div className="space-y-4">
                {contactInfo.map((info: any, index) => (
                  <div key={index} className="flex items-start gap-3">
                    <span className="text-[#005a9f] mt-0.5">{info.icon}</span>
                    {info.isEmail ? (
                      <EmailLink address={info.emailAddress} label="Contact via Email" className="text-sm text-gray-300 hover:text-white transition-colors" />
                    ) : (
                      <span className="text-sm text-gray-300">{info.text}</span>
                    )}
                  </div>
                ))}
              </div>
              <div className="mt-6 pt-6 border-t border-white/10">
                <p className="text-xs text-gray-400">
                  Get support on WhatsApp
                </p>
                <a
                  href="https://wa.me/9771234567890"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="inline-block mt-2 text-sm text-[#25D366] hover:underline"
                >
                  Chat with us
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>

      {/* Copyright Bar */}
      <div className="bg-[#001f3d] py-4">
        <div className="container-custom">
          <div className="flex flex-col md:flex-row items-center justify-between gap-4">
            <p className="text-sm text-gray-400">
              © {currentYear} Neha Infotech - BusyNepal. All rights reserved. | Developed by-{' '}
              <a
                href="https://techbijay.com"
                target="_blank"
                rel="noopener noreferrer"
                className="text-[#005a9f] hover:text-white transition-colors"
              >
                techbijay.com
              </a>
            </p>
            <div className="flex items-center gap-6 text-sm">
              <Link
                href="/privacy-policy"
                className="text-gray-400 hover:text-white transition-colors"
              >
                Privacy Policy
              </Link>
              <Link
                href="/terms"
                className="text-gray-400 hover:text-white transition-colors"
              >
                Terms & Conditions
              </Link>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
