'use client';

import Image from 'next/image';
import type { Metadata } from 'next';

const testimonials = [
  {
    id: 1,
    name: 'Raj Kumar Poudel',
    company: 'PK Trading House, Kathmandu',
    role: 'Business Owner',
    image: 'https://api.dicebear.com/7.x/avataaars/svg?seed=Raj',
    text: 'Busy software has transformed how we manage our accounting. The GST/VAT billing feature is seamless and saves us hours every week. Highly recommended for any business in Nepal.',
    rating: 5,
  },
  {
    id: 2,
    name: 'Priya Sharma',
    company: 'Tech Solutions Ltd, Pokhara',
    role: 'Finance Manager',
    image: 'https://api.dicebear.com/7.x/avataaars/svg?seed=Priya',
    text: 'The customer support from Neha Infotech is exceptional. They helped us migrate from our old system and provided excellent training. The software is intuitive and our team loves it.',
    rating: 5,
  },
  {
    id: 3,
    name: 'Suresh Adhikari',
    company: 'Manufacturing Industries, Bhaktapur',
    role: 'Accountant',
    image: 'https://api.dicebear.com/7.x/avataaars/svg?seed=Suresh',
    text: 'With Busy 21 Enterprise, managing multiple warehouses and inventory has become effortless. The reporting features are comprehensive and help us make better business decisions.',
    rating: 5,
  },
  {
    id: 4,
    name: 'Anita Ghimire',
    company: 'Fashion Retail Pvt Ltd, Lalitpur',
    role: 'Business Administrator',
    image: 'https://api.dicebear.com/7.x/avataaars/svg?seed=Anita',
    text: 'We switched to Busy on Cloud and now we can access our accounting data from anywhere. The cloud solution is secure, reliable, and perfect for our distributed team.',
    rating: 5,
  },
  {
    id: 5,
    name: 'Dinesh Gautam',
    company: 'Construction Company, Kathmandu',
    role: 'Project Manager',
    image: 'https://api.dicebear.com/7.x/avataaars/svg?seed=Dinesh',
    text: 'Busy software\'s project costing and billing features have helped us track project profitability accurately. The invoice customization options are excellent for maintaining our brand.',
    rating: 5,
  },
  {
    id: 6,
    name: 'Nisha Thapa',
    company: 'Healthcare Services, Kathmandu Valley',
    role: 'Operations Head',
    image: 'https://api.dicebear.com/7.x/avataaars/svg?seed=Nisha',
    text: 'Implementation was smooth and the training provided was comprehensive. Our entire team can now efficiently manage billing and accounting. Great investment for our clinic.',
    rating: 5,
  },
];

function StarRating({ rating }: { rating: number }) {
  return (
    <div className="flex gap-1">
      {[...Array(5)].map((_, i) => (
        <span key={i} className={`text-xl ${i < rating ? 'text-yellow-400' : 'text-gray-300'}`}>
          ★
        </span>
      ))}
    </div>
  );
}

function TestimonialCard({
  name,
  company,
  role,
  image,
  text,
  rating,
}: {
  name: string;
  company: string;
  role: string;
  image: string;
  text: string;
  rating: number;
}) {
  return (
    <div className="bg-white rounded-lg shadow-lg p-8 hover:shadow-xl transition-shadow">
      <StarRating rating={rating} />
      <p className="text-gray-700 mt-4 mb-6 italic">"{text}"</p>
      <div className="flex items-center gap-4">
        <div className="w-12 h-12 rounded-full overflow-hidden bg-gray-200">
          <img src={image} alt={name} className="w-full h-full object-cover" />
        </div>
        <div>
          <p className="font-semibold text-gray-900">{name}</p>
          <p className="text-sm text-gray-600">{role}</p>
          <p className="text-sm text-blue-600">{company}</p>
        </div>
      </div>
    </div>
  );
}

export default function Testimonials() {
  return (
    <div className="min-h-screen bg-gradient-to-b from-blue-50 to-white py-12 px-4 sm:px-6 lg:px-8">
      <div className="max-w-6xl mx-auto">
        <div className="text-center mb-12">
          <h1 className="text-4xl font-bold text-gray-900 mb-4">What Our Clients Say</h1>
          <p className="text-xl text-gray-600 max-w-2xl mx-auto">
            Discover how Busy Accounting Software has helped businesses across Nepal streamline their accounting 
            operations and improve their financial management.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12">
          {testimonials.map((testimonial) => (
            <TestimonialCard key={testimonial.id} {...testimonial} />
          ))}
        </div>

        <div className="bg-gradient-to-r from-blue-600 to-blue-800 text-white rounded-lg p-12 text-center">
          <h2 className="text-3xl font-bold mb-4">Join Hundreds of Satisfied Customers</h2>
          <p className="text-lg mb-8 opacity-90">
            Start your journey towards better accounting management with Busy Software today.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <a
              href="/products"
              className="bg-white text-blue-600 px-8 py-3 rounded-lg font-semibold hover:bg-gray-100 transition-colors"
            >
              View Products
            </a>
            <a
              href="/contact"
              className="border-2 border-white text-white px-8 py-3 rounded-lg font-semibold hover:bg-white hover:text-blue-600 transition-colors"
            >
              Get Started
            </a>
          </div>
        </div>

        <div className="mt-12 grid grid-cols-1 md:grid-cols-3 gap-8 text-center">
          <div className="p-6">
            <p className="text-4xl font-bold text-blue-600">500+</p>
            <p className="text-gray-600 mt-2">Satisfied Customers</p>
          </div>
          <div className="p-6">
            <p className="text-4xl font-bold text-blue-600">10+ Years</p>
            <p className="text-gray-600 mt-2">Industry Experience</p>
          </div>
          <div className="p-6">
            <p className="text-4xl font-bold text-blue-600">24/7</p>
            <p className="text-gray-600 mt-2">Customer Support</p>
          </div>
        </div>
      </div>
    </div>
  );
}
