import type { Metadata } from "next";

export const metadata: Metadata = {
  title: "Terms and Conditions | Busy Nepal",
  description: "Terms and Conditions for Busy Accounting Software services in Nepal. Please read our terms carefully.",
  keywords: ["terms and conditions", "legal", "busy software nepal"],
};

export default function TermsAndConditions() {
  return (
    <div className="min-h-screen bg-gradient-to-b from-blue-50 to-white py-12 px-4 sm:px-6 lg:px-8">
      <div className="max-w-4xl mx-auto">
        <h1 className="text-4xl font-bold text-gray-900 mb-8">Terms and Conditions</h1>
        
        <div className="prose prose-lg max-w-none text-gray-700">
          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">1. Agreement to Terms</h2>
            <p className="mb-4">
              By accessing and using Neha Infotech's website and services, you agree to be bound by these Terms and Conditions. 
              If you do not agree with any part of these terms, you may not use our services.
            </p>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">2. Use License</h2>
            <p className="mb-4">
              Permission is granted to temporarily download one copy of the materials (information or software) from Neha Infotech 
              for personal, non-commercial transitory viewing only. This is the grant of a license, not a transfer of title, and under 
              this license you may not:
            </p>
            <ul className="list-disc list-inside space-y-2 mb-4">
              <li>Modifying or copying the materials</li>
              <li>Using the materials for any commercial purpose or for any public display</li>
              <li>Attempting to decompile or reverse engineer any software contained on the website</li>
              <li>Removing any copyright or other proprietary notations from the materials</li>
              <li>Transferring the materials to another person or "mirroring" the materials on any other server</li>
            </ul>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">3. Disclaimer</h2>
            <p className="mb-4">
              The materials on Neha Infotech's website are provided on an 'as is' basis. Neha Infotech makes no warranties, 
              expressed or implied, and hereby disclaims and negates all other warranties including, without limitation, implied 
              warranties or conditions of merchantability, fitness for a particular purpose, or non-infringement of intellectual 
              property or other violation of rights.
            </p>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">4. Limitations</h2>
            <p className="mb-4">
              In no event shall Neha Infotech or its suppliers be liable for any damages (including, without limitation, damages 
              for loss of data or profit, or due to business interruption) arising out of the use or inability to use the materials 
              on the website, even if Neha Infotech or an authorized representative has been notified orally or in writing of the 
              possibility of such damage.
            </p>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">5. Accuracy of Materials</h2>
            <p className="mb-4">
              The materials appearing on Neha Infotech's website could include technical, typographical, or photographic errors. 
              Neha Infotech does not warrant that any of the materials on its website are accurate, complete, or current. Neha 
              Infotech may make changes to the materials contained on its website at any time without notice.
            </p>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">6. Links</h2>
            <p className="mb-4">
              Neha Infotech has not reviewed all of the sites linked to its website and is not responsible for the contents of 
              any such linked site. The inclusion of any link does not imply endorsement by Neha Infotech of the site. Use of any 
              such linked website is at the user's own risk.
            </p>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">7. Modifications</h2>
            <p className="mb-4">
              Neha Infotech may revise these terms and conditions for its website at any time without notice. By using this website, 
              you are agreeing to be bound by the then current version of these terms and conditions.
            </p>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">8. Governing Law</h2>
            <p className="mb-4">
              These terms and conditions are governed by and construed in accordance with the laws of Nepal, and you irrevocably 
              submit to the exclusive jurisdiction of the courts in that location.
            </p>
          </section>

          <section className="mb-8">
            <h2 className="text-2xl font-semibold text-gray-900 mb-4">9. Contact Information</h2>
            <p className="mb-4">
              If you have any questions about these Terms and Conditions, please contact us at:
            </p>
            <div className="bg-blue-50 p-4 rounded-lg">
              <p><strong>Neha Infotech</strong></p>
              <p>Email: info@busynepal.com</p>
              <p>Phone: +977-9857834143</p>
            </div>
          </section>

          <p className="text-sm text-gray-500 mt-8">
            Last updated: January 26, 2026
          </p>
        </div>
      </div>
    </div>
  );
}
