'use client';

import Link from 'next/link';
import { Button } from '@/components/ui/button';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { ArrowRight, HeadphonesIcon, Settings, GraduationCap, Database, Code, RefreshCw, Shield, FileText, TrendingUp, Users, Zap } from 'lucide-react';

const services = [
  {
    icon: <Settings className="w-8 h-8" />,
    title: 'Software Installation & Setup',
    description: 'Professional installation and configuration of Busy accounting software tailored to your business requirements.',
    features: ['Clean Installation', 'Database Setup', 'Configuration', 'User Training'],
  },
  {
    icon: <GraduationCap className="w-8 h-8" />,
    title: 'Training & Education',
    description: 'Comprehensive training programs for your team to maximize the benefits of Busy accounting software.',
    features: ['On-site Training', 'Online Sessions', 'User Manuals', 'Video Tutorials'],
  },
  {
    icon: <Database className="w-8 h-8" />,
    title: 'Data Migration',
    description: 'Seamless migration from other accounting software to Busy without any data loss or disruption.',
    features: ['Tally to Busy', 'Excel Import', 'Legacy Systems', 'Data Validation'],
  },
  {
    icon: <HeadphonesIcon className="w-8 h-8" />,
    title: '24/7 Technical Support',
    description: 'Round-the-clock technical support to resolve any issues and keep your business running smoothly.',
    features: ['Phone Support', 'Email Support', 'Remote Desktop', 'On-site Visits'],
  },
  {
    icon: <Code className="w-8 h-8" />,
    title: 'Customization',
    description: 'Tailor Busy software to meet your unique business needs with custom reports, templates, and workflows.',
    features: ['Custom Reports', 'Invoice Templates', 'Workflows', 'Integrations'],
  },
  {
    icon: <RefreshCw className="w-8 h-8" />,
    title: 'Regular Updates & Maintenance',
    description: 'Keep your software up-to-date with the latest features, security patches, and tax compliance updates.',
    features: ['Version Updates', 'Security Patches', 'GST Updates', 'Backup Management'],
  },
];

const additionalServices = [
  {
    icon: <Shield className="w-6 h-6" />,
    title: 'GST Compliance',
    description: 'Ensure your business is fully compliant with Nepal GST regulations using our expertise.',
  },
  {
    icon: <FileText className="w-6 h-6" />,
    title: 'Report Generation',
    description: 'Custom financial reports tailored to your business requirements and stakeholder needs.',
  },
  {
    icon: <TrendingUp className="w-6 h-6" />,
    title: 'Business Consulting',
    description: 'Strategic advice on accounting practices and business process optimization.',
  },
  {
    icon: <Users className="w-6 h-6" />,
    title: 'Multi-user Management',
    description: 'Setup and manage user roles, permissions, and access control across your organization.',
  },
  {
    icon: <Zap className="w-6 h-6" />,
    title: 'Performance Optimization',
    description: 'Optimize your accounting software for faster performance and better efficiency.',
  },
];

const Services = () => {
  return (
    <>
        {/* Hero Section */}
      <section className="pt-32 md:pt-40 pb-20 gradient-hero">
        <div className="container-custom">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div className="animate-fade-in">
            <span className="badge badge-blue mb-4 inline-block">Our Services</span>
            <h1 className="text-4xl md:text-5xl font-bold mb-6">
              Comprehensive{' '}
              <span className="text-gradient-primary">Business Solutions</span>
            </h1>
            <p className="text-lg text-gray-600 leading-relaxed">
              Beyond just selling software and renewals, we provide end-to-end services to ensure your
              business runs smoothly with Busy accounting software. From installation to
              ongoing support, we are your trusted <span className="text-gradient-primary">Busy Authorized Partner</span>.
            </p>
          </div>
         <div className="relative animate-fade-in">
              <div className="relative bg-white rounded-2xl shadow-brand-xl p-8">
                <div className="aspect-square bg-gradient-primary rounded-xl flex items-center justify-center overflow-hidden">
                  <img 
                    src="/busy-post3.png" 
                    alt="Busy 21" 
                    className="w-full h-full object-cover"
                  />
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
       
      {/* Main Services */}
      <section className="py-20 bg-white">
        <div className="container-custom">
          <div className="text-center mb-16">
            <span className="badge badge-blue mb-4">Core Services</span>
            <h2 className="text-3xl md:text-4xl font-bold mb-4">What We Offer</h2>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              From installation to support, we provide comprehensive services to meet all your
              accounting software needs.
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            {services.map((service, index) => (
              <Card key={index} className="card-hover shadow-brand border-2 hover:border-[#005a9f] transition-all duration-300">
                <CardHeader>
                  <div className="gradient-primary p-4 rounded-xl text-white w-fit mb-4">
                    {service.icon}
                  </div>
                  <CardTitle className="text-xl mb-2">{service.title}</CardTitle>
                  <CardDescription>{service.description}</CardDescription>
                </CardHeader>
                <CardContent>
                  <ul className="space-y-2">
                    {service.features.map((feature, idx) => (
                      <li key={idx} className="flex items-center gap-2 text-sm">
                        <div className="w-1.5 h-1.5 rounded-full bg-[#005a9f]" />
                        <span className="text-gray-600">{feature}</span>
                      </li>
                    ))}
                  </ul>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Additional Services */}
      <section className="py-20 gradient-hero">
        <div className="container-custom">
          <div className="text-center mb-16">
            <span className="badge badge-blue mb-4">Additional Services</span>
            <h2 className="text-3xl md:text-4xl font-bold mb-4">More Ways We Help</h2>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              We provide additional specialized services to enhance your accounting experience.
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
            {additionalServices.map((service, index) => (
              <Card key={index} className="card-hover shadow-brand border-2 hover:border-[#005a9f] transition-all duration-300">
                <CardHeader>
                  <div className="flex items-start gap-4">
                    <div className="gradient-primary p-2 rounded-lg text-white">
                      {service.icon}
                    </div>
                    <div>
                      <CardTitle className="text-lg mb-2">{service.title}</CardTitle>
                      <CardDescription className="text-sm">{service.description}</CardDescription>
                    </div>
                  </div>
                </CardHeader>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Why Choose Us */}
      <section className="py-20 bg-white">
        <div className="container-custom">
          <div className="text-center mb-16">
            <span className="badge badge-blue mb-4">Why Choose Neha Infotech</span>
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Authorized Busy Partner</h2>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              Experience the difference with our customer-centric approach and expert support.
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div className="text-center">
              <div className="w-20 h-20 mx-auto gradient-primary rounded-full flex items-center justify-center text-white mb-4">
                <Users className="w-10 h-10" />
              </div>
              <h3 className="text-xl font-bold mb-2">1000+ Clients</h3>
              <p className="text-gray-600">Trusted by businesses across Nepal</p>
            </div>

            <div className="text-center">
              <div className="w-20 h-20 mx-auto gradient-secondary rounded-full flex items-center justify-center text-white mb-4">
                <GraduationCap className="w-10 h-10" />
              </div>
              <h3 className="text-xl font-bold mb-2">Expert Team</h3>
              <p className="text-gray-600">Certified professionals with years of experience</p>
            </div>

            <div className="text-center">
              <div className="w-20 h-20 mx-auto gradient-emerald rounded-full flex items-center justify-center text-white mb-4">
                <HeadphonesIcon className="w-10 h-10" />
              </div>
              <h3 className="text-xl font-bold mb-2">24/7 Support</h3>
              <p className="text-gray-600">Always available when you need help</p>
            </div>

            <div className="text-center">
              <div className="w-20 h-20 mx-auto gradient-primary rounded-full flex items-center justify-center text-white mb-4">
                <Shield className="w-10 h-10" />
              </div>
              <h3 className="text-xl font-bold mb-2">Authorized Partner</h3>
              <p className="text-gray-600">Official Busy distributor in Nepal</p>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 gradient-primary text-white">
        <div className="container-custom text-center">
          <h2 className="text-3xl md:text-4xl font-bold mb-6">Ready to Get Started?</h2>
          <p className="text-xl opacity-90 mb-8 max-w-2xl mx-auto">
            Contact us today to discuss your requirements and get a customized solution for your business.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link href="/contact">
              <Button className="bg-white text-[#005a9f] hover:bg-gray-100 rounded-lg px-8 py-6 text-lg font-medium transition-colors">
                Get Free Consultation
                <ArrowRight className="w-5 h-5 ml-2" />
              </Button>
            </Link>
            <Link href="/downloads">
              <Button variant="outline" className="border-white text-white hover:bg-white/10 rounded-lg px-8 py-6 text-lg font-medium transition-colors">
                Download Software
              </Button>
            </Link>
          </div>
        </div>
      </section>
    </>
  );
};

export default Services;
