'use client';

import Link from 'next/link';
import Image from 'next/image';
import { Button } from '@/components/ui/button';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { ArrowRight, CheckCircle2, Star, Users, Shield, Zap, BarChart3, HeadphonesIcon, Download, TrendingUp, Award } from 'lucide-react';

const Home = () => {
  const products = [
    {
      name: 'Busy 21 Basic(Blue)',
      color: 'blue',
      description: 'Perfect for small businesses',
      features: ['Basic Accounting', 'Inventory', 'GST Reports', 'Multi-user'],
    },
    {
      name: 'Busy 21 Standard(Saffron)',
      color: 'saffron',
      description: 'For growing businesses',
      features: ['Advanced Accounting', 'Mobile-App', 'IRD Billing', 'Production'],
    },
    {
      name: 'Busy 21 Enterprise(Emerald)',
      color: 'emerald',
      description: 'For large enterprises',
      features: ['All Features', 'Multi-location', 'IRD Billing', 'Payroll'],
    },
    {
      name: 'Busy on Cloud',
      color: 'blue',
      description: 'Access from anywhere',
      features: ['Cloud-based', 'Real-time Sync', 'IRD-Approved', 'Auto-backup'],
    },
  ];

  const features = [
    {
      icon: <Shield className="w-8 h-8" />,
      title: 'User Friendly & Reliable',
      description: 'BUSY software is very easy to use and more reliable, featuring a straight forward design that allows users to easily navigate and access all its functions. Anyone can use it without any accounting knowledge.This software features an intuitive, clean interface that requires minimal training, allowing anyone to start working productively right away. Behind its simplicity lies a robust and stable core, engineered for day-in, day-out dependability.',
    },
    {
      icon: <Zap className="w-8 h-8" />,
      title: 'Smooth & Fast Performance',
      description: 'Busy Accounting software delivers a remarkably smooth and fast performance, transforming complex financial tasks into swift, seamless workflows. Its optimized engine ensures rapid data processing, instant report generation, and lag-free navigation even with high-volume transactions. Enjoy quick response times, effortless multi-tasking between modules, and reliable stability that keeps your business moving without delays. Designed for speed, Busy empowers you to close books faster, access real-time insights instantly, and focus on growth, not waiting.',
    },
    {
      icon: <BarChart3 className="w-8 h-8" />,
      title: 'IRD Approved',
      description: 'BUSY software has been officially approved by Inland Revenue Department (IRD), Nepal for VAT billing purposes, ensuring its compliance with Nepalese tax regulations for seamless VAT reporting. It generates 100% compliant, digitally signed tax invoices and automates your entire VAT workflow—from calculation to return filing. With Busy, streamline your tax duties, avoid penalties, and gain peace of mind. Stay compliant, the approved way',
    },
    {
      icon: <HeadphonesIcon className="w-8 h-8" />,
      title: '24/7 Support',
      description: 'Never face a challenge alone. Our dedicated round-the-clock support ensures expert help is always just a call or click away, day or night. Whether you have a technical question, need guidance, or require urgent troubleshooting, our responsive team is always ready to provide swift and effective solutions.',
    },
    {
      icon: <TrendingUp className="w-8 h-8" />,
      title: 'Scale with Ease',
      description: 'Grow your business without outgrowing your software. Busy Accounting is engineered to seamlessly scale alongside your operations—from a small startup to a large enterprise. It effortlessly handles increasing transactions, additional users, and more complex processes, ensuring your productivity never hits a ceiling.',
    },
    {
      icon: <Award className="w-8 h-8" />,
      title: 'Trusted by 1000+',
      description: 'Join a growing community of success. Busy Accounting software is the trusted choice for over 1,000 businesses across industries, from startups to established enterprises. This widespread reliance is a testament to its proven reliability, consistent performance, and real-world effectiveness in driving efficiency and growth.',
    },
  ];

  const testimonials = [
    {
      name: 'Maniram Chaudhary',
      company: 'Paschimanchal Hardware Pvt. Ltd',
      position: 'Account Head',
      content: 'Busy accounting software has transformed how we manage our business. The GST compliance features are excellent and support is always helpful.',
      rating: 5,
    },
    {
      name: 'Kuber Oli',
      company: 'Siddharth Hardware Pvt. Ltd',
      position: 'Accountant',
      content: 'The production module in Busy Enterprise is exactly what we needed. It has streamlined our entire manufacturing process.',
      rating: 5,
    },
    {
      name: 'Lal Bdr.KC',
      company: 'Dynamic Traders',
      position: 'Owner',
      content: 'Busy on Cloud allows us to manage our multiple stores from anywhere. The real-time sync is a game-changer for our business.',
      rating: 5,
    },
  ];

  const industries = [
    { name: 'Retail', icon: '🏪' },
    { name: 'Manufacturing', icon: '🏭' },
    { name: 'Trading', icon: '📦' },
    { name: 'Services', icon: '🛠️' },
    { name: 'Distribution', icon: '🚚' },
    { name: 'Pharmaceuticals', icon: '💊' },
  ];

  const getBadgeClass = (color: string) => {
    switch (color) {
      case 'blue':
        return 'badge-blue';
      case 'saffron':
        return 'badge-saffron';
      case 'emerald':
        return 'badge-emerald';
      default:
        return 'badge-blue';
    }
  };

  return (
    <>
      {/* Hero Section */}
      <section className="pt-32 md:pt-40 pb-20 gradient-hero">
        <div className="container-custom">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div className="animate-fade-in">
              <span className="badge badge-blue mb-4 inline-block">Nepal's #1 IRD E-Billing Accounting Software</span>
              <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold leading-tight mb-6">
                Simplify Your{' '}
                <span className="text-gradient-primary">Business</span>{' '}
                with Busy
              </h1>
              <p className="text-lg text-gray-600 mb-8 leading-relaxed">
                BUSY is an VAT(IRD) approved integrated e-billing and accounting software for micro, small & medium enterprises in Nepal. It is easy-to-use, powerful and scalable as per your business needs. BUSY Software is also available on Desktop, Cloud and Mobile App.
              </p>
              <div className="flex flex-col sm:flex-row gap-4">
                <Link href="/downloads">
                  <Button className="bg-[#e05a5a] hover:bg-[#f37474] text-white rounded-lg px-8 py-6 text-lg font-medium transition-colors">
                    <Download className="w-5 h-5 mr-2" />
                    Download Free Trial
                  </Button>
                </Link>
                <Link href="/contact">
                  <Button variant="outline" className="border-[#005a9f] text-[#005a9f] hover:bg-[#005a9f] hover:text-white rounded-lg px-8 py-6 text-lg font-medium transition-colors">
                    Request Demo
                    <ArrowRight className="w-5 h-5 ml-2" />
                  </Button>
                </Link>
              </div>
              <div className="flex items-center gap-8 mt-10">
                <div className="flex items-center gap-2">
                  <Users className="w-5 h-5 text-[#005a9f]" />
                  <span className="text-sm text-gray-600">1000+ Users</span>
                </div>
                <div className="flex items-center gap-2">
                  <Star className="w-5 h-5 text-yellow-500 fill-yellow-500" />
                  <span className="text-sm text-gray-600">4.9 Rating</span>
                </div>
                <div className="flex items-center gap-2">
                  <CheckCircle2 className="w-5 h-5 text-green-500" />
                  <span className="text-sm text-gray-600">Nepal's Authorized Busy Distributor</span>
                </div>
              </div>
            </div>
            <div className="relative animate-fade-in">
              <div className="relative bg-white rounded-2xl shadow-brand-xl p-8">
                <div className="aspect-square bg-gradient-primary rounded-xl flex items-center justify-center overflow-hidden">
                  <Image
                    src="/busy-post.png"
                    alt="Busy 21"
                    width={800}
                    height={600}
                    priority
                    quality={85}
                    sizes="(max-width: 640px) 100vw, (max-width: 1024px) 80vw, 800px"
                    className="w-full h-full object-cover"
                  />
                </div>
              </div>
              {/* Decorative Elements */}
              <div className="absolute -top-4 -right-4 w-24 h-24 bg-[#fca265]/20 rounded-full blur-xl" />
              <div className="absolute -bottom-4 -left-4 w-32 h-32 bg-[#79c251]/20 rounded-full blur-xl" />
            </div>
          </div>
        </div>
      </section>

      {/* Products Section */}
      <section className="py-20 bg-white">
        <div className="container-custom">
          <div className="text-center mb-16">
            <span className="badge badge-blue mb-4">Our Products</span>
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Choose Your Perfect Plan</h2>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              From small startups to large enterprises, we have the right accounting solution for every business size.
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
            {products.map((product, index) => (
              <Card
                key={index}
                className="card-hover border-2 hover:border-[#005a9f] transition-all duration-300"
              >
                <CardHeader>
                  <div className={`badge ${getBadgeClass(product.color)} mb-4 inline-block`}>
                    {product.name}
                  </div>
                  <CardTitle className="text-xl">{product.name}</CardTitle>
                  <CardDescription>{product.description}</CardDescription>
                </CardHeader>
                <CardContent>
                  <ul className="space-y-3">
                    {product.features.map((feature, idx) => (
                      <li key={idx} className="flex items-start gap-2">
                        <CheckCircle2 className="w-4 h-4 text-green-500 mt-0.5 flex-shrink-0" />
                        <span className="text-sm">{feature}</span>
                      </li>
                    ))}
                  </ul>
                  <Link href="/products" className="block mt-6">
                    <Button variant="outline" className="w-full border-[#005a9f] text-[#005a9f] hover:bg-[#005a9f] hover:text-white transition-colors">
                      Learn More
                      <ArrowRight className="w-4 h-4 ml-2" />
                    </Button>
                  </Link>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section className="py-20 gradient-hero">
        <div className="container-custom">
          <div className="text-center mb-16">
            <span className="badge badge-blue mb-4">Why Choose Busy Software</span>
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Most Trusted & Best e-Billing IRD Approved Software in Nepal</h2>
            <p className="text-lg text-gray-600 max-w-5xl mx-auto">
              BUSY is the most feature-rich, easy-to-use accounting software that is loved by business owners & accountants alike. Busy21 Accounting Software has established itself as a cornerstone financial management solution for Nepali businesses, particularly small and medium enterprises (SMEs), by offering a robust suite of features that directly address the nuanced challenges of the local market. Its extraordinariness lies not in flashy, generic tools but in its deep understanding of the Nepali regulatory and operational landscape. The software is meticulously built around the Nepali Fiscal Year (Shrawan to Ashad). Have a look at some of the key BUSY Features And FAQs that make BUSY Nepal’s No. 1 VAT Accounting Software for businesses.
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            {features.map((feature, index) => (
              <Card key={index} className="card-hover shadow-brand">
                <CardHeader>
                  <div className="w-16 h-16 gradient-primary rounded-xl flex items-center justify-center text-white mb-4">
                    {feature.icon}
                  </div>
                  <CardTitle className="text-xl">{feature.title}</CardTitle>
                  <CardDescription>{feature.description}</CardDescription>
                </CardHeader>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Industries Section */}
      <section className="py-20 bg-white">
        <div className="container-custom">
          <div className="text-center mb-16">
            <span className="badge badge-blue mb-4">Industries We Serve</span>
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Trusted Across Multiple Industries</h2>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              Busy accounting software is designed to meet the unique needs of various industries.
            </p>
          </div>

          <div className="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-6">
            {industries.map((industry, index) => (
              <Card
                key={index}
                className="card-hover text-center p-6 border-2 hover:border-[#005a9f] transition-all duration-300"
              >
                <CardContent className="p-0">
                  <div className="text-4xl mb-3">{industry.icon}</div>
                  <h3 className="font-semibold text-sm">{industry.name}</h3>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Major Places Section */}
      <section className="py-20 gradient-hero">
        <div className="container-custom">
          <div className="text-center mb-16">
            <span className="badge badge-blue mb-4">Our Coverage</span>
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Major Places Where We are Available in Nepal</h2>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              We Provide Busy All Over Nepal, Some of the Major Places are
            </p>
          </div>

          <div className="flex flex-wrap gap-3 justify-center">
            {['Kathmandu', 'Pokhara', 'Birgunj', 'Biratnagar', 'Jhapa', 'Banke', 'Dang'].map((place, index) => (
              <Button
                key={index}
                className="bg-[#005a9f]/40 hover:bg-[#005a9f]/60 text-white border-0 px-5 py-2 rounded-full text-sm font-medium transition-all duration-300"
              >
                {place}
              </Button>
            ))}
          </div>
        </div>
      </section>

      {/* Testimonials Section */}
      <section className="py-20 gradient-hero">
        <div className="container-custom">
          <div className="text-center mb-16">
            <span className="badge badge-blue mb-4">Testimonials</span>
            <h2 className="text-3xl md:text-4xl font-bold mb-4">What Our Clients Say</h2>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              Hear from businesses that have transformed their operations with Busy accounting software.
            </p>
          </div>

          <div className="grid md:grid-cols-3 gap-8">
            {testimonials.map((testimonial, index) => (
              <Card key={index} className="card-hover shadow-brand">
                <CardHeader>
                  <div className="flex items-center gap-1 mb-3">
                    {[...Array(testimonial.rating)].map((_, i) => (
                      <Star key={i} className="w-5 h-5 text-yellow-500 fill-yellow-500" />
                    ))}
                  </div>
                  <p className="text-gray-600 leading-relaxed">{testimonial.content}</p>
                </CardHeader>
                <CardContent>
                  <div>
                    <h4 className="font-semibold text-lg">{testimonial.name}</h4>
                    <p className="text-sm text-gray-500">
                      {testimonial.position}, {testimonial.company}
                    </p>
                  </div>
                </CardContent>
              </Card>
            ))}
          </div>

          <div className="text-center mt-12">
            <Link href="/contact">
              <Button className="bg-[#e05a5a] hover:bg-[#f37474] text-white rounded-lg px-8 py-6 font-medium transition-colors">
                Join Our Success Stories
                <ArrowRight className="w-5 h-5 ml-2" />
              </Button>
            </Link>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 gradient-primary text-white">
        <div className="container-custom text-center">
          <h2 className="text-3xl md:text-4xl font-bold mb-6">Ready to Transform Your Business?</h2>
          <p className="text-xl opacity-90 mb-8 max-w-2xl mx-auto">
            Join thousands of businesses in Nepal using Busy accounting software to manage their finances efficiently.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link href="/downloads">
              <Button className="bg-white text-[#005a9f] hover:bg-gray-100 rounded-lg px-8 py-6 text-lg font-medium transition-colors">
                <Download className="w-5 h-5 mr-2" />
                Download Free Trial
              </Button>
            </Link>
            <Link href="/contact">
              <Button variant="outline" className="border-white text-white hover:bg-white hover:text-[#005a9f] rounded-lg px-8 py-6 text-lg font-medium transition-colors">
                Talk to an Expert
              </Button>
            </Link>
          </div>
        </div>
      </section>
    </>
  );
};

export default Home;
