# Admin Dashboard - Feature Architecture

## Dashboard Overview

```
┌─────────────────────────────────────────────────────────────────┐
│                     ADMIN DASHBOARD                             │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  ┌─────────────────────────────────────────────────────────┐   │
│  │              Statistics Panel (4 Cards)                 │   │
│  ├─────────────────────────────────────────────────────────┤   │
│  │ │ Contact │ │ Downloads │ │ Pages (NEW) │ │ Blog (NEW) │   │
│  │ │ Messages│ │Registrations│ │           │ │  Posts    │   │
│  │ │   123   │ │    45     │ │     8      │ │    12     │   │
│  └─────────────────────────────────────────────────────────┘   │
│                                                                 │
│  ┌─────────────────────────────────────────────────────────┐   │
│  │              Tabs Navigation (4 Tabs)                   │   │
│  ├─────────────────────────────────────────────────────────┤   │
│  │ 💬 Messages │ 📥 Registrations │ 📄 Pages │ 📖 Blog    │   │
│  └─────────────────────────────────────────────────────────┘   │
│                                                                 │
│  ┌─────────────────────────────────────────────────────────┐   │
│  │          Active Tab Content (Responsive Grid)           │   │
│  ├─────────────────────────────────────────────────────────┤   │
│  │                                                          │   │
│  │  ┌──────────────────────┐  ┌─────────────────┐         │   │
│  │  │  List Panel          │  │  Details Panel  │         │   │
│  │  │  (2/3 width)         │  │  (1/3 width)    │         │   │
│  │  │                      │  │                 │         │   │
│  │  │  ├─ Item 1          │  │  ┌─────────────┐│         │   │
│  │  │  ├─ Item 2  (sel)   │  │  │ Details of  ││         │   │
│  │  │  ├─ Item 3          │  │  │ Selected    ││         │   │
│  │  │  └─ ...             │  │  │ Item        ││         │   │
│  │  │                      │  │  │             ││         │   │
│  │  │                      │  │  │ Edit Button ││         │   │
│  │  │                      │  │  │ Delete Btn  ││         │   │
│  │  │                      │  │  └─────────────┘│         │   │
│  │  └──────────────────────┘  └─────────────────┘         │   │
│  │                                                          │   │
│  └─────────────────────────────────────────────────────────┘   │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

## Pages Tab Architecture

```
┌─ PAGES TAB ────────────────────────────────────────────────────┐
│                                                                 │
│  [NEW PAGE] Button                                              │
│                                                                 │
│  ┌──────────────────────────────┐  ┌──────────────────────┐   │
│  │  PAGES LIST                  │  │  DETAILS PANEL       │   │
│  ├──────────────────────────────┤  ├──────────────────────┤   │
│  │                              │  │                      │   │
│  │  📄 About Us                 │  │ Title: About Us      │   │
│  │     /about                   │  │ Slug: /about         │   │
│  │     🎨 Visual | 2024-01-20   │  │ Editor: Visual       │   │
│  │                              │  │ Created: 2024-01-20  │   │
│  │  📄 Services (selected)      │  │                      │   │
│  │     /services                │  │ [EDIT] [DELETE]      │   │
│  │     💻 Code | 2024-01-19     │  │                      │   │
│  │                              │  └──────────────────────┘   │
│  │  📄 Contact                  │                              │
│  │     /contact                 │                              │
│  │     🎨 Visual | 2024-01-18   │                              │
│  │                              │                              │
│  └──────────────────────────────┘                              │
│                                                                 │
└────────────────────────────────────────────────────────────────┘
```

## Blog Tab Architecture

```
┌─ BLOG TAB ─────────────────────────────────────────────────────┐
│                                                                 │
│  [NEW POST] Button                                              │
│                                                                 │
│  ┌──────────────────────────────┐  ┌──────────────────────┐   │
│  │  BLOG POSTS LIST             │  │  DETAILS PANEL       │   │
│  ├──────────────────────────────┤  ├──────────────────────┤   │
│  │                              │  │                      │   │
│  │  📝 VAT Guide                │  │ Title: VAT Guide     │   │
│  │     Complete guide to VAT...  │  │ Slug: vat-guide      │   │
│  │     [VAT] 2024-01-20 | 8 min │  │ Category: VAT       │   │
│  │     🎨 Visual                │  │ Published: 2024-01  │   │
│  │                              │  │ Read Time: 8 min     │   │
│  │  📝 Busy Benefits            │  │                      │   │
│  │     Top 10 benefits of...     │  │ [EDIT] [DELETE]      │   │
│  │     [Accounting] 2024-01-19   │  │                      │   │
│  │     💻 Code                  │  │                      │   │
│  │                              │  │                      │   │
│  │  📝 Busy vs Tally            │  │                      │   │
│  │     Comparison review...      │  │                      │   │
│  │     [Comparison] 2024-01-18   │  │                      │   │
│  │     🎨 Visual                │  │                      │   │
│  │                              │  │                      │   │
│  └──────────────────────────────┘  └──────────────────────┘   │
│                                                                 │
└────────────────────────────────────────────────────────────────┘
```

## Modal Dialogs

### Page Creation Modal
```
┌─────────────────────────────────────────────────────┐
│ Create New Page                        [✕] Close    │
├─────────────────────────────────────────────────────┤
│                                                     │
│ Page Title: [_________________________]            │
│ URL Slug:  [_________________________]            │
│                                                     │
│ ┌─ Editor Tabs ──────────────────────────────────┐ │
│ │ 🎨 Visual Editor │ 💻 Code Editor             │ │
│ ├────────────────────────────────────────────────┤ │
│ │                                                │ │
│ │ Page Content:                                 │ │
│ │ [                                           ]  │ │
│ │ [        Enter content here...               ]  │ │
│ │ [                                           ]  │ │
│ │                                                │ │
│ │ Supports: plain text, markdown, HTML         │ │
│ │                                                │ │
│ └────────────────────────────────────────────────┘ │
│                                                     │
│ [Cancel]  [Create Page]                            │
│                                                     │
└─────────────────────────────────────────────────────┘
```

### Blog Post Modal
```
┌──────────────────────────────────────────────────────┐
│ Create New Blog Post                    [✕] Close    │
├──────────────────────────────────────────────────────┤
│                                                      │
│ Post Title: [_______________________________]       │
│                                                      │
│ URL Slug: [_____________]  Category: [VAT ▼]       │
│                                                      │
│ Excerpt: [_________________________________]       │
│          [________________________________]       │
│                                                      │
│ ┌─ Editor Tabs ─────────────────────────────────┐  │
│ │ 🎨 Visual Editor │ 💻 Code Editor            │  │
│ ├───────────────────────────────────────────────┤  │
│ │                                               │  │
│ │ Post Content:                                 │  │
│ │ [                                           ]  │  │
│ │ [        Write your blog post here...       ]  │  │
│ │ [                                           ]  │  │
│ │                                               │  │
│ │ Supports: markdown, HTML, JSX/TSX           │  │
│ │                                               │  │
│ └───────────────────────────────────────────────┘  │
│                                                      │
│ [Cancel]  [Create Post]                             │
│                                                      │
└──────────────────────────────────────────────────────┘
```

## Component Hierarchy

```
AdminDashboard (page.tsx)
├── State Management
│   ├── contactMessages
│   ├── downloads
│   ├── pages ← NEW
│   ├── blogPosts ← NEW
│   ├── pageModalOpen ← NEW
│   └── blogModalOpen ← NEW
│
├── Tabs Container
│   ├── Tab 1: Contacts (existing)
│   ├── Tab 2: Downloads (existing)
│   ├── Tab 3: Pages ← NEW
│   │   └── PagesTab Component ← NEW
│   │       ├── List Panel
│   │       ├── Details Panel
│   │       ├── [New Page] Button
│   │       ├── [Edit] Button
│   │       └── [Delete] Button
│   │
│   └── Tab 4: Blog ← NEW
│       └── BlogTab Component ← NEW
│           ├── List Panel
│           ├── Details Panel
│           ├── [New Post] Button
│           ├── [Edit] Button
│           └── [Delete] Button
│
├── PageCreateModal ← NEW
│   ├── Title Input
│   ├── Slug Input
│   ├── Editor Tabs
│   │   ├── Visual Editor
│   │   └── Code Editor
│   └── Submit Handler
│
└── BlogPostModal ← NEW
    ├── Title Input
    ├── Slug Input
    ├── Category Select
    ├── Excerpt Textarea
    ├── Editor Tabs
    │   ├── Visual Editor
    │   └── Code Editor
    └── Submit Handler
```

## Data Flow

### Creating a Page
```
User clicks "New Page"
    ↓
PageCreateModal opens
    ↓
User fills form data
    ↓
User selects editor type
    ↓
User clicks "Create Page"
    ↓
POST /api/admin/pages
    ↓
API returns new page
    ↓
setPages([...pages, newPage])
    ↓
PagesTab updates with new item
    ↓
Modal closes
    ↓
Confirmation displayed
```

### Creating a Blog Post
```
User clicks "New Post"
    ↓
BlogPostModal opens
    ↓
User fills form data
    ↓
User selects category & editor type
    ↓
User clicks "Create Post"
    ↓
POST /api/admin/blog
    ↓
API returns new post
    ↓
setBlogPosts([...blogPosts, newPost])
    ↓
BlogTab updates with new item
    ↓
Modal closes
    ↓
Confirmation displayed
```

### Editing a Blog Post
```
User selects a blog post
    ↓
setSelectedPost(post)
    ↓
User clicks "Edit Post"
    ↓
BlogPostModal opens with editData
    ↓
Form pre-fills with current data
    ↓
User modifies content
    ↓
User clicks "Update Post"
    ↓
PUT /api/admin/blog (with id)
    ↓
API returns updated post
    ↓
setBlogPosts(updated array)
    ↓
Modal closes
    ↓
Success message displayed
```

## Editor Type Switching

```
User selects "Visual Editor"
    ↓
Display textarea with placeholder:
"Supports plain text, markdown, HTML"
    ↓
User enters content
    ↓
[CREATE/UPDATE] submits content as-is
    ↓
Content stored with editorType: 'visual'

---

User selects "Code Editor"
    ↓
Display textarea with placeholder:
"Enter your JSX/TSX code here..."
    ↓
User enters React component code
    ↓
[CREATE/UPDATE] submits code as-is
    ↓
Content stored with editorType: 'code'
```

## Category Colors (Blog)

```
Accounting        → Blue background
VAT Compliance    → Purple background
Inventory         → Green background
Reports           → Orange background
Migration         → Red background
Comparison        → Pink background
```
