# Admin Dashboard - Page & Blog Management Features

## Overview

The Admin Dashboard has been enhanced with comprehensive page and blog management capabilities. Users can now create, edit, and delete pages and blog posts with both visual and code-based editors.

## Features

### 1. **Pages Management**

#### Overview
- View all created pages in a centralized dashboard
- Create new pages with custom URLs and content
- Edit existing pages
- Delete pages with confirmation

#### Capabilities
- **Dual Editor Options:**
  - **Visual Editor**: Write content in plain text, markdown, or basic HTML
  - **Code Editor**: Write JSX/TSX React components for custom page layouts

- **Page Properties:**
  - Title: Main heading for the page
  - URL Slug: Custom URL path (auto-generated from title)
  - Content: Page body content
  - Editor Type: Visual or Code-based
  - Created Date: Timestamp of creation

#### How to Create a Page

1. Navigate to the **Pages** tab in the Admin Dashboard
2. Click **"New Page"** button
3. Enter page details:
   - Page Title (e.g., "Services", "FAQ")
   - URL Slug (auto-filled, editable)
   - Content (in chosen editor)
4. Choose editor type:
   - Visual Editor: For markdown and HTML content
   - Code Editor: For React/JSX components
5. Click **"Create Page"**

#### How to Edit a Page

1. In the **Pages** tab, click on a page from the list
2. Click **"Edit Page"** button in the details panel
3. Update the content and settings
4. Click **"Save Changes"**

#### How to Delete a Page

1. In the **Pages** tab, select a page
2. Click **"Delete Page"** in the details panel
3. Confirm deletion when prompted

---

### 2. **Blog Management**

#### Overview
- Create and manage blog posts with full control over content
- Organize posts by categories
- Edit published posts
- Track blog metrics (read time, publication date)

#### Capabilities
- **Dual Editor Options:**
  - **Visual Editor**: Write articles in markdown or HTML
  - **Code Editor**: Create complex post layouts with React components

- **Blog Post Properties:**
  - Title: Article headline
  - URL Slug: Post URL path (auto-generated)
  - Excerpt: Brief summary (shown in blog listings)
  - Content: Full article body
  - Category: Organize posts (Accounting, VAT Compliance, Inventory, Reports, Migration, Comparison)
  - Editor Type: Visual or Code-based
  - Published Date: Automatic timestamp
  - Read Time: Auto-calculated from content

#### Available Categories
- Accounting
- VAT Compliance
- Inventory
- Reports
- Migration
- Comparison

#### How to Create a Blog Post

1. Navigate to the **Blog** tab in the Admin Dashboard
2. Click **"New Post"** button
3. Fill in post details:
   - Post Title (e.g., "Complete Guide to VAT in Nepal")
   - URL Slug (auto-filled, editable)
   - Category (select from dropdown)
   - Excerpt (brief summary, 2-3 sentences)
   - Full Content
4. Choose editor type:
   - Visual Editor: For markdown and HTML content
   - Code Editor: For React/JSX components
5. Click **"Create Post"**

#### How to Edit a Blog Post

1. In the **Blog** tab, click on a post from the list
2. Click **"Edit Post"** button
3. Modify content and metadata
4. Click **"Update Post"**

#### How to Delete a Blog Post

1. In the **Blog** tab, select a post
2. Click **"Delete Post"** in the details panel
3. Confirm deletion

---

## Dashboard Statistics

The dashboard displays four key metrics:

| Metric | Icon | Color |
|--------|------|-------|
| Contact Messages | 💬 | Blue |
| Download Registrations | 📥 | Green |
| Pages | 📄 | Purple |
| Blog Posts | 📖 | Orange |

---

## Editor Types

### Visual Editor
- **Best for**: Blog posts, articles, and general content pages
- **Supports**:
  - Plain text
  - Markdown formatting
  - Basic HTML tags
- **Use cases**:
  - Blog articles
  - Product descriptions
  - FAQ pages
  - Documentation

### Code Editor
- **Best for**: Custom layouts and complex components
- **Supports**:
  - JSX/TSX syntax
  - React components
  - Advanced styling and interactivity
- **Use cases**:
  - Custom landing pages
  - Interactive content
  - Specialized page layouts
  - Integration with React libraries

---

## API Endpoints

### Pages API

```
GET    /api/admin/pages           - List all pages
POST   /api/admin/pages           - Create new page
PUT    /api/admin/pages/[id]      - Update page
DELETE /api/admin/pages/[id]      - Delete page
```

### Blog API

```
GET    /api/admin/blog            - List all blog posts
POST   /api/admin/blog            - Create new post
PUT    /api/admin/blog            - Update post
DELETE /api/admin/blog/[id]       - Delete post
```

---

## Data Structure

### Page Object
```typescript
{
  id: string;
  title: string;
  slug: string;
  content: string;
  editorType: 'visual' | 'code';
  createdAt: string;
}
```

### Blog Post Object
```typescript
{
  id: string;
  title: string;
  slug: string;
  excerpt: string;
  content: string;
  category: string;
  editorType: 'visual' | 'code';
  createdAt: string;
}
```

---

## Workflow Example

### Creating a Blog Post About VAT Compliance

1. **Navigate to Blog Tab**
   - Click the Blog icon in the tab list

2. **Create New Post**
   - Click "New Post" button

3. **Fill in Details**
   - Title: "Complete Guide to VAT in Nepal"
   - Slug: "complete-guide-to-vat-nepal" (auto-filled)
   - Category: "VAT Compliance"
   - Excerpt: "Learn everything about VAT registration, filing, and compliance in Nepal with practical examples and tips."

4. **Write Content**
   - Choose Visual Editor for markdown content
   - Write your article with headers, lists, and emphasis
   - Or choose Code Editor for custom React layout

5. **Create the Post**
   - Click "Create Post"
   - Post appears in blog listing
   - Auto-linked to blog page

6. **Later Edits**
   - Select the post from the list
   - Click "Edit Post"
   - Update content
   - Click "Update Post"

---

## Best Practices

### For Pages
- Use meaningful slugs that reflect page content
- Keep titles concise (2-5 words)
- Use Visual Editor for most content
- Use Code Editor only for complex layouts

### For Blog Posts
- Write compelling excerpts (attracts readers)
- Use appropriate categories for organization
- Keep read time under 10 minutes for optimal engagement
- Use Visual Editor for standard articles
- Include relevant keywords in title and content
- Update or expand old posts when information changes

### Content Quality
- Proofread before publishing
- Use clear headings and structure
- Break long content into sections
- Include examples where applicable
- Add call-to-action when relevant

---

## Technical Notes

### Current Implementation
- Uses in-memory storage for demonstration
- **For production**: Replace with database (Prisma ORM recommended)
- Includes basic data validation
- Implements confirmation dialogs for destructive actions

### Future Enhancements
- Database persistence (recommend using Prisma with PostgreSQL/MySQL)
- Rich text editor (tiptap or similar)
- Image upload capability
- SEO metadata management
- Publish scheduling
- Post versioning/history
- Comments and ratings
- Draft/published states
- Author attribution
- Performance optimization

---

## Troubleshooting

### Pages not loading
- Check API endpoint is accessible
- Verify network connection
- Check browser console for errors

### Changes not saving
- Ensure all required fields are filled
- Check file content isn't empty
- Verify no special characters causing issues

### Slugs not auto-generating
- Check for special characters in title
- Title must be at least 3 characters
- Slugs are lowercase with hyphens

---

## Support

For issues or feature requests:
1. Check this documentation
2. Review API responses in browser DevTools
3. Verify data format matches schema
4. Contact development team with specific error messages
